/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.easmeta;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.QueryContext;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableRowDataProcessor;
import com.kingdee.bos.qing.api.customtable.model.Scene;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.extension.manager.IExtensionClassProvider;
import com.kingdee.bos.qing.common.extension.manager.QingExtensionConfig;
import com.kingdee.bos.qing.common.extension.manager.QingExtensionLoader;
import com.kingdee.bos.qing.data.domain.exception.DataEntityException;
import com.kingdee.bos.qing.data.domain.exception.DataMetaException;
import com.kingdee.bos.qing.data.domain.fixprocessor.EASFixEntityFilterItemWithParentRuntimeProcess;
import com.kingdee.bos.qing.data.domain.fixprocessor.EASFixTreePropertyRuntimeProcess;
import com.kingdee.bos.qing.data.domain.scanAllEntity.EntityScanDomain;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.bizmeta.AbstractBizMetaSourceDomain;
import com.kingdee.bos.qing.data.domain.source.dataset.CalcDataRowCountCallBack;
import com.kingdee.bos.qing.data.domain.source.dataset.DataPreviewCallBack;
import com.kingdee.bos.qing.data.domain.source.dataset.EASEntityDataSetHandler;
import com.kingdee.bos.qing.data.domain.source.dataset.EASEntityExtractDataSet;
import com.kingdee.bos.qing.data.domain.source.dataset.EASEntityPreviewDataSet;
import com.kingdee.bos.qing.data.domain.source.dataset.IRowDataHandleCallBack;
import com.kingdee.bos.qing.data.domain.source.dataset.WriteRowDataCallBack;
import com.kingdee.bos.qing.data.domain.source.entityviewbuilder.RTQueryJoinCollectionBuilder;
import com.kingdee.bos.qing.data.domain.source.entityviewbuilder.SelectFieldCollectionBuilder;
import com.kingdee.bos.qing.data.domain.source.entityviewbuilder.SqlFilterInfoBuilder;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.SubjectDataModelingException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.IEntityExtensionProvider;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import com.kingdee.bos.qing.data.model.designtime.source.MetaSource;
import com.kingdee.bos.qing.data.model.runtime.EasEntityExtension;
import com.kingdee.bos.qing.data.model.runtime.EasEntityExtensionProvider;
import com.kingdee.bos.qing.data.model.runtime.EasRuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.MetaCompareFilter;
import com.kingdee.bos.qing.data.model.runtime.MetaLogicalFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.runtime.process.IParentEntityFilterProcessor;
import com.kingdee.bos.qing.data.model.runtime.process.ITreePropertyProcessor;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.util.PropertyAssociateNameKeySelector;
import com.kingdee.bos.qing.datasource.DataSourceCloseListener;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.view.AbstractDSViewItem;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaEntitySubView;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaFieldItem;
import com.kingdee.bos.qing.datasource.spec.IDataSourceCloseListener;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.IQsDataSourceClosable;
import com.kingdee.bos.qing.extension.local.EASExtensionProviderFactory;
import com.kingdee.bos.qing.extension.local.TableDataProcessorGroup;
import com.kingdee.bos.qing.extension.local.TableMetaProcessorGroup;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.subject.QingPermissionException;
import com.kingdee.bos.qing.subject.SubjectModelingService;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractMetaSourceDomain
extends AbstractBizMetaSourceDomain {
    private static final HashMap<String, DesigningDataType> dataTypeMap = new HashMap();

    public static DesigningDataType toDesigningDataType(String bosTypeName) {
        return dataTypeMap.get(bosTypeName);
    }

    protected IMetaDataLoader getDataLoader(Context ctx) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractSourceException, AbstractQingIntegratedException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return new PreviewDataModel(result);
        }
        IDataProvider exec = this.getExecutorForNew(qingContext, runtimeEntity);
        String sql = "";
        try {
            sql = exec.getSQL();
            LogUtil.error((String)("+++++++++++++++++++++AbstractMetaSourceDomain++++++++++++++++++\u5efa\u6a21\u754c\u9762sql:" + exec.getSQL()));
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        IRowSet rs = null;
        try {
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            int maxRows = Math.min(manager.getCriticalIDList(), 1000);
            int startRow = 0;
            do {
                rs = exec.executeQuery(startRow, maxRows);
                this.getPreviewResult(qingContext, rs, runtimeEntity, result, rows);
                if (result.size() == rows) break;
                startRow += maxRows;
            } while (rs.size() == maxRows);
        }
        catch (BOSException e) {
            try {
                String msg = "execute failed:" + e.getMessage();
                throw DataMetaException.fail2Preview(e, msg);
                catch (SQLException e2) {
                    msg = "get result failed.";
                    throw DataMetaException.fail2Preview(e2, msg);
                }
                catch (Exception e3) {
                    msg = "get result failed:" + e3.getMessage();
                    throw DataMetaException.fail2Preview(e3, msg);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(rs);
                throw throwable;
            }
        }
        CloseUtil.close((ResultSet)rs);
        PreviewDataModel previewDataModel = new PreviewDataModel(result);
        previewDataModel.setSqlContent(sql);
        return previewDataModel;
    }

    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, AbstractQingIntegratedException {
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return null;
        }
        IDataProvider exec = this.getExecutorForNew(qingContext, runtimeEntity);
        try {
            this.queryAndWriteDatas(exec, runtimeEntity, qingContext, progressProcessor, dataSourceWriter);
            this.addMetaInfoFixerBeforeCloseWriting(runtimeEntity, dataSourceWriter);
        }
        catch (AbstractSourceException e) {
            String msg = "get result failed:" + e.getMessage();
            throw DataMetaException.fail2Extract(e, msg);
        }
        catch (AbstractQingIntegratedException e) {
            String msg = "get result failed:" + e.getMessage();
            throw DataMetaException.fail2Extract(e, msg);
        }
        return null;
    }

    public void queryAndWriteDatas(IDataProvider exec, RuntimeEntity runtimeEntity, QingContext qingContext, ProgressProcessor progressProcessor, IDataSourceWriter dataSourceWriter) throws AbstractSourceException, AbstractQingIntegratedException {
        ResultSet rs = null;
        Connection conn = null;
        Context context = ((QingIntegratedContext)qingContext).getBosContext();
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)context);
            String sql = exec.getSQL();
            if (progressProcessor != null) {
                progressProcessor.setTotalRows((long)exec.getRowCount());
            }
            statement = conn.createStatement();
            statement.setFetchSize(100);
            rs = statement.executeQuery(sql);
            EASEntityExtractDataSet dataSet = new EASEntityExtractDataSet(rs, this.buildAssociateToRsNameRelation(context, exec, runtimeEntity));
            IQingTableRowDataProcessor rowDataProcessor = this.getTableDataProcessor(qingContext, runtimeEntity);
            WriteRowDataCallBack dataHandleCallBack = new WriteRowDataCallBack(dataSourceWriter, runtimeEntity, progressProcessor);
            EASEntityDataSetHandler dataSetHandler = new EASEntityDataSetHandler(rowDataProcessor, (IRowDataHandleCallBack)dataHandleCallBack);
            dataSetHandler.processDataSet(runtimeEntity, dataSet);
        }
        catch (Exception e) {
            try {
                throw DataEntityException.fail2Extract(e, e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
    }

    public void fixEntityExtension(QingContext qingContext, Entity local, DesigntimeDataObject designtimeDataObject) {
        Entity myLiveEntity = designtimeDataObject.getEntityByAssosiateName(local.getAssociateName());
        if (null == myLiveEntity) {
            local.setExtensionProvider((IEntityExtensionProvider)new EasEntityExtensionProvider(new EasEntityExtension()));
            return;
        }
        EasEntityExtension liveExtension = (EasEntityExtension)myLiveEntity.getExtension(EasEntityExtension.class);
        EasEntityExtension extensionCopy = liveExtension.makeCopy();
        local.setExtensionProvider((IEntityExtensionProvider)new EasEntityExtensionProvider(extensionCopy));
    }

    private void syncTreePropertyFromLiveEntity(Entity local, Entity myLiveEntity) {
        ArrayList<TreeProperty> treeProperties = new ArrayList<TreeProperty>();
        List liveTreeProps = myLiveEntity.getTreeNodeProperties();
        for (TreeProperty liveTreeProp : liveTreeProps) {
            Property localProp = local.getPropertyByAssociateName(liveTreeProp.getInnerProp().getAssociateName());
            if (null == localProp) continue;
            TreeProperty localTreeProperty = new TreeProperty(localProp, liveTreeProp.createCopyChildren(), liveTreeProp.getTreeType());
            treeProperties.add(localTreeProperty);
        }
        local.setTreeNodeProperties(treeProperties);
    }

    public RuntimeEntity newRuntimeEntity(AbstractEntity designtimeDataObject, Map<String, AbstractEntity> entityMap, Set<String> whitePropertySet, AbstractSource source, QingContext qingContext, String ownerId) {
        EasRuntimeEntity runtimeEntity = new EasRuntimeEntity(designtimeDataObject, whitePropertySet, source, qingContext, ownerId);
        if (entityMap == null) {
            return runtimeEntity;
        }
        String parentName = designtimeDataObject.getParentName();
        EasRuntimeEntity runtimeEntityTemp = runtimeEntity;
        AbstractEntity parentEntity = null;
        while (null != parentName) {
            parentEntity = entityMap.get(parentName);
            parentName = parentEntity.getParentName();
            RuntimeEntity parentRuntimeEntity = this.newRuntimeEntity(parentEntity, entityMap, whitePropertySet, source, qingContext, ownerId);
            parentRuntimeEntity.init(null);
            runtimeEntityTemp.setParentEntity(parentRuntimeEntity);
            runtimeEntityTemp = (EasRuntimeEntity)parentRuntimeEntity;
        }
        return runtimeEntity;
    }

    private void addMetaInfoFixerBeforeCloseWriting(RuntimeEntity runtimeEntity, IDataSourceWriter dataSourceWriter) {
        if (!(dataSourceWriter instanceof IQsDataSourceClosable)) {
            return;
        }
        IQsDataSourceClosable dataSourceClosable = (IQsDataSourceClosable)dataSourceWriter;
        dataSourceClosable.addBeforeCloseListener((IDataSourceCloseListener)new DataSourceCloseListener(runtimeEntity));
    }

    public void fixRuntimeExtractModeDSMetaEntity(AbstractEntity entity, DSMetaEntity dsMetaEntity, MetaInfo metaInfo) {
        List subViews = metaInfo.getSubViews();
        if (null == subViews) {
            return;
        }
        Map propertyMap = MapUtils.collectionToMap((Collection)dsMetaEntity.getProperties(), (MapUtils.IMapKeySelector)new MapUtils.IMapKeySelector<DSMetaProperty>(){

            public String getKey(DSMetaProperty dsMetaProperty) {
                return dsMetaProperty.getName();
            }
        });
        for (DSMetaEntitySubView subView : subViews) {
            if (subView.getSubViewType() != 1) continue;
            dsMetaEntity.getSubViews().add(subView);
            if (null == subView.getViewItems()) continue;
            for (AbstractDSViewItem viewItem : subView.getViewItems()) {
                DSMetaFieldItem fieldItem = (DSMetaFieldItem)viewItem;
                DSMetaProperty dsMetaProperty = (DSMetaProperty)propertyMap.get(fieldItem.getName());
                if (null == dsMetaProperty) continue;
                dsMetaProperty.setHide(false);
            }
        }
        dsMetaEntity.setViewItems(metaInfo.getViewItems());
    }

    protected AbstractNode convertToQingNode(IBriefViewTreeNode rootNode, String metaType) {
        if (rootNode == null || StringUtil.isEmptyString((String)metaType)) {
            throw new IllegalArgumentException("rootNode or metaType must be not null.");
        }
        FolderNode fRootNode = new FolderNode();
        fRootNode.setName(rootNode.getFullName());
        fRootNode.setDisplayName(rootNode.getAlias() == null ? rootNode.getName() : rootNode.getAlias());
        fRootNode.setCommentInfo(rootNode.getName());
        this.convertToQingNode(fRootNode, rootNode, metaType);
        return fRootNode;
    }

    private AbstractNode convertToQingNode(FolderNode fRootNode, IBriefViewTreeNode rootNode, String metaType) {
        block9: {
            Enumeration enu = rootNode.children();
            IBriefViewTreeNode bvNode = null;
            try {
                while (enu.hasMoreElements()) {
                    FolderNode fChildNode;
                    bvNode = (IBriefViewTreeNode)enu.nextElement();
                    if (bvNode.isPackage()) {
                        if (bvNode.getChildCount() <= 0) continue;
                        fChildNode = new FolderNode();
                        this.convertToQingNode(fChildNode, bvNode, metaType);
                        if (fChildNode.getChildCount() <= 0) continue;
                        fChildNode.setName(bvNode.getFullName());
                        fChildNode.setDisplayName(bvNode.getAlias() == null ? bvNode.getName() : bvNode.getAlias());
                        fChildNode.setCommentInfo(bvNode.getName());
                        fRootNode.addChild((AbstractNode)fChildNode);
                        continue;
                    }
                    if (!this.checkAvailabel(bvNode)) continue;
                    if ("enty".equals(bvNode.getMetaDataType().toString())) {
                        String entityName = bvNode.getFullName();
                        if (entityName.lastIndexOf(".app.") < 0) continue;
                        String packageName = entityName.substring(0, entityName.lastIndexOf(".app."));
                        String className = packageName + "." + bvNode.getName() + "Info";
                        try {
                            Class<?> clazz = Class.forName(className);
                            if (CoreBillEntryBaseInfo.class.isAssignableFrom(clazz)) {
                                continue;
                            }
                        }
                        catch (ClassNotFoundException e) {
                            LogUtil.error((String)e.getMessage(), (Throwable)e);
                        }
                        if (entityName.endsWith("Entry")) continue;
                    }
                    fChildNode = new LeafNode();
                    fChildNode.setName(bvNode.getFullName());
                    fChildNode.setDisplayName(bvNode.getAlias() == null ? bvNode.getName() : bvNode.getAlias());
                    fChildNode.setCommentInfo(bvNode.getName());
                    fChildNode.setType(metaType);
                    fRootNode.addChild((AbstractNode)fChildNode);
                }
            }
            catch (Exception e) {
                if (bvNode != null) {
                    LogUtil.warn((String)(metaType + " " + bvNode.getFullName() + "ignore."));
                }
                if (!LogUtil.isDebugEnabled()) break block9;
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return fRootNode;
    }

    protected boolean checkAvailabel(IBriefViewTreeNode bvNode) {
        return true;
    }

    protected IQingTableMetaProcessor getTableMetaProcessor(String rootEntityKey) {
        IExtensionClassProvider<IQingTableMetaProcessor> classProvider = EASExtensionProviderFactory.getExtensionClassProvider(IQingTableMetaProcessor.class);
        QingExtensionConfig extensionConfig = new QingExtensionConfig(classProvider);
        QingExtensionLoader metaExtensionLoader = QingExtensionLoader.getExtensionLoader((QingExtensionConfig)extensionConfig);
        List metaProcessors = metaExtensionLoader.getExtensions(new String[]{"com.kingdee.eas.qing.subjectmeta", rootEntityKey});
        TableMetaProcessorGroup processorGroup = new TableMetaProcessorGroup(metaProcessors);
        return processorGroup;
    }

    public static boolean isAliableEnum(PropertyInfo fld) {
        return fld != null && fld instanceof OwnPropertyInfo && ((OwnPropertyInfo)fld).getDataType().equals((Object)DataType.ENUM);
    }

    public static Map<String, String> getEnumMap(Context ctx, PropertyInfo prop) throws BOSException {
        BizEnumInfo enumInfo = AbstractMetaSourceDomain.getEnum(ctx, prop);
        if (enumInfo != null) {
            HashMap<String, String> enumMap = new HashMap<String, String>();
            BizEnumValueCollection values = enumInfo.getEnumValue();
            if (values != null) {
                for (int i = 0; i < values.size(); ++i) {
                    BizEnumValueInfo enumValue = values.get(i);
                    Object key = enumValue.getValue();
                    String value = enumValue.getAlias();
                    enumMap.put(key.toString(), value);
                }
            }
            return enumMap;
        }
        return null;
    }

    protected static BizEnumInfo getEnum(Context ctx, PropertyInfo prop) throws BOSException {
        if (prop == null) {
            return null;
        }
        BizEnumInfo bizEnum = null;
        if (prop instanceof OwnPropertyInfo) {
            String metadataRef = ((OwnPropertyInfo)prop).getMetaDataRef();
            String className = MetaDataUtils.getClassName((String)metadataRef);
            String packageName = MetaDataUtils.getPackageName((String)metadataRef);
            try {
                bizEnum = AbstractMetaSourceDomain.getBizEnum(ctx, MetaDataPK.create((String)packageName, (String)className));
            }
            catch (Exception be) {
                throw new BOSException((Throwable)be);
            }
        } else {
            throw new BOSException("The type of property is not Ownproperty!");
        }
        if (bizEnum != null) {
            return bizEnum;
        }
        throw new BOSException("Get BizEnumInfo message failed!");
    }

    public RuntimeFilterUtil.Prediction initRuntimeFilter(RuntimeEntity runtimeEntity) {
        RuntimeFilterUtil.Prediction prediction = new RuntimeFilterUtil.Prediction();
        runtimeEntity.initFilter(MetaCompareFilter.class, MetaLogicalFilter.class, prediction);
        return prediction;
    }

    protected abstract RTQueryJoinCollectionBuilder getJoinCollectionBuilder(RuntimeEntity var1, Context var2);

    protected IDataProvider getExecutorForNew(QingContext qingContext, RuntimeEntity runtimeEntity) throws DataMetaException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        try {
            SelectFieldCollectionBuilder fieldCollectionsBuilder = new SelectFieldCollectionBuilder(runtimeEntity);
            entityViewInfo.setSelector(fieldCollectionsBuilder.buildSelectFieldCollection());
            SqlFilterInfoBuilder sqlFilterBuilder = new SqlFilterInfoBuilder(qingContext, runtimeEntity);
            entityViewInfo.setFilter(sqlFilterBuilder.buildFilter());
            RTQueryJoinCollectionBuilder queryJoinBuilder = this.getJoinCollectionBuilder(runtimeEntity, ctx);
            entityViewInfo.setRTQueryJoins(queryJoinBuilder.buildRtQueryJoinInfos());
        }
        catch (Exception e) {
            throw DataMetaException.fail2Preview(e, e.getMessage());
        }
        entityViewInfo.setIngorePreOrders(true);
        String rootEntityAssociateName = runtimeEntity.getRootEntityAssociateName();
        IDataProvider exec = this.getMetaExecutor(ctx, rootEntityAssociateName);
        exec.setObjectView(entityViewInfo);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = false;
        exec.option().isMultiLanguage = true;
        try {
            String sql = exec.getSQL();
            LogUtil.warn((String)sql);
        }
        catch (BOSException e) {
            throw DataMetaException.fail2Preview(e, e.getMessage());
        }
        return exec;
    }

    protected abstract AbstractMetaDataValue getMetaInfo(Context var1, String var2);

    protected abstract IDataProvider getMetaExecutor(Context var1, String var2);

    protected List<Object[]> getPreviewResult(QingContext qingContext, IRowSet rs, RuntimeEntity runtimeEntity, List<Object[]> result, int previewRows) throws Exception {
        EASEntityPreviewDataSet dataSet = new EASEntityPreviewDataSet(rs);
        IQingTableRowDataProcessor tableRowDataProcessor = this.getTableDataProcessor(qingContext, runtimeEntity);
        DataPreviewCallBack previewCallBack = new DataPreviewCallBack(runtimeEntity, previewRows, result);
        EASEntityDataSetHandler dataSetHandler = new EASEntityDataSetHandler(tableRowDataProcessor, (IRowDataHandleCallBack)previewCallBack);
        dataSetHandler.processDataSet(runtimeEntity, dataSet);
        return result;
    }

    private IQingTableRowDataProcessor getTableDataProcessor(QingContext qingContext, RuntimeEntity runtimeEntity) {
        IExtensionClassProvider<IQingTableRowDataProcessor> classProvider = EASExtensionProviderFactory.getExtensionClassProvider(IQingTableRowDataProcessor.class);
        QingExtensionConfig config = new QingExtensionConfig(classProvider);
        QingExtensionLoader extensionLoader = QingExtensionLoader.getExtensionLoader((QingExtensionConfig)config);
        List processors = extensionLoader.getExtensions(new String[]{"easEnumFieldDataProcessor", runtimeEntity.getRootEntityAssociateName()});
        TableDataProcessorGroup rowDataProcessor = new TableDataProcessorGroup(processors);
        HashMap<String, Object> dataContext = new HashMap<String, Object>();
        dataContext.put("bosContext", ((QingIntegratedContext)qingContext).getBosContext());
        dataContext.put("processScene", Scene.SUBJECT);
        dataContext.put("runtimeEntity", runtimeEntity);
        rowDataProcessor.prepareParamDatas(dataContext);
        return rowDataProcessor;
    }

    private Map<String, String> buildAssociateToRsNameRelation(Context bosCtx, IDataProvider exec, RuntimeEntity runtimeEntity) throws SQLException, BOSException {
        QueryContext ctx = QueryContext.getInstance((EntityViewInfo)exec.getObjectView(), null, (QueryExecuteOption)exec.option(), (int)1, null);
        BOSObjectType type = ((MetaSource)runtimeEntity.getSource()).getBizMetaType().equals(MetaSource.MetaType.EASEntity.toString()) ? MetaDataTypeList.ENTITY : MetaDataTypeList.BASEQUERY;
        ctx.init(bosCtx, null, (IMetaDataPK)MetaDataPK.create((String)runtimeEntity.getRootEntityAssociateName()), type);
        DynamicRowSet drs = ctx.getQuerySqlAccess().createRowSet(exec.option());
        HashMap<String, String> relations = new HashMap<String, String>();
        IRowSetMetaData meta = drs.getRowSetMetaData();
        int totalCount = drs.getMetaData().getColumnCount();
        for (int colIndex = 1; colIndex <= totalCount; ++colIndex) {
            Map map = meta.getExtendedProperties(colIndex);
            PropertyUnitDele fld = (PropertyUnitDele)map.get("FieldInfo");
            String fldName = fld.getName();
            String rsFleName = fldName;
            if (rsFleName != null && rsFleName.length() >= 30) {
                int tempCol = colIndex - 1;
                rsFleName = rsFleName.substring(0, Math.min(rsFleName.length(), 30 - String.valueOf(tempCol).length())) + tempCol;
            }
            relations.put(fldName, rsFleName);
        }
        return relations;
    }

    private int getTotalCount(IDataProvider exec, RuntimeEntity runtimeEntity, QingContext qingContext) throws DataEntityException {
        ResultSet rs = null;
        Connection conn = null;
        Context context = ((QingIntegratedContext)qingContext).getBosContext();
        Statement statement = null;
        int totalCount = 0;
        try {
            conn = EJBFactory.getConnection((Context)context);
            String sql = exec.getSQL();
            statement = conn.createStatement();
            statement.setFetchSize(100);
            rs = statement.executeQuery(sql);
            Map<String, String> associateToRsNameMap = this.buildAssociateToRsNameRelation(context, exec, runtimeEntity);
            EASEntityExtractDataSet dataSet = new EASEntityExtractDataSet(rs, associateToRsNameMap);
            AtomicInteger dataCount = new AtomicInteger(0);
            CalcDataRowCountCallBack callBack = new CalcDataRowCountCallBack(dataCount);
            IQingTableRowDataProcessor rowDataProcessor = this.getTableDataProcessor(qingContext, runtimeEntity);
            EASEntityDataSetHandler dataSetHandler = new EASEntityDataSetHandler(rowDataProcessor, (IRowDataHandleCallBack)callBack);
            dataSetHandler.processDataSet(runtimeEntity, dataSet);
            totalCount = dataCount.get();
        }
        catch (Exception e) {
            try {
                throw DataEntityException.fail2Extract(e, e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return totalCount;
    }

    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException, AbstractQingIntegratedException {
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return 0L;
        }
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        IDataProvider exec = this.getExecutorForNew(qingContext, runtimeEntity);
        long rowCount = 0L;
        try {
            rowCount = this.getTotalCount(exec, runtimeEntity, qingContext);
        }
        catch (AbstractSourceException e) {
            String msg = "get result failed:" + e.getMessage();
            throw DataMetaException.fail2DataCount(e, msg);
        }
        return rowCount;
    }

    protected boolean isDataFieldUnique(QingContext qingContext, RuntimeEntity runtimeEntity, RuntimeProperty fieldName) throws AbstractSourceException, AbstractQingIntegratedException {
        String metaName = runtimeEntity.getAssociateName();
        ArrayList<RuntimeProperty> singleField = new ArrayList<RuntimeProperty>();
        singleField.add(fieldName);
        IDataProvider exec1 = this.getExecutor(qingContext, metaName, singleField);
        IDataProvider exec2 = this.getExecutor(qingContext, metaName, runtimeEntity.getAllPriProperties());
        try {
            int count1 = exec1.getRowCount();
            int count2 = exec2.getRowCount();
            return count1 == count2;
        }
        catch (Exception e) {
            String msg = "check unique failed: " + e.getMessage();
            throw DataMetaException.fail2CheckUnique(e, msg);
        }
    }

    protected IDataProvider getExecutor(QingContext qingContext, String metaFullName, List<RuntimeProperty> props) {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        IDataProvider exec = this.getMetaExecutor(ctx, metaFullName);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isMultiLanguage = true;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        for (RuntimeProperty property : props) {
            sic.add(property.getAssociateName());
        }
        entityViewInfo.setSelector(sic);
        exec.setObjectView(entityViewInfo);
        return exec;
    }

    public void fixLocalEntityFromLiveEntity(Entity currentEntity, Entity liveEntity) {
        Map livePropertyAssociateNameWithPropertyMap = MapUtils.collectionToMap((Collection)liveEntity.getProperties(), (MapUtils.IMapKeySelector)new PropertyAssociateNameKeySelector());
        EasEntityExtension extension = (EasEntityExtension)liveEntity.getExtension(EasEntityExtension.class);
        String parentFieldFullName = extension.getParentFullFieldName();
        boolean isNewVersion = true;
        if (!parentFieldFullName.isEmpty()) {
            isNewVersion = ((Property)currentEntity.getProperties().get(0)).getAssociateName().startsWith(parentFieldFullName);
        }
        Iterator it = currentEntity.getProperties().iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (prop.isCalculation()) continue;
            String newVersionAssociateName = isNewVersion ? prop.getAssociateName() : parentFieldFullName + "." + prop.getAssociateName();
            Property liveProp = (Property)livePropertyAssociateNameWithPropertyMap.get(newVersionAssociateName);
            if (liveProp == null) {
                it.remove();
                continue;
            }
            this.syncLocalPropertyFromLiveProperty(prop, liveProp);
        }
        this.syncTreePropertyFromLiveEntity(currentEntity, liveEntity);
    }

    public ITreePropertyProcessor createTreePropertyProcessor() {
        return new EASFixTreePropertyRuntimeProcess();
    }

    public IParentEntityFilterProcessor createParentFilterProcessor() {
        return new EASFixEntityFilterItemWithParentRuntimeProcess();
    }

    protected void syncLocalPropertyFromLiveProperty(Property local, Property live) {
        DesigningDataType livePropertyDataTyep;
        DesigningDataType dmEntityPropertyDataType = local.getDataType();
        if (dmEntityPropertyDataType != (livePropertyDataTyep = live.getDataType())) {
            local.setDataType(livePropertyDataTyep);
        }
        local.setEnumValue(live.getEnumValue());
        local.setForeignKey(live.getForeignKey());
        local.getExtensionProps().putAll(live.getExtensionProps());
        local.setAssociateName(live.getAssociateName());
    }

    public void checkEASPermission(QingContext qingContext) throws QingPermissionException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        try {
            if (!SubjectModelingService.hasFunctionalPermission(ctx)) {
                throw QingPermissionException.hasNoPermission("noPermission");
            }
        }
        catch (Exception e) {
            throw QingPermissionException.fail2CheckPermission(e.getMessage());
        }
    }

    private ResultSet executeQuery(String sql, Connection conn, Statement statement, ResultSet rs) throws BOSException {
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            return rs;
        }
        catch (SQLException exc) {
            throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
        }
    }

    protected void populateRowSetCell(IMetaDataPK pk, DynamicRowSet rowset, ResultSet rs, int col, QueryExecuteOption option, Context bosctx) throws SQLException, BOSException {
        Map map = rowset.getRowSetMetaData().getExtendedProperties(col);
        PropertyUnitDele fld = (PropertyUnitDele)map.get("FieldInfo");
        ConstDataType tp = fld.getReturnType();
        String fldName = fld.getName();
        String rsFleName = fldName;
        if (rsFleName != null && rsFleName.length() > 30) {
            int tempCol = col - 1;
            rsFleName = rsFleName.substring(0, Math.min(rsFleName.length(), 30 - String.valueOf(tempCol).length())) + tempCol;
        }
        Object oColVal = null;
        try {
            oColVal = rs.getObject(rsFleName);
        }
        catch (SQLException e) {
            LogUtil.error((String)("field key not exist, fieldKey:" + rsFleName), (Throwable)e);
        }
        if (oColVal == null) {
            rowset.updateNull(fldName);
            return;
        }
        if (tp.equals((Object)ConstDataType.STRING)) {
            String colVal = oColVal.toString();
            rowset.updateString(fldName, colVal);
        } else if (tp.equals((Object)ConstDataType.BOOLEAN)) {
            int i;
            try {
                i = TypeConversionUtils.objToInt((Object)oColVal);
            }
            catch (IllegalConversionException e) {
                throw new BOSException("Field ReturnType Conversion error. Field:" + fldName, (Throwable)e);
            }
            if (option.isAutoTranslateBoolean) {
                rowset.updateObject(col, (Object)(i != 0 ? Boolean.TRUE : Boolean.FALSE));
            } else {
                rowset.updateInt(col, i);
            }
        } else if (tp.equals((Object)ConstDataType.INT)) {
            if (oColVal instanceof Number) {
                long i = ((Number)oColVal).longValue();
                rowset.updateLong(fldName, i);
            } else if (oColVal instanceof String) {
                rowset.updateString(fldName, oColVal.toString());
            } else {
                rowset.updateNull(fldName);
            }
        } else if (tp.equals((Object)ConstDataType.NUMBER)) {
            if (oColVal instanceof Number) {
                BigDecimal bd = new BigDecimal(oColVal.toString());
                rowset.updateBigDecimal(fldName, bd);
            } else if (oColVal instanceof String) {
                rowset.updateString(fldName, oColVal.toString());
            } else {
                rowset.updateNull(fldName);
            }
        } else if (tp.equals((Object)ConstDataType.DATE)) {
            if (oColVal instanceof Date) {
                Date da = (Date)oColVal;
                rowset.updateDate(fldName, da);
            } else if (oColVal instanceof Time) {
                Time ti = (Time)oColVal;
                rowset.updateTime(fldName, ti);
            } else if (oColVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)oColVal;
                rowset.updateTimestamp(fldName, ts);
            } else {
                rowset.updateNull(fldName);
            }
        } else if (tp.equals((Object)ConstDataType.TIME)) {
            if (oColVal instanceof Time) {
                Time ti = (Time)oColVal;
                rowset.updateTime(fldName, ti);
            } else if (oColVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)oColVal;
                rowset.updateTimestamp(fldName, ts);
            } else {
                rowset.updateNull(fldName);
            }
        } else if (tp.equals((Object)ConstDataType.TIMESTAMP)) {
            if (oColVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)oColVal;
                rowset.updateTimestamp(fldName, ts);
            } else {
                rowset.updateNull(fldName);
            }
        } else {
            rowset.updateNull(fldName);
        }
    }

    protected static BizEnumInfo getBizEnum(Context bosctx, MetaDataPK pk) {
        return MetaDataLoader.getEnum((Context)bosctx, (IMetaDataPK)pk);
    }

    public String scanAllEntity(QingContext qingContext, AbstractSource source) throws SubjectDataModelingException {
        IQingFile exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        EntityScanDomain scanDomain = new EntityScanDomain((AbstractDataSourceDomain)this, qingContext, source);
        scanDomain.scanEntities(exportFile);
        return exportFile.getName();
    }

    static {
        dataTypeMap.put(DataType.SHORT.getName(), DesigningDataType.INT);
        dataTypeMap.put(DataType.INTEGER.getName(), DesigningDataType.INT);
        dataTypeMap.put(DataType.LONG.getName(), DesigningDataType.INT);
        dataTypeMap.put(DataType.FLOAT.getName(), DesigningDataType.NUMBER);
        dataTypeMap.put(DataType.DOUBLE.getName(), DesigningDataType.NUMBER);
        dataTypeMap.put(DataType.DECIMAL.getName(), DesigningDataType.NUMBER);
        dataTypeMap.put(DataType.DATE.getName(), DesigningDataType.DATE);
        dataTypeMap.put(DataType.TIME.getName(), DesigningDataType.DATETIME);
        dataTypeMap.put(DataType.TIMESTAMP.getName(), DesigningDataType.DATETIME);
        dataTypeMap.put(DataType.CHAR.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.BOOLEAN.getName(), DesigningDataType.BOOLEAN);
        dataTypeMap.put(DataType.BYTE.getName(), DesigningDataType.INT);
        dataTypeMap.put(DataType.STRING.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.BYTEARRAY.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.OBJECTPK.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.ROWSET.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.BOSUUID.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.UUID.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.ENUM.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.OBJECTVALUE.getName(), DesigningDataType.STRING);
        dataTypeMap.put(DataType.OBJECTCOLLECTION.getName(), DesigningDataType.STRING);
        dataTypeMap.put(null, DesigningDataType.STRING);
    }
}

