/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.local.inner;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class EntityPermissionDataRuleProcessor
implements IQingTableMetaProcessor {
    public void processTableMeta(TableMetaObject tableMetaObject) {
        QingMeta qingMeta = (QingMeta)tableMetaObject.getQingMeta();
        TableMetaKey metaKey = tableMetaObject.getMetaKey();
        Context bosCtx = (Context)metaKey.getMetaContextInfo("bosContext");
        QingContext qingCtx = (QingContext)metaKey.getMetaContextInfo("qingContext");
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)bosCtx);
        List<EntryEntity> entitys = qingMeta.getEntryEntities();
        for (EntryEntity entryEntity : entitys) {
            String associateName = entryEntity.getKey();
            EntityObjectInfo entityObj = metaDataLoader.getEntity((IMetaDataPK)MetaDataPK.create((String)associateName));
            try {
                this.setPermissionRule(entryEntity, entityObj, qingCtx, bosCtx);
            }
            catch (Exception e) {
                LogUtil.error((String)"", (Throwable)e);
            }
        }
    }

    private String getPermisstionName(Context bosCtx, String bosType) throws Exception {
        String sql = "SELECT * FROM t_pm_permitem where FOBJECTTYPE =? and FOPERATIONTYPE ='READ'";
        Object[] params = new Object[]{bosType};
        String permItemName = null;
        IRowSet rs = this.executeQuery(bosCtx, sql, params);
        while (rs.next()) {
            permItemName = rs.getString("FNUMBER");
        }
        return permItemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet executeQuery(Context ctx, String sql, Object[] params) throws SQLException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (Throwable throwable) {
            CloseUtil.close((Connection)conn, ps, rs);
            throw throwable;
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
        return jdbcRowSet;
    }

    protected void setPermissionRule(EntryEntity entryEntity, EntityObjectInfo entityObj, QingContext qingContext, Context bosCtx) throws Exception {
        ObjectUuidPK orgPK;
        if (entityObj.getType() == null) {
            return;
        }
        String bosType = entityObj.getType().toString();
        if (StringUtil.isEmptyString((String)bosType)) {
            return;
        }
        String permItemName = this.getPermisstionName(bosCtx, bosType);
        if (StringUtil.isEmptyString((String)permItemName)) {
            return;
        }
        DataPermissionService permService = new DataPermissionService(bosCtx);
        ObjectUuidPK userPK = new ObjectUuidPK(qingContext.getUserId());
        String permissionRule = permService.getPermissionRule((IObjectPK)userPK, (IObjectPK)(orgPK = new ObjectUuidPK(qingContext.getSystemVar(SystemVarType.ORG_ID).toString())), permItemName);
        if (" WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )".equals(permissionRule)) {
            return;
        }
        entryEntity.setPermissionDataRule(permissionRule);
    }

    public void dispose() {
    }
}

