/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.ImportAnalysisModel;
import com.kingdee.bos.qing.imexport.importer.PublishConflictModel;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.AbstractPublishImporter;
import com.kingdee.bos.qing.imexport.model.PermissionTypeEnum;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToLapp;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.lapp.domain.LappContextDomain;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PermissionObject;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.lapp.LappSyncDomain;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfigVO;
import com.kingdee.bos.qing.publish.target.lapp.model.ViewTypeEnum;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.thumbnail.ThumbnailHelper;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LappTargetPublishImporter
extends AbstractPublishImporter {
    private static final String LAPP_ENTRANCE = "/qing/lappEntrance.do";
    private PublishInfoDao publishInfoDao;
    private LappSyncDomain lappSyncDomain;
    private LappContextDomain lappContextDomain;
    private ILappStrategy lappStrategy;
    private List<PublishLappConfigVO> publishLappConfigVOs;

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private LappSyncDomain getLappSyncDomain() {
        if (this.lappSyncDomain == null) {
            this.lappSyncDomain = new LappSyncDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.lappSyncDomain;
    }

    private LappContextDomain getLappContextDomain() {
        if (this.lappContextDomain == null) {
            this.lappContextDomain = new LappContextDomain(this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine);
        }
        return this.lappContextDomain;
    }

    private ILappStrategy getLappStrategyImpl() {
        this.lappStrategy = (ILappStrategy)CustomStrategyRegistrar.getStrategy(ILappStrategy.class);
        if (this.lappStrategy == null) {
            throw new RuntimeException("cannot found the implement of ILappStrategy.");
        }
        return this.lappStrategy;
    }

    private List<PublishLappConfigVO> getPublishLappConfigVOs() {
        if (this.publishLappConfigVOs == null) {
            this.publishLappConfigVOs = new ArrayList<PublishLappConfigVO>();
            this.getLappStrategyImpl().getLappConext(this.publishLappConfigVOs, this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine);
        }
        return this.publishLappConfigVOs;
    }

    private PublishLappConfigVO loadPublishLappConfigVOMap(Map<String, PublishLappConfigVO> publishLappConfigVOMap) {
        PublishLappConfigVO initPublishLappConfigVO = null;
        List<PublishLappConfigVO> publishLappConfigVOlist = this.getPublishLappConfigVOs();
        for (PublishLappConfigVO publishLappConfigVO : publishLappConfigVOlist) {
            if (!StringUtils.isNotBlank((CharSequence)publishLappConfigVO.getLappUserId())) continue;
            publishLappConfigVOMap.put(String.valueOf(publishLappConfigVO.getAppType()), publishLappConfigVO);
            if (initPublishLappConfigVO != null) continue;
            initPublishLappConfigVO = publishLappConfigVO;
        }
        return initPublishLappConfigVO;
    }

    public void doImport(String paramPathPrefix, ImportParamModel importParamModel, List<LongerSquarePublishObject> subjectPublishObjects, List<DsbPublishObject> dsbPublishObjects) throws IOException, SQLException, AbstractQingException {
        HashMap<String, PublishLappConfigVO> publishLappConfigVOMap = new HashMap<String, PublishLappConfigVO>();
        PublishLappConfigVO initPublishLappConfigVO = this.loadPublishLappConfigVOMap(publishLappConfigVOMap);
        if (publishLappConfigVOMap.isEmpty()) {
            return;
        }
        List<ImportAnalysisModel> lappAnalysisInfos = this.createcreateLappAnalysisModelList(paramPathPrefix, importParamModel, subjectPublishObjects, dsbPublishObjects);
        HashMap lappAnalysisInfoMap = new HashMap();
        for (ImportAnalysisModel importAnalysisModel : lappAnalysisInfos) {
            if (StringUtils.isBlank((CharSequence)importAnalysisModel.getAppType()) && initPublishLappConfigVO != null) {
                this.importLappAnalysisInfo(importParamModel, lappAnalysisInfos, initPublishLappConfigVO.getLappUserId(), initPublishLappConfigVO.getLappUserType());
                return;
            }
            if (lappAnalysisInfoMap.get(importAnalysisModel.getAppType()) == null) {
                ArrayList<ImportAnalysisModel> tmp = new ArrayList<ImportAnalysisModel>();
                tmp.add(importAnalysisModel);
                lappAnalysisInfoMap.put(importAnalysisModel.getAppType(), tmp);
                continue;
            }
            ((List)lappAnalysisInfoMap.get(importAnalysisModel.getAppType())).add(importAnalysisModel);
        }
        for (Map.Entry entry : lappAnalysisInfoMap.entrySet()) {
            String appType = (String)entry.getKey();
            PublishLappConfigVO publishLappConfigVO = (PublishLappConfigVO)publishLappConfigVOMap.get(appType);
            if (publishLappConfigVO == null) continue;
            this.importLappAnalysisInfo(importParamModel, (List)entry.getValue(), publishLappConfigVO.getLappUserId(), publishLappConfigVO.getLappUserType());
        }
    }

    private void importLappAnalysisInfo(ImportParamModel importParamModel, List<ImportAnalysisModel> lappAnalysisInfos, String lappUserId, String lappUserType) throws AbstractQingException {
        if (lappAnalysisInfos.size() > 0) {
            HashMap<String, String> checkDuplicateParamMap = new HashMap<String, String>(16);
            checkDuplicateParamMap.put("lappUserId", lappUserId);
            checkDuplicateParamMap.put("lappUserType", lappUserType);
            checkDuplicateParamMap.put("datacenterUUID", this.getLappSyncDomain().getSyncedDatacenterUUID());
            HashMap<String, String> checkDuplicateParams = new HashMap<String, String>();
            checkDuplicateParams.put("model", JsonUtil.encodeToString(lappAnalysisInfos));
            String checkResult = LappHelper.postByForm((LappApiEnum)LappApiEnum.QING_CHECK_ANALYSIS_NAME_LIST_DUPLICATE_URL, null, checkDuplicateParams, checkDuplicateParamMap);
            List<Object> importAnalysisModelList = new ArrayList(10);
            ArrayList<ImportAnalysisModel> needSavelappAnalysisInfos = new ArrayList<ImportAnalysisModel>(10);
            try {
                PublishConflictModel successResult = (PublishConflictModel)JsonUtil.decodeFromString((String)checkResult, PublishConflictModel.class);
                importAnalysisModelList = successResult.getData();
                for (int i = 0; i < importAnalysisModelList.size(); ++i) {
                    ImportAnalysisModel importAnalysisModel = (ImportAnalysisModel)((Object)importAnalysisModelList.get(i));
                    if ("1".equals(importAnalysisModel.getDuplicate())) {
                        importParamModel.getDuplicateMap().put(importAnalysisModel.getPublishId(), true);
                        String oldPublishId = importAnalysisModel.getNeedOverwritePublishId();
                        if (oldPublishId != null) {
                            importParamModel.getNeedOverwritePublishId().put(importAnalysisModel.getPublishId(), oldPublishId);
                        }
                        String tagId = importAnalysisModel.getTagId();
                        PublishPO oldPublishPO = this.getPublishInfoDao().getPublishInfoByInfoId(oldPublishId);
                        if (oldPublishPO != null) {
                            boolean sameSource = oldPublishPO.getTagId().equals(tagId);
                            if (!sameSource) {
                                this.addToConfilctPublishList(importAnalysisModel, importParamModel);
                                continue;
                            }
                            if (!"1".equals(importAnalysisModel.getOverwrite())) {
                                this.addToConfilctPublishList(importAnalysisModel, importParamModel);
                                continue;
                            }
                            needSavelappAnalysisInfos.add(importAnalysisModel);
                            continue;
                        }
                        this.addToConfilctPublishList(importAnalysisModel, importParamModel);
                        continue;
                    }
                    needSavelappAnalysisInfos.add(importAnalysisModel);
                }
            }
            catch (Exception e) {
                LogUtil.error((String)"import lapp error", (Throwable)e);
            }
            if (needSavelappAnalysisInfos.size() > 0) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("lappUserId", lappUserId);
                paramMap.put("lappUserType", lappUserType);
                paramMap.put("datacenterUUID", this.getLappSyncDomain().getSyncedDatacenterUUID());
                HashMap<String, String> saveAnalysisParams = new HashMap<String, String>();
                saveAnalysisParams.put("model", JsonUtil.encodeToString(needSavelappAnalysisInfos));
                String analysisIds = LappHelper.postByForm((LappApiEnum)LappApiEnum.QING_SCHEDULE_PUSH_SAVE_ANALYSIS_LIST_URL, null, saveAnalysisParams, paramMap);
                try {
                    Map analysisIdMap = (Map)JsonUtil.decodeFromString((String)analysisIds, Map.class);
                    if (analysisIdMap != null) {
                        importParamModel.setAnalysisIdMap((Map)analysisIdMap.get("data"));
                    }
                }
                catch (Exception e) {
                    LogUtil.error((String)"parse analysisIdMap error", (Throwable)e);
                }
            }
        }
    }

    private void addToConfilctPublishList(ImportAnalysisModel importAnalysisModel, ImportParamModel importParamModel) {
        ExportPublishConflictVO exportPublishConflictVO = new ExportPublishConflictVO();
        String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"lightapp", (String)"\u79fb\u52a8\u8f7b\u5e94\u7528", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING) + " : " + importAnalysisModel.getDirectoryName() + "/" + importAnalysisModel.getName();
        exportPublishConflictVO.setPublishPath(publishPath);
        exportPublishConflictVO.setThemeName(importAnalysisModel.getThemeName());
        exportPublishConflictVO.setThemeType(importAnalysisModel.getThemeType());
        importParamModel.getConfilctPublishList().add(exportPublishConflictVO);
    }

    private List<ImportAnalysisModel> createcreateLappAnalysisModelList(String paramPathPrefix, ImportParamModel importParamModel, List<LongerSquarePublishObject> subjectPublishObjects, List<DsbPublishObject> dsbPublishObjects) throws IntegratedRuntimeException, IOException {
        boolean isOverwrite;
        ArrayList<ImportAnalysisModel> lappAnalysisInfoList = new ArrayList<ImportAnalysisModel>(10);
        for (LongerSquarePublishObject subjectPublishObject : subjectPublishObjects) {
            isOverwrite = subjectPublishObject.getPublishPO().isOverwrite();
            SchemaObject schemaObject = (SchemaObject)subjectPublishObject.getSchemaObjs().get(0);
            SchemaBO schemaBO = schemaObject.getSchemaInfo().getSchemaBO();
            String viewType = null;
            String sView = null;
            if (schemaBO.getSource() == 1) {
                viewType = ViewTypeEnum.SQUARE.toPersistance();
                sView = "10";
            } else {
                viewType = schemaBO.getSource() == 0 ? ViewTypeEnum.LONGER.toPersistance() : ViewTypeEnum.DASHBOARD.toPersistance();
            }
            ImportAnalysisModel lappAnalysisInfo = this.createLappAnalysisModel(paramPathPrefix, importParamModel, (AbstractPublishObject)subjectPublishObject, viewType, sView, isOverwrite);
            lappAnalysisInfoList.add(lappAnalysisInfo);
        }
        for (DsbPublishObject dsbPublishObject : dsbPublishObjects) {
            isOverwrite = dsbPublishObject.getPublishPO().isOverwrite();
            String viewType = ViewTypeEnum.DASHBOARD.toPersistance();
            ImportAnalysisModel lappAnalysisInfo = this.createLappAnalysisModel(paramPathPrefix, importParamModel, (AbstractPublishObject)dsbPublishObject, viewType, null, isOverwrite);
            lappAnalysisInfoList.add(lappAnalysisInfo);
        }
        return lappAnalysisInfoList;
    }

    private ImportAnalysisModel createLappAnalysisModel(String paramPathPrefix, ImportParamModel importParamModel, AbstractPublishObject PublishObject, String viewType, String sView, boolean isOverwrite) throws IOException, IntegratedRuntimeException {
        Map tempFile = importParamModel.getTempFile();
        PublishToLapp publishToLapp = (PublishToLapp)PublishObject.getPublishTarget();
        PublishPO publishPo = PublishObject.getPublishPO();
        String thumbnailFileName = null;
        String tempThumbnailFile = (String)tempFile.get(publishToLapp.getTempThumbnailFile());
        if (tempThumbnailFile != null) {
            IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempThumbnailFile);
            thumbnailFileName = ThumbnailHelper.upload((InputStream)fileVisitor.getInputStream());
        }
        List permissionObjs = PublishObject.getPermissionObjs();
        ArrayList<String> userIds = new ArrayList<String>();
        List authorizedUsers = new ArrayList();
        if (permissionObjs != null) {
            for (int i = 0; i < permissionObjs.size(); ++i) {
                String userName;
                PermissionInfo permissionInfo = ((PermissionObject)permissionObjs.get(i)).getPermissionInfo();
                int permissionType = permissionInfo.getType();
                String viewId = permissionInfo.getViewerId();
                if (permissionType == PermissionTypeEnum.role.getType()) {
                    String roleName = IntegratedHelper.getRoleName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)viewId);
                    if (roleName == null) continue;
                    userIds.addAll(IntegratedHelper.getUserIdsByRoleId((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)viewId));
                    continue;
                }
                if (permissionType != PermissionTypeEnum.user.getType() || (userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)viewId)) == null) continue;
                userIds.add(viewId);
            }
        }
        Context ctx = ((QingIntegratedContext)this.qingContext).getBosContext();
        authorizedUsers = this.getLappContextDomain().getLappContextsByIds(ctx, userIds, publishToLapp.getAppType()).getAuthorizedUsers();
        String newPublishId = (String)importParamModel.getNewPublishIdMap().get(publishPo.getId());
        ImportAnalysisModel lappAnalysisInfo = new ImportAnalysisModel();
        lappAnalysisInfo.setAuthorizedUsers(authorizedUsers);
        lappAnalysisInfo.setDescription(publishToLapp.getDesc());
        lappAnalysisInfo.setLayoutType(publishToLapp.getLayout_type());
        lappAnalysisInfo.setLandscape(publishToLapp.getLandscape());
        lappAnalysisInfo.setBottomAnnotation(publishToLapp.getBottomAnnotation());
        lappAnalysisInfo.setDisplayStyle(publishToLapp.getDisplayStyle());
        lappAnalysisInfo.setAppType(publishToLapp.getAppType());
        lappAnalysisInfo.setName(publishPo.getName());
        lappAnalysisInfo.setParentId(LappHelper.getLappAnalysisParentId());
        lappAnalysisInfo.setScene(this.getScene());
        lappAnalysisInfo.setLargeThumb(thumbnailFileName);
        lappAnalysisInfo.setViewType(viewType);
        lappAnalysisInfo.setCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)this.qingContext.getUserId()));
        if (isOverwrite) {
            lappAnalysisInfo.setOverwrite("1");
        } else {
            lappAnalysisInfo.setOverwrite("0");
        }
        lappAnalysisInfo.setDirectoryName(publishToLapp.getPath());
        lappAnalysisInfo.setPublishId(newPublishId);
        lappAnalysisInfo.setThemeName(publishToLapp.getThemeName());
        lappAnalysisInfo.setThemeType(publishToLapp.getThemeType());
        lappAnalysisInfo.setTagId(publishPo.getTagId());
        String lappEntranceUrl = paramPathPrefix + LAPP_ENTRANCE;
        String url = URLUtil.appendParamToUrl((String)lappEntranceUrl, (String)"tag", (String)publishPo.getTagId());
        url = URLUtil.appendParamToUrl((String)url, (String)"accountId", (String)this.qingContext.getAccountId());
        if (sView != null) {
            url = URLUtil.appendParamToUrl((String)url, (String)"view", (String)sView);
        }
        url = this.getLappStrategyImpl().addExtraParamsToUrl(url);
        lappAnalysisInfo.setUrl(url);
        return lappAnalysisInfo;
    }

    public String getScene() {
        return "EAS";
    }
}

