/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro;

import com.kingdee.bos.qing.macro.WebMacroHandler;
import com.kingdee.bos.qing.macro.date.DateMacroModel;
import com.kingdee.bos.qing.macro.exception.MacroException;
import com.kingdee.bos.qing.macro.org.OrgMacroModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MacroUtil {
    private static String[] macros = new String[]{"d1", "d7", "w1", "m1", "1m", "m3", "org"};
    private static String[] macroNames = new String[]{"com.kingdee.bos.qing.macro.date.TodayMacro", "com.kingdee.bos.qing.macro.date.NearlySevenDayMacro", "com.kingdee.bos.qing.macro.date.ThisWeekMacro", "com.kingdee.bos.qing.macro.date.ThisMonthMacro", "com.kingdee.bos.qing.macro.date.NearlyOneMonthMacro", "com.kingdee.bos.qing.macro.date.NearlyThreeMonthsMarco", "com.kingdee.bos.qing.macro.org.CurrentOrgMacro"};
    private static String[] links = new String[]{">=", "<", "in", "="};
    private static Map<String, String> macroMapping = new HashMap<String, String>();
    private static final String MACRO_TAG = "macro_";

    public static String parseMacroFilter(String curOrgId, String filter) throws MacroException {
        System.out.println("parseMacroFilter======111======\u5f53\u524d\u7ec4\u7ec7\u7684ID\u4e3a:" + curOrgId);
        if (filter == null || filter.length() <= 0) {
            return null;
        }
        System.out.println("parseMacroFilter======222======\u5b8f\u8fc7\u6ee4\u6761\u4ef6filter\u4e3a:" + filter);
        String[] splits = filter.split(MACRO_TAG);
        if (splits == null || splits.length <= 1) {
            return filter;
        }
        String result = "";
        result = result + splits[0];
        int len = splits.length;
        block0: for (int i = 1; i < len; ++i) {
            String split = splits[i];
            String macro = split.substring(0, split.indexOf("'"));
            String curFilter = split.substring(split.indexOf("'"), split.length());
            for (String link : links) {
                if (result.lastIndexOf(link) < result.length() - 5) continue;
                result = result + MacroUtil.getMacroValue(macro, link, curOrgId);
                result = result + curFilter;
                continue block0;
            }
        }
        return result;
    }

    public static String paraseMacro(String filter) throws MacroException {
        if (filter == null || filter.length() <= 0) {
            return null;
        }
        String[] splits = filter.split(MACRO_TAG);
        if (splits == null || splits.length <= 1) {
            return filter;
        }
        String result = "";
        result = result + splits[0];
        int len = splits.length;
        block0: for (int i = 1; i < len; ++i) {
            String split = splits[i];
            String macro = split.substring(0, split.indexOf("'"));
            String curFilter = split.substring(split.indexOf("'"), split.length());
            for (String link : links) {
                if (result.lastIndexOf(link) < result.length() - 5) continue;
                result = result + MacroUtil.getMacroValue(macro, link, null);
                result = result + curFilter;
                continue block0;
            }
        }
        return result;
    }

    private static String getMacroValue(String macro, String link, String curOrgId) throws MacroException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orgID", curOrgId);
        String macroName = macroMapping.get(macro);
        if (">=".equals(link) || "<".equals(link)) {
            DateMacroModel model = (DateMacroModel)WebMacroHandler.exec(macroName, null);
            if (">=".equals(link)) {
                return MacroUtil.formatDate(model.getStartTime());
            }
            return MacroUtil.formatDate(model.getEndTime());
        }
        if ("in".equals(link) || "=".equals(link)) {
            OrgMacroModel model = (OrgMacroModel)WebMacroHandler.exec(macroName, params);
            return model.getOrgId();
        }
        return null;
    }

    private static String formatDate(Date date, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        return sdf.format(date);
    }

    private static String formatDate(Date date) {
        return MacroUtil.formatDate(date, "yyyy-MM-dd");
    }

    public static void main(String[] args) throws MacroException {
        String filter = "((applierCompany.id = 'CeUAAAAAlCnM567U' ) and ((bizReqDate >= 'macro_m1' ) and (bizReqDate < 'macro_m1' ))) and (state not in (10) )";
        System.out.println(MacroUtil.paraseMacro(filter));
    }

    static {
        int len = macros.length;
        for (int i = 0; i < len; ++i) {
            macroMapping.put(macros[i], macroNames[i]);
        }
    }
}

