/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.init.QingInitializeHelper;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalPersistentQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.ormrpc.IBudgetService;
import com.kingdee.bos.qing.ormrpc.QingORMRPCDispatcherFactory;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetDataSourceVisitor;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetDataSourceWriter;
import com.kingdee.bos.qing.util.QingIntegratedUtil;

public class BudgetFacade {
    public static BudgetDataSourceVisitor createDataSourceVisitor(String qsId, Context context) throws BOSException {
        IQingFileVisitor qingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.BUDGET, (String)qsId);
        return new BudgetDataSourceVisitor(qingFile, context);
    }

    public static BudgetDataSourceWriter createDataSourceWriter(String qsId, Context context) {
        LocalPersistentQingFile qingFile = new LocalPersistentQingFile(QingPersistentFileType.BUDGET, qsId);
        return new BudgetDataSourceWriter((IQingFile)qingFile, context);
    }

    public static void deleteFile(String qsId, Context context) throws BOSException {
        IQingFileUpdater qingFileUpdater = FileFactory.newFileUpdater(null, (AbstractQingFileType)QingPersistentFileType.BUDGET, (String)qsId);
        if (qingFileUpdater.exists() && !qingFileUpdater.delete()) {
            throw new BOSException("fail to delete current service QingFile. qsId is " + qsId);
        }
        QingIntegratedContext qingCtx = QingIntegratedUtil.initQingIntegratedContext(context, null);
        IBudgetService ormService = QingORMRPCDispatcherFactory.createBudgetService(context);
        boolean isDelete = ormService.deleteBudgetDataFile(qingCtx, qsId);
        if (!isDelete) {
            throw new BOSException("fail to delete remote service QingFile. qsId is " + qsId);
        }
    }

    public static boolean getQsFileStatus(String qsId, Context context) throws BOSException {
        QingIntegratedContext qingCtx = QingIntegratedUtil.initQingIntegratedContext(context, null);
        IBudgetService ormService = QingORMRPCDispatcherFactory.createBudgetService(context);
        return ormService.getQsFileStatus(qingCtx, qsId);
    }

    static {
        QingInitializeHelper.initializeOnStart();
    }
}

