/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.util;

import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import java.util.HashMap;
import java.util.Map;

public class FieldTypeUtil {
    private static final Map<DesigningDataType, Integer> DataType_To_QingFieldType = new HashMap<DesigningDataType, Integer>();

    public static DataType changeQingFieldTypeToDataType(int iQingFieldType) {
        switch (iQingFieldType) {
            case 1: {
                return DataType.STRING;
            }
            case 2: {
                return DataType.NUMBER;
            }
            case 3: {
                return DataType.INT;
            }
            case 4: {
                return DataType.DATETIME;
            }
            case 5: {
                return DataType.DATE;
            }
            case 6: {
                return DataType.BOOLEAN;
            }
        }
        throw new RuntimeException("unknow QingFieldType: " + iQingFieldType);
    }

    public static DesigningDataType getDesignDataType(int fieldType) {
        DesigningDataType dataType = DesigningDataType.STRING;
        switch (fieldType) {
            case 1: {
                dataType = DesigningDataType.STRING;
                break;
            }
            case 2: {
                dataType = DesigningDataType.NUMBER;
                break;
            }
            case 3: {
                dataType = DesigningDataType.INT;
                break;
            }
            case 4: {
                dataType = DesigningDataType.DATETIME;
                break;
            }
            case 5: {
                dataType = DesigningDataType.DATE;
                break;
            }
            case 6: {
                dataType = DesigningDataType.BOOLEAN;
                break;
            }
            default: {
                dataType = DesigningDataType.STRING;
            }
        }
        return dataType;
    }

    public static int changeDataTypeToQingFieldType(DesigningDataType dataType) {
        return DataType_To_QingFieldType.get(dataType);
    }

    static {
        DataType_To_QingFieldType.put(DesigningDataType.BOOLEAN, QingFieldType.Boolean.toNumber());
        DataType_To_QingFieldType.put(DesigningDataType.STRING, QingFieldType.String.toNumber());
        DataType_To_QingFieldType.put(DesigningDataType.NUMBER, QingFieldType.Number.toNumber());
        DataType_To_QingFieldType.put(DesigningDataType.INT, QingFieldType.Int.toNumber());
        DataType_To_QingFieldType.put(DesigningDataType.DATETIME, QingFieldType.DateTime.toNumber());
        DataType_To_QingFieldType.put(DesigningDataType.DATE, QingFieldType.Date.toNumber());
    }
}

