/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.lapp.thirdapp;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.dao.impl.DBExcuterImpl;
import com.kingdee.bos.qing.common.dao.impl.TXManageImpl;
import com.kingdee.bos.qing.publish.lapp.domain.ILappContextHelper;
import com.kingdee.bos.qing.publish.lapp.thirdapp.AbstractThirdAppContext;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.ThirdPartyConfig;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class ThirdpartyContext
extends AbstractThirdAppContext {
    @Override
    public LappContext.UserType getUserType() {
        return LappContext.UserType.THIRD_PARTY;
    }

    @Override
    public LappContext getLappContext(Context ctx, String currentUserId, ILappContextHelper lappContextHelper) {
        return this.getLappContextByUserId(ctx, currentUserId, lappContextHelper);
    }

    @Override
    public List<LappContext> getLappContexts(Context ctx, List<String> userIds, final ILappContextHelper lappContextHelper) {
        List<Object> result = new ArrayList<LappContext>();
        ArrayList<String> remainUserIds = new ArrayList<String>(userIds);
        String sqlInQuestion = "?";
        if (remainUserIds != null && remainUserIds.size() > 0) {
            for (int i = 1; i < remainUserIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            return result;
        }
        String sql = "SELECT FID, FNUMBER, FCELL FROM T_PM_USER WHERE FID IN (" + sqlInQuestion + ") AND FISDELETE = 0 AND FISLOCKED = 0 AND FFORBIDDEN = 0";
        logger.info((Object)sql);
        TXManageImpl tx = new TXManageImpl(ctx);
        DBExcuterImpl dbExcuterImpl = new DBExcuterImpl(tx);
        try {
            Map<Object, Object> mapResult = new HashMap();
            mapResult = dbExcuterImpl.query(sql, userIds.toArray(), new ResultHandler<Map<String, List>>(){

                public Map<String, List> handle(ResultSet rs) throws SQLException {
                    return ThirdpartyContext.this.getLappContextByRS(lappContextHelper, rs);
                }
            });
            result = (List)mapResult.get("lappContextList");
            List successUserIds = (List)mapResult.get("successUserIds");
            remainUserIds.removeAll(successUserIds);
            for (int i = 0; i < remainUserIds.size(); ++i) {
                LappContext context = new LappContext();
                context.setUserId((String)remainUserIds.get(i));
                context.setLappUserId("");
                context.setLappUserType(LappContext.UserType.THIRD_PARTY);
                result.add(context);
            }
            return result;
        }
        catch (Exception e) {
            logger.info((Object)("wxqyh\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25: " + e.getMessage()));
            return result;
        }
    }

    private Map<String, List> getLappContextByRS(ILappContextHelper lappContextHelper, ResultSet rs) throws SQLException {
        HashMap<String, List> mapResult = new HashMap<String, List>();
        ArrayList<LappContext> lappContextList = new ArrayList<LappContext>();
        ArrayList<String> successUserIds = new ArrayList<String>();
        String corpId = lappContextHelper.getThirdPartyConfig().getAppId();
        ThirdPartyConfig.AppUserType appUserType = lappContextHelper.getThirdPartyConfig().getAppUserType();
        while (rs.next()) {
            LappContext result = new LappContext();
            String thirdpartyUserId = null;
            if (ThirdPartyConfig.AppUserType.USER_NAME.equals((Object)appUserType)) {
                thirdpartyUserId = rs.getString("FNUMBER");
            } else if (ThirdPartyConfig.AppUserType.PHONE.equals((Object)appUserType)) {
                thirdpartyUserId = rs.getString("FCELL");
            }
            if (corpId == null || corpId.trim().isEmpty() || thirdpartyUserId == null || thirdpartyUserId.trim().isEmpty()) continue;
            String userId = rs.getString("FID");
            result.setUserId(userId);
            result.setLappUserId(this.encodeToLappUserId(corpId, thirdpartyUserId));
            result.setLappUserType(LappContext.UserType.THIRD_PARTY);
            result.setCorpId(corpId);
            lappContextList.add(result);
            successUserIds.add(userId);
        }
        mapResult.put("lappContextList", lappContextList);
        mapResult.put("successUserIds", successUserIds);
        return mapResult;
    }

    private String encodeToLappUserId(String corpId, String userIndentity) {
        String lappUserId = corpId + "," + userIndentity;
        return new String(Base64.encodeBase64((byte[])lappUserId.getBytes()));
    }

    @Override
    public boolean enable(QingContext qingContext, IDBExcuter dbExcuter, ILappContextHelper lappContextHelper) {
        return StringUtils.isNotBlank((CharSequence)lappContextHelper.getThirdPartyConfig().getAppId());
    }
}

