/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.dao.impl.DBExcuterImpl;
import com.kingdee.bos.qing.common.dao.impl.TXManageImpl;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.common.session.impl.ORMSessionFactory;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.ICustomStrategy;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceSizeLimitedException;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.message.domain.MessageDomain;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.vo.SaveMessageVo;
import com.kingdee.bos.qing.publish.target.email.exception.EmailWarningRuleUnMatchedException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappWarningRuleUnMatchedException;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.ResourceManagerFactory;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.ScheduleEngine;
import com.kingdee.bos.qing.schedule.app.AbstractQingScheduleEntityControllerBean;
import com.kingdee.bos.qing.schedule.domain.ScheduleExecuteDomain;
import com.kingdee.bos.qing.schedule.executer.AbstractScheduleExecuter;
import com.kingdee.bos.qing.schedule.executer.ScheduleExecuterFactory;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.schedule.model.ScheduleMethodNameEnum;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.QingIntegratedUtil;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class QingScheduleEntityControllerBean
extends AbstractQingScheduleEntityControllerBean {
    private static Context login(Context easCtx, String userNumber, String orgId) throws CryptException, BOSLoginException, BOSException, EASBizException {
        String authType = "BaseTrdLtpaToken";
        LtpaToken token = LtpaTokenManager.generate((String)userNumber, (String)LtpaTokenManager.getDefaultLtpaConfig());
        String authPassword = token.getTokenStr();
        String encodePwd = CryptoTean.encrypt((String)userNumber, (String)authPassword);
        Locale locale = easCtx.getLocale();
        String clientIP = "UNKNOW";
        LoginContext loginCtx = new LoginContext(userNumber, encodePwd, easCtx.getSolution(), easCtx.getAIS(), locale, clientIP, clientIP);
        loginCtx.put("UserAuthPattern", (Object)authType);
        loginCtx.put("ClientIP", (Object)clientIP);
        String contextID = (String)loginCtx.get("contextID");
        if (contextID != null) {
            loginCtx.setContextID(contextID);
        }
        Context userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), loginCtx.getContextID());
        loginCtx.setContextID(userContext.getContextID());
        Context ctx = LoginModuleFactory.getLocalInstance((Context)easCtx).fullLogin(loginCtx);
        return ctx;
    }

    private void logout(Context ctx) {
        if (ctx == null) {
            return;
        }
        try {
            LoginModuleFactory.getRemoteInstance().logout(ctx.getContextID());
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private String getUserNumber(Context easctx, String userId) throws BOSException {
        IRowSet dataSet;
        block5: {
            String sql = "select FNumber from t_pm_user where fisdelete='0' and fislocked='0' and fforbidden='0' and fid=?";
            dataSet = null;
            dataSet = DbUtil.executeQuery((Context)easctx, (String)sql, (Object[])new Object[]{userId});
            if (!dataSet.next()) break block5;
            String string = dataSet.getString("FNumber");
            CloseUtil.close((ResultSet)dataSet);
            return string;
        }
        try {
            try {
                throw new RuntimeException("userId[" + userId + "] not exist.");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close(dataSet);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _execute(Context easCtx, String userId, String orgId, String params, String methodName) throws BOSException {
        LogUtil.info((String)("qingschedule execute userId:" + userId + ", orgId:" + orgId + ", params:" + params + ", methodName:" + methodName));
        String userNamber = this.getUserNumber(easCtx, userId);
        Context newCtx = null;
        ExecuteStateEnum executeStateEnum = ExecuteStateEnum.EXECUTING;
        String executeId = null;
        Exception exception = null;
        try {
            ScheduleExecuteDomain scheduleExecuteDomain;
            DBExcuterImpl dbExcuter;
            TXManageImpl tx;
            block11: {
                newCtx = QingScheduleEntityControllerBean.login(easCtx, userNamber, orgId);
                if (orgId != null) {
                    OrgSwitchFacadeFactory.getLocalInstance((Context)newCtx).orgSwitch(orgId);
                }
                ContextUtil.setDbType((Context)newCtx, (String)ContextUtil.getDbType((Context)easCtx));
                BOSObjectFactory.setContextToThread((Context)newCtx);
                WebContextUtil.initRpcConfig((Context)newCtx);
                ScheduleMethodNameEnum scheduleNameEnum = this.getScheduleExecuterNameEnum(methodName);
                AbstractScheduleExecuter scheduleExecuter = ScheduleExecuterFactory.getScheduleExecuter(scheduleNameEnum.getScheduleMethodName());
                QingIntegratedContext qingContext = QingIntegratedUtil.initQingIntegratedContext(newCtx, "");
                tx = new TXManageImpl(newCtx);
                dbExcuter = new DBExcuterImpl(tx);
                scheduleExecuter.setQingContext(qingContext);
                scheduleExecuter.setDbExcuter(dbExcuter);
                scheduleExecuter.setTx(tx);
                scheduleExecuter.setScheduleEngine((IScheduleEngine)new ScheduleEngine());
                ScheduleExecutePO scheduleExecutePO = scheduleExecuter.getScheduleExecutePO(qingContext, params, executeStateEnum);
                scheduleExecuteDomain = this.getScheduleExecuteDomain(qingContext);
                String sourceName = scheduleExecutePO.getSourceName();
                try {
                    executeId = scheduleExecuteDomain.insert(scheduleExecutePO);
                    scheduleExecuter.execute(newCtx, params, userId, orgId);
                    executeStateEnum = ExecuteStateEnum.SUCCESS;
                    String messageTitle = EASMessages.getMLS(qingContext, "messageTitleQuartzSuccess", "\u201c$param2\u201d\u8c03\u5ea6\u6210\u529f").replace("$param2", sourceName);
                    this.saveMessage(Collections.singletonList(scheduleExecutePO.getUserId()), messageTitle, executeId, qingContext, tx, dbExcuter, BizTypeEnum.QUARTZ_SUCCESS);
                }
                catch (Exception e) {
                    LogUtil.error((String)("qingschedule execute fail parameters:" + params), (Throwable)e);
                    executeStateEnum = ExecuteStateEnum.EXCEPTION;
                    exception = e;
                    Throwable cause = e.getCause();
                    if (cause == null) break block11;
                    if (cause instanceof EmailWarningRuleUnMatchedException || cause instanceof LappWarningRuleUnMatchedException) {
                        executeStateEnum = ExecuteStateEnum.WARNINGRULE_UNMATCHED;
                        String messageTitle = EASMessages.getMLS(qingContext, "messageTitleQuartzSuccessButUnMatched", "\u201c$param3\u201d\u8c03\u5ea6\u6210\u529f, \u4f46\u4e0d\u6ee1\u8db3\u9884\u8b66\u89c4\u5219, \u63a8\u9001\u5931\u8d25").replace("$param3", sourceName);
                        this.saveMessage(Collections.singletonList(scheduleExecutePO.getUserId()), messageTitle, executeId, qingContext, tx, dbExcuter, BizTypeEnum.QUARTZ_WARNINGRULE_UNMATCHED);
                    }
                    if (cause instanceof DataSourcePersistenceSizeLimitedException) {
                        executeStateEnum = ExecuteStateEnum.NOFILESTORAGE;
                    }
                    String messageTitle = EASMessages.getMLS(qingContext, "messageTitleQuartzFail", "\u201c$param1\u201d\u8c03\u5ea6\u5931\u8d25").replace("$param1", sourceName);
                    this.saveMessage(Collections.singletonList(scheduleExecutePO.getUserId()), messageTitle, executeId, qingContext, tx, dbExcuter, BizTypeEnum.QUARTZ_NEWS);
                }
            }
            scheduleExecuteDomain.updateExecuteState(executeId, executeStateEnum);
            if (exception != null) {
                this.insertExceptionLog(executeId, exception, dbExcuter, tx);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("qing schedule _execute error:" + e.getMessage()), (Throwable)e);
        }
        finally {
            this.logout(newCtx);
        }
    }

    protected void saveMessage(List<String> receiverIdList, String messageTitle, String bizId, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, BizTypeEnum bizTypeEnum) {
        if (CollectionUtils.isEmpty(receiverIdList)) {
            return;
        }
        SaveMessageVo saveMessageVo = new SaveMessageVo();
        saveMessageVo.setMessageLevel(MessageLevelTypeEnum.NORMAL_LEVEL);
        saveMessageVo.setMessageType(MessageTypeEnum.BIZ_NEWS);
        saveMessageVo.setMessageTitle(messageTitle);
        saveMessageVo.setBizId(bizId);
        saveMessageVo.setBizType(bizTypeEnum);
        saveMessageVo.setReceiverIdList(receiverIdList);
        try {
            this.getMessageDomain(qingContext, tx, dbExcuter).saveMessageWithTx(saveMessageVo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private MessageDomain getMessageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        return new MessageDomain(qingContext, tx, dbExcuter);
    }

    private ScheduleExecuteDomain getScheduleExecuteDomain(QingContext qingContext) {
        AbstractResourceManager resourceManager = ResourceManagerFactory.createResourceManager((QingContext)qingContext);
        return resourceManager.getScheduleExecuteDomain();
    }

    private ExceptionLogDomain getExceptionLogDomain(IDBExcuter dbExcuter, ITransactionManagement tx) {
        return new ExceptionLogDomain(tx, dbExcuter);
    }

    private void insertExceptionLog(String bizId, Exception e, IDBExcuter dbExcuter, ITransactionManagement tx) throws AbstractQingIntegratedException, SQLException {
        ExceptionLog exceptionLog = new ExceptionLog();
        exceptionLog.bindException((Throwable)e);
        exceptionLog.setBizTypeEnum(ExceptionLogBizTypeEnum.SCHEDULE_EXECUTE);
        exceptionLog.setBizId(bizId);
        this.getExceptionLogDomain(dbExcuter, tx).insert(exceptionLog);
    }

    private ScheduleMethodNameEnum getScheduleExecuterNameEnum(String methodName) {
        if ("extractData".equals(methodName)) {
            return ScheduleMethodNameEnum.EXTRACT_THEME_DATA;
        }
        if ("updateThumbnail".equals(methodName)) {
            return ScheduleMethodNameEnum.UPDATE_LAPP_THUMBNAIL;
        }
        return ScheduleMethodNameEnum.fromPersistance((String)methodName);
    }

    static {
        CustomStrategyRegistrar.register((ICustomStrategy)new ORMSessionFactory());
    }
}

