/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.executer.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.timingpush.TimingPushPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.AbstractPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.DataExtractTask;
import com.kingdee.bos.qing.preparedata.task.FromType;
import com.kingdee.bos.qing.publish.target.email.domain.EmailConfigScheduleExecuteDomain;
import com.kingdee.bos.qing.publish.target.email.domain.EmailSenderManageDomain;
import com.kingdee.bos.qing.publish.target.email.exception.NotFoundEmailSenderException;
import com.kingdee.bos.qing.publish.target.email.exception.SendEmailException;
import com.kingdee.bos.qing.publish.target.email.exception.SendEmailsInvalidReceiversException;
import com.kingdee.bos.qing.publish.target.email.exception.SendEmailsOtherException;
import com.kingdee.bos.qing.publish.target.email.exception.SendEmailsSenderException;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.model.EmailSenderVO;
import com.kingdee.bos.qing.publish.target.email.model.SendEmailBO;
import com.kingdee.bos.qing.publish.target.email.util.SendEmailUtil;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.exception.AbstractScheduleExecuteException;
import com.kingdee.bos.qing.schedule.executer.AbstractScheduleExecuter;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;

public class EmailPublishScheduleExecuter
extends AbstractScheduleExecuter {
    private EmailConfigScheduleExecuteDomain emailConfigScheduleExecuteDomain;
    private EmailSenderManageDomain emailSenderManageDomain;
    private ExceptionLogDomain exceptionLogDomain;

    private EmailConfigScheduleExecuteDomain getEmailConfigScheduleExecuteDomain() {
        if (this.emailConfigScheduleExecuteDomain == null) {
            this.emailConfigScheduleExecuteDomain = new EmailConfigScheduleExecuteDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.emailConfigScheduleExecuteDomain;
    }

    private EmailSenderManageDomain getEmailSenderManageDomain() {
        if (this.emailSenderManageDomain == null) {
            this.emailSenderManageDomain = new EmailSenderManageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.emailSenderManageDomain;
    }

    private ExceptionLogDomain getExceptionLogDomain() {
        if (this.exceptionLogDomain == null) {
            this.exceptionLogDomain = new ExceptionLogDomain(this.tx, this.dbExcuter);
        }
        return this.exceptionLogDomain;
    }

    @Override
    public void execute(Context ctx, String params, String userId, String orgId) throws Exception {
        Map paramsMap = (Map)JsonUtil.decodeFromString((String)params, Map.class);
        if (paramsMap.get("timeStamp") != null) {
            LogUtil.error((String)"start schedule push email");
        }
        String configId = paramsMap.get("sourceId").toString();
        String pkId = paramsMap.get("pkId").toString();
        boolean immediatelyPush = false;
        EmailConfig emailConfig = this.getEmailConfigScheduleExecuteDomain().getEmailConfigById(configId);
        if (emailConfig != null) {
            int sendEmailsStatus = 1;
            Throwable exception = null;
            String logPublishId = "";
            String publishId = "";
            String emailSubjectName = "";
            publishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
            try {
                String tag;
                emailSubjectName = this.getEmailConfigScheduleExecuteDomain().getSubjectName(emailConfig.getNameRule(), emailConfig.getId(), emailConfig.getSerialNum());
                EmailSenderVO emailSender = this.getEmailSenderManageDomain().getEmailSenderById(emailConfig.getSenderId(), this.qingContext.getUserId());
                if (emailSender != null) {
                    long timeStamp = System.currentTimeMillis();
                    if (paramsMap.get("timeStamp") != null) {
                        timeStamp = Long.parseLong((String)paramsMap.get("timeStamp"));
                        immediatelyPush = true;
                    }
                    if (immediatelyPush) {
                        ServerChannelMessagePublisher.publish((String)("ExtractData" + timeStamp), (String)"connectEmail");
                    }
                    ServerRequestInvokeContext.staticCheckInterrupt();
                    SendEmailUtil.connectTest((EmailSenderVO)emailSender);
                    ServerRequestInvokeContext.staticCheckInterrupt();
                    tag = UUID.randomUUID().toString();
                    this.emailExtractData(tag, emailConfig.getId());
                    ServerRequestInvokeContext.staticCheckInterrupt();
                    if (immediatelyPush) {
                        ServerChannelMessagePublisher.publish((String)("ExtractData" + timeStamp), (String)"pushing");
                    }
                } else {
                    throw new NotFoundEmailSenderException();
                }
                this.getEmailConfigScheduleExecuteDomain().savePublishInfo(publishId, emailConfig, tag, emailSubjectName);
                logPublishId = publishId;
                ServerRequestInvokeContext.staticCheckInterrupt();
                this.sendEmails(emailSender, emailConfig, paramsMap, emailSubjectName, publishId);
            }
            catch (SendEmailsInvalidReceiversException e) {
                sendEmailsStatus = 2;
                exception = e;
            }
            catch (Exception e) {
                sendEmailsStatus = 0;
                exception = e;
            }
            if (exception != null && immediatelyPush) {
                this.getEmailConfigScheduleExecuteDomain().deletePublishInfo(publishId);
                throw new SendEmailException("send email error", exception);
            }
            String id = this.getEmailConfigScheduleExecuteDomain().insertSendEmailsLog(emailConfig.getId(), logPublishId, emailSubjectName, sendEmailsStatus);
            if (exception != null) {
                ExceptionLog exceptionLog = new ExceptionLog();
                exceptionLog.setBizId(id);
                exceptionLog.setBizTypeEnum(ExceptionLogBizTypeEnum.EMAIL_TIMING_PUSH);
                exceptionLog.bindException(exception);
                this.getExceptionLogDomain().insert(exceptionLog);
                if (exception instanceof SendEmailsSenderException) {
                    throw new AbstractScheduleExecuteException(3006002, exception);
                }
                throw new AbstractScheduleExecuteException(exception);
            }
        } else {
            this.deleteJob(pkId);
        }
    }

    private void sendEmails(EmailSenderVO emailSender, EmailConfig emailConfig, Map<String, Object> executeParametersMap, String emailSubjectName, String publishId) throws SendEmailsOtherException, SendEmailsSenderException, SendEmailsInvalidReceiversException, URISyntaxException {
        String publishedRuntimeUrl = this.getPublishedRuntimeUrl(executeParametersMap.get("publishedRuntimeUrl").toString(), publishId);
        SendEmailBO sendEmail = this.createSendEmail(emailSender, emailConfig, publishedRuntimeUrl, emailSubjectName);
        SendEmailUtil.sendEmails((SendEmailBO)sendEmail);
    }

    private String getPublishedRuntimeUrl(String publishedRuntimeUrl, String publishId) throws URISyntaxException {
        try {
            publishedRuntimeUrl = URLDecoder.decode(publishedRuntimeUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error((String)"UnsupportedEncodingException error", (Throwable)e);
        }
        publishedRuntimeUrl = publishedRuntimeUrl.replace("(accountId)", this.qingContext.getAccountId());
        publishedRuntimeUrl = publishedRuntimeUrl.replace("(publishId)", publishId);
        publishedRuntimeUrl = this.appendUri(publishedRuntimeUrl, "timedPush=true");
        return publishedRuntimeUrl;
    }

    public String appendUri(String uri, String appendQuery) throws URISyntaxException {
        URI oldUri = new URI(uri);
        String newQuery = oldUri.getQuery();
        newQuery = newQuery == null ? appendQuery : newQuery + "&" + appendQuery;
        URI newUri = new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQuery, oldUri.getFragment());
        return newUri.toString();
    }

    @Override
    public void executeRunEmpty(Context ctx, String params, String userId, String orgId) throws AbstractQingException, SQLException {
        EmailConfig emailConfig = this.getEmailConfigScheduleExecuteDomain().getEmailConfigById(params);
        if (emailConfig != null) {
            String emailSubjectName = this.getEmailConfigScheduleExecuteDomain().getSubjectName(emailConfig.getNameRule(), emailConfig.getId(), emailConfig.getSerialNum());
            this.getEmailConfigScheduleExecuteDomain().insertSendEmailsLog(emailConfig.getId(), "", emailSubjectName, 3);
        }
    }

    @Override
    public ScheduleExecutePO getScheduleExecutePO(QingContext qingContext, String params, ExecuteStateEnum executeStateEnum) {
        Map paramsMap = (Map)JsonUtil.decodeFromString((String)params, Map.class);
        String sourceId = paramsMap.get("sourceId").toString();
        String scheduleName = EASMessages.getMLS(qingContext, "emailPublishSchedule", "\u8f7b\u5206\u6790\u90ae\u4ef6\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        String sourceName = EASMessages.getMLS(qingContext, "emailPublishSchedule", "\u8f7b\u5206\u6790\u90ae\u4ef6\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        if (paramsMap.get("sourceName") != null) {
            sourceName = paramsMap.get("sourceName").toString();
        }
        String scheduleNameEnum = "emailPublishExecute";
        ScheduleExecutePO scheduleExecutePO = new ScheduleExecutePO();
        scheduleExecutePO.setTenantId(qingContext.getTenantId());
        scheduleExecutePO.setUserId(qingContext.getUserId());
        scheduleExecutePO.setScheduleName(scheduleName);
        scheduleExecutePO.setSourceId(sourceId);
        scheduleExecutePO.setSourceName(sourceName);
        scheduleExecutePO.setScheduleExecuterNameEnum(scheduleNameEnum);
        scheduleExecutePO.setExecuteStateEnum(executeStateEnum);
        return scheduleExecutePO;
    }

    private void emailExtractData(String tag, String emailConfigId) throws PrepareDataException {
        TimingPushPrepareDataContext timingPushPrepareDataContext = new TimingPushPrepareDataContext();
        timingPushPrepareDataContext.setQingContext(this.qingContext);
        timingPushPrepareDataContext.setDbExcuter(this.dbExcuter);
        timingPushPrepareDataContext.setTx(this.tx);
        timingPushPrepareDataContext.setScheduleEngine(this.scheduleEngine);
        timingPushPrepareDataContext.setTag(tag);
        timingPushPrepareDataContext.setFromType(FromType.timingPushEmail);
        timingPushPrepareDataContext.setDealProgresss(false);
        timingPushPrepareDataContext.setStartBySchedule(true);
        timingPushPrepareDataContext.setTimeStamp(System.currentTimeMillis());
        timingPushPrepareDataContext.setConfigId(emailConfigId);
        DataExtractTask dataExtractTask = new DataExtractTask((AbstractPrepareDataContext)timingPushPrepareDataContext);
        try {
            dataExtractTask.call();
        }
        catch (PrepareDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrepareDataException((Throwable)e);
        }
    }

    private SendEmailBO createSendEmail(EmailSenderVO emailSender, EmailConfig emailConfig, String publishedRuntimeUrl, String emailSubjectName) {
        SendEmailBO sendEmail = new SendEmailBO();
        sendEmail.setSenderSmtpHost(emailSender.getSmtpHost());
        sendEmail.setSenderAccount(emailSender.getAccount());
        sendEmail.setSenderPwd(emailSender.getPwd());
        sendEmail.setSenderIsSSL(emailSender.isSSL());
        sendEmail.setSenderPort(emailSender.getPort());
        sendEmail.setReceivers(emailConfig.getReceivers());
        sendEmail.setRuntimeUrl(publishedRuntimeUrl);
        sendEmail.setContent(emailConfig.getContent());
        sendEmail.setSubject(emailSubjectName);
        return sendEmail;
    }
}

