/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.subject;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.source.easmeta.EasDBCenterSourceDomain;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.ModelDecoder;
import com.kingdee.bos.qing.data.model.designtime.source.MetaSource;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.subject.AbstractSubjectModelingService;
import com.kingdee.bos.qing.subject.QingPermissionException;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SubjectModelingService
extends AbstractSubjectModelingService {
    private static final String QING_PERMISSION_ITEMENAME = "qing_analysis_metadata";
    private static final String QING_PERMISSION_ITEMENAME_OLD = "qing_analysis_functional";
    private static final String QING_METADB_PERMISSION_ITEMENAME = "qing_analysis_metadb";

    public byte[] getDataCenterList(Map<String, String> params) {
        ArrayList dcList = null;
        try {
            dcList = DCManager.getInstance().getDCList();
        }
        catch (Exception e) {
            String msg = "getDataCenterList failed";
            LogUtil.error((String)msg, (Throwable)e);
        }
        HashMap<String, String> dcMap = null;
        ArrayList dcMapList = new ArrayList();
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        Context bosCtx = qingIntegratedContext.getBosContext();
        for (DCInfo dcInfo : dcList) {
            String ais = bosCtx.getAIS();
            if (!dcInfo.getNumber().equals(ais)) continue;
            dcMap = new HashMap<String, String>();
            dcMap.put("number", dcInfo.getNumber());
            dcMap.put("name", dcInfo.getName(bosCtx.getLocale().getLanguage().toUpperCase()));
            dcMap.put("isCurrent", dcInfo.getNumber().equals(ais) + "");
            dcMapList.add(dcMap);
        }
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(dcMapList));
    }

    public byte[] getDBCenterDBType(Map<String, String> params) {
        try {
            EasDBCenterSourceDomain eadDBCenterSourceDomain = new EasDBCenterSourceDomain();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)eadDBCenterSourceDomain.getDbType(((QingIntegratedContext)this.qingContext).getBosContext())));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getQingAnalysisPermission(Map<String, String> params) {
        try {
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
            Context bosCtx = qingIntegratedContext.getBosContext();
            Boolean easEntityPermision = SubjectModelingService.hasFunctionalPermission(bosCtx);
            Boolean easDBCenterPermission = SubjectModelingService.hasMetaDBPermission(bosCtx);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put(MetaSource.MetaType.EASEntity.name(), easEntityPermision);
            result.put(MetaSource.MetaType.EASQuery.name(), easEntityPermision);
            result.put(MetaSource.MetaType.EASDBCenter.name(), easDBCenterPermission);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public static boolean hasFunctionalPermission(Context ctx) throws QingPermissionException {
        try {
            return SubjectModelingService.hasPermission(ctx, QING_PERMISSION_ITEMENAME);
        }
        catch (Exception e) {
            try {
                return SubjectModelingService.hasPermission(ctx, QING_PERMISSION_ITEMENAME_OLD);
            }
            catch (Exception e1) {
                throw QingPermissionException.fail2CheckPermission(e1.getMessage());
            }
        }
    }

    public static boolean hasMetaDBPermission(Context ctx) throws QingPermissionException {
        try {
            return SubjectModelingService.hasPermission(ctx, QING_METADB_PERMISSION_ITEMENAME);
        }
        catch (Exception e) {
            throw QingPermissionException.fail2CheckPermission(e.getMessage());
        }
    }

    private static boolean hasPermission(Context ctx, String permissonName) throws BOSException, EASBizException {
        if (ctx == null) {
            return false;
        }
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(currentOrgUnit.getId());
        return iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissonName);
    }

    public byte[] getEntityTitle(Map<String, String> params) {
        try {
            String jsonEntity = params.get("entity");
            String jsonSource = params.get("source");
            AbstractSource source = (AbstractSource)ModelDecoder.decode((String)jsonSource, AbstractSource.class);
            AbstractEntity entity = (AbstractEntity)ModelDecoder.decode((String)jsonEntity, AbstractEntity.class);
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain((AbstractSource)source);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)sourceDomain.getEntityTitle(this.qingContext, entity)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

