/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.dao.impl.DBExcuterImpl;
import com.kingdee.bos.qing.common.dao.impl.TXManageImpl;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.preset.strategy.IQingUserStrategy;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureCollection;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureFactory;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureInfo;
import com.kingdee.bos.webframework.dynamic.IDynamicConfigure;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntegratedHelperImpl
implements IIntegratedHelperStrategy,
IQingContextable,
IDBAccessable {
    private String language;
    private static final String NORMAL_USER_CONDITION = " AND FISDELETE =0 AND FISLOCKED=0 AND FFORBIDDEN=0";
    private QingContext qingContext;
    private IDBExcuter dbExcuter;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public final void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
    }

    private IDBExcuter getDbExcuter() {
        if (this.dbExcuter == null) {
            QingContext context = QingContext.getCurrent();
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)context;
            Context bosCtx = qingIntegratedContext.getBosContext();
            TXManageImpl tx = new TXManageImpl(bosCtx);
            DBExcuterImpl dbExcuter = new DBExcuterImpl(tx);
            return dbExcuter;
        }
        return this.dbExcuter;
    }

    private String getLanguage() {
        try {
            if (this.language == null) {
                if (this.qingContext == null) {
                    this.qingContext = QingContext.getCurrent();
                }
                QingIntegratedContext context = (QingIntegratedContext)this.qingContext;
                Context bosContext = context.getBosContext();
                this.language = bosContext.getLocale().getLanguage();
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"qing get language failed", (Throwable)e);
            this.language = "en";
        }
        return this.language;
    }

    public String getUserName(String userId) {
        if (this.getPresetUserId().equals(userId)) {
            return String.format(EASMessages.getMLS(this.qingContext.getIi18nContext(), "presetUserName", "?????"), new Object[0]);
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId);
        List<String> userNames = this.getUserNames(userIds);
        if (userNames != null && userNames.size() > 0) {
            return userNames.get(0);
        }
        return null;
    }

    public boolean isNormalUser(String userId) {
        String sql = "SELECT FID FROM T_PM_USER WHERE FID = ? AND FISDELETE =0 AND FISLOCKED=0 AND FFORBIDDEN=0";
        try {
            return (Boolean)this.getDbExcuter().query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getRoleName(String roleId) {
        String sql = "SELECT FNAME_" + this.getLanguage() + " ROLENAME FROM T_PM_ROLE WHERE FID = ?";
        try {
            return (String)this.getDbExcuter().query(sql, new Object[]{roleId}, (ResultHandler)new ResultHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        return rs.getString("ROLENAME");
                    }
                    return null;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<String> getUserIdsByRoleId(String roleId) {
        String sql = "SELECT URO.FUSERID, U.FNAME_" + this.getLanguage() + " USERNAME FROM T_PM_USERROLEORG URO LEFT JOIN T_PM_USER U ON URO.FUSERID = U.FID WHERE URO.FROLEID = ? AND U.FISDELETE =0 AND U.FISLOCKED=0 AND U.FFORBIDDEN=0";
        try {
            return (List)this.getDbExcuter().query(sql, new Object[]{roleId}, (ResultHandler)new ResultHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> userInfos = new ArrayList<String>();
                    while (rs.next()) {
                        userInfos.add(rs.getString("FUSERID"));
                    }
                    return userInfos;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<String> getValidUserIds(List<String> userIds) {
        String sqlInQuestion = "?";
        if (userIds != null && userIds.size() > 0) {
            for (int i = 1; i < userIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            return null;
        }
        String sql = "SELECT FID FROM T_PM_USER WHERE FID IN (" + sqlInQuestion + ")" + NORMAL_USER_CONDITION;
        try {
            return (List)this.getDbExcuter().query(sql, userIds.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> userIds = new ArrayList<String>();
                    while (rs.next()) {
                        userIds.add(rs.getString("FID"));
                    }
                    return userIds;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<String> getValidRoleIds(List<String> roleIds) {
        String sqlInQuestion = "?";
        if (roleIds != null && roleIds.size() > 0) {
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            return new ArrayList<String>();
        }
        String sql = "SELECT FID FROM T_PM_ROLE WHERE FID IN (" + sqlInQuestion + ")";
        try {
            return (List)this.getDbExcuter().query(sql, roleIds.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> roleIds = new ArrayList<String>();
                    while (rs.next()) {
                        roleIds.add(rs.getString("FID"));
                    }
                    return roleIds;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<String> getUserNames(List<String> userIds) {
        String sqlInQuestion = "?";
        if (userIds != null && userIds.size() > 0) {
            for (int i = 1; i < userIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            return null;
        }
        String sql = "SELECT FNAME_" + this.getLanguage() + " USERNAME FROM T_PM_USER WHERE FID IN (" + sqlInQuestion + ")";
        try {
            return (List)this.getDbExcuter().query(sql, userIds.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> userNames = new ArrayList<String>();
                    while (rs.next()) {
                        userNames.add(rs.getString("USERNAME"));
                    }
                    return userNames;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static IQingUserStrategy getQingUserStrategyImpl() {
        IQingUserStrategy qingUserStrategy = (IQingUserStrategy)CustomStrategyRegistrar.getStrategy(IQingUserStrategy.class);
        if (qingUserStrategy == null) {
            throw new RuntimeException("cannot found the implement of IQingUserStrategy.");
        }
        return qingUserStrategy;
    }

    public String getQingAdminRoleID() {
        return IntegratedHelperImpl.getQingUserStrategyImpl().getPresetRoleId();
    }

    public String getPresetUserId() {
        return IntegratedHelperImpl.getQingUserStrategyImpl().getPresetUserId();
    }

    public Set<String> getUserRoleIds() {
        String sql = "SELECT FROLEID \t\tFROM T_PM_USERROLEORG URO\t\tWHERE URO.FUSERID = ?\t\tAND EXISTS (\t\t\t\tSELECT TOP 1 FORGID\t\t\t\tFROM T_PM_ORGRANGE\t\t\t\tWHERE FUSERID = ?\t\t\t\tAND FTYPE = 10 AND URO.FORGID = FORGID)";
        try {
            return (Set)this.getDbExcuter().query(sql, new Object[]{this.qingContext.getUserId(), this.qingContext.getUserId()}, (ResultHandler)new ResultHandler<Set<String>>(){

                public Set<String> handle(ResultSet rs) throws SQLException {
                    HashSet<String> roleIds = new HashSet<String>();
                    while (rs.next()) {
                        roleIds.add(rs.getString("FROLEID"));
                    }
                    return roleIds;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Set<String> getUserRoleIds(String userId) {
        String sql = "SELECT FROLEID \t\tFROM T_PM_USERROLEORG URO\t\tWHERE URO.FUSERID = ?\t\tAND EXISTS (\t\t\t\tSELECT TOP 1 FORGID\t\t\t\tFROM T_PM_ORGRANGE\t\t\t\tWHERE FUSERID = ?\t\t\t\tAND FTYPE = 10 AND URO.FORGID = FORGID)";
        try {
            return (Set)this.getDbExcuter().query(sql, new Object[]{userId, userId}, (ResultHandler)new ResultHandler<Set<String>>(){

                public Set<String> handle(ResultSet rs) throws SQLException {
                    HashSet<String> roleIds = new HashSet<String>();
                    while (rs.next()) {
                        roleIds.add(rs.getString("FROLEID"));
                    }
                    return roleIds;
                }
            });
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getEntityDisplayName(String formId) {
        return formId;
    }

    public String queryFormDisplayName(String formId, String publishSourceType) {
        String path = formId;
        try {
            Context ctx = ((QingIntegratedContext)this.qingContext).getBosContext();
            if (PublishSourceEnum.bill.name().equals(publishSourceType)) {
                String uipk = formId.split(";")[0];
                DynamicConfigureInfo configureInfo = this.getDynamicConfigureInfoByUipk(ctx, uipk);
                String entityObjectName = configureInfo.getEntityObjectName();
                EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityObjectName));
                path = entityInfo.getAlias() == null ? entityInfo.getName() : entityInfo.getAlias();
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"queryFormDisplayName failed! ", (Throwable)e);
        }
        return path;
    }

    private DynamicConfigureInfo getDynamicConfigureInfoByUipk(Context ctx, String uipk) {
        DynamicConfigureInfo pageInfo = null;
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("entityObjectName"));
        selectorItemCollection.add(new SelectorItemInfo("parentID"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("webUIObjectName", (Object)uipk, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        try {
            IDynamicConfigure iDynamicConfigure = DynamicConfigureFactory.getLocalInstance((Context)ctx);
            DynamicConfigureCollection dynamicConfigureCollection = iDynamicConfigure.getDynamicConfigureCollection(entityViewInfo);
            if (dynamicConfigureCollection.size() > 0) {
                pageInfo = dynamicConfigureCollection.get(0);
            }
        }
        catch (BOSException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return pageInfo;
    }

    public String queryEntityFullPath(String formId, String publishSourceType) {
        if (PublishSourceEnum.bill.name().equals(publishSourceType)) {
            return EASMessages.getMLS(this.qingContext, "bill", "\u951f\u65a4\u62f7\u951f\u65a4\u62f7");
        }
        if (PublishSourceEnum.control.name().equals(publishSourceType)) {
            return EASMessages.getMLS(this.qingContext, "control", "\u951f\u622a\u7877\u62f7");
        }
        return formId;
    }

    public Map<String, String> queryEntityFullPath(Collection<Map<String, String>> formIds) {
        HashMap<String, String> formNameMap = new HashMap<String, String>(16);
        for (Map<String, String> tagIdTypeMap : formIds) {
            String formId = tagIdTypeMap.get("fTagId");
            String publishSourceType = tagIdTypeMap.get("publishSourceType");
            if (PublishSourceEnum.bill.name().equals(publishSourceType)) {
                formNameMap.put(formId, EASMessages.getMLS(this.qingContext, "bill", "\u951f\u65a4\u62f7\u951f\u65a4\u62f7"));
                continue;
            }
            if (PublishSourceEnum.control.name().equals(publishSourceType)) {
                formNameMap.put(formId, EASMessages.getMLS(this.qingContext, "control", "\u951f\u622a\u7877\u62f7"));
                continue;
            }
            formNameMap.put(formId, formId);
        }
        return formNameMap;
    }

    public boolean checkMapPermission(QingContext qingContext) {
        try {
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)qingContext;
            Context bosCtx = qingIntegratedContext.getBosContext();
            if (bosCtx == null) {
                return false;
            }
            if (qingIntegratedContext.getUserId().equals(this.getPresetUserId())) {
                return true;
            }
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)bosCtx);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)bosCtx);
            OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)bosCtx);
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            ObjectUuidPK orgPK = new ObjectUuidPK(currentOrgUnit.getId());
            return iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "qing_analysis_map");
        }
        catch (Exception e) {
            LogUtil.error((String)"check qing map permisson failed", (Throwable)e);
            return false;
        }
    }

    public boolean checkExtreportPermission(QingContext qingContext) {
        return false;
    }

    public boolean checkMacroPermission(QingContext qingContext) {
        try {
            return IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)qingContext, (IDBExcuter)this.dbExcuter);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkMacroPermission(QingContext qingContext, String appId) {
        return this.checkMacroPermission(qingContext);
    }

    public boolean checkDBManagePermission(QingContext qingContext, String appId) {
        try {
            return IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)qingContext, (IDBExcuter)this.dbExcuter);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getJobId(String userId) {
        return null;
    }

    public List<String> getJobIds(List<String> userId) {
        return null;
    }

    public String getId() {
        return IIntegratedHelperStrategy.class.getName();
    }
}

