/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.datasource;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.MultiFileDataSource;
import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.datasource.MultiFileDataSourceCreator;
import com.kingdee.bos.qing.common.datasource.SimpleDataSourceCreator;
import com.kingdee.bos.qing.common.datasource.UnkownDataSouceCreator;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpansCacheUtil;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.subject.domain.SubjectDataSouceCreator;
import com.kingdee.bos.qing.util.LogUtil;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class DataSourceCreatorFactory {
    private static Map<String, Class<? extends AbstractDomain.IDataSourceCreator>> f = new HashMap<String, Class<? extends AbstractDomain.IDataSourceCreator>>();

    public static void registDataSourceCreator(Class<? extends AbstractDataSource> clazz, Class<? extends AbstractDomain.IDataSourceCreator> dataSourceCreatorClazz) {
        f.put(clazz.getSimpleName(), dataSourceCreatorClazz);
    }

    public static AbstractDomain.IDataSourceCreator getDataSourceCreator(QingContext qingContext, String tag) {
        Class<? extends AbstractDomain.IDataSourceCreator> clazz;
        TraceSpansCacheUtil.setTag((String)tag);
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
        if (dataSource != null && (clazz = f.get(dataSource.getClass().getSimpleName())) != null) {
            try {
                Constructor<? extends AbstractDomain.IDataSourceCreator> constructor = clazz.getConstructor(QingContext.class, String.class, AbstractDataSource.class);
                return constructor.newInstance(qingContext, tag, dataSource);
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
                return new UnkownDataSouceCreator();
            }
        }
        if (dataSource instanceof SingleFileDataSource) {
            return new SimpleDataSourceCreator((SingleFileDataSource)dataSource);
        }
        if (dataSource instanceof MultiFileDataSource) {
            if (dataSource instanceof ThemeDataSource) {
                return new SubjectDataSouceCreator(qingContext, tag, (ThemeDataSource)dataSource);
            }
            return new MultiFileDataSourceCreator(qingContext, (MultiFileDataSource)dataSource);
        }
        LogUtil.warn((String)("could not find data source for tag:" + tag));
        return new UnkownDataSouceCreator();
    }
}

