/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.datasource;

import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.common.datasource.AbstractImpl;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IMetaVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.ClientAndTmpFileRelationManager;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;

public class SimpleDataSourceCreator
extends AbstractImpl {
    private SingleFileDataSource dataSource;

    public SimpleDataSourceCreator(SingleFileDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public IMetaVisitor createMetaVisitor() throws AbstractDataSourceException {
        return this.createDataSourceVisitor();
    }

    public IDataSourceVisitor createDataSourceVisitor() throws AbstractDataSourceException {
        ClientAndTmpFileRelationManager.enableBind((boolean)true);
        try {
            IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)this.dataSource.getStoreFileType(), (String)this.dataSource.getFileName());
            QSDataSourceVisitor qSDataSourceVisitor = new QSDataSourceVisitor(dataFile);
            return qSDataSourceVisitor;
        }
        finally {
            ClientAndTmpFileRelationManager.enableBind((boolean)false);
        }
    }
}

