/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.domain.CommonDsbDesignDomain;
import com.kingdee.bos.qing.imagelibrary.domian.ImageLibraryDomain;
import com.kingdee.bos.qing.manage.model.FolderNode;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.IScheduleEngineable;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.service.AbstractDashboardService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCommonDsbDesignService
extends AbstractDashboardService
implements IQingContextable,
IDBAccessable,
IScheduleEngineable {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected IScheduleEngine scheduleEngine;
    private ImageLibraryDomain imageLibraryDomain;
    private SchemaDomain schemaDomain;
    private CommonDsbDesignDomain dsbDesignDomain;

    public abstract byte[] loadModel(Map<String, String> var1);

    public abstract byte[] saveModel(Map<String, String> var1);

    public abstract byte[] loadAppMenuTree(Map<String, String> var1);

    public abstract byte[] loadAppMenuTreeForExtreport(Map<String, String> var1);

    public abstract byte[] loadAppmenuPublish(Map<String, String> var1);

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private CommonDsbDesignDomain getDsbDesignDomain() {
        if (this.dsbDesignDomain == null) {
            this.dsbDesignDomain = new CommonDsbDesignDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.dsbDesignDomain;
    }

    private ImageLibraryDomain getImageLibraryDomain() {
        if (this.imageLibraryDomain == null) {
            this.imageLibraryDomain = new ImageLibraryDomain();
            this.imageLibraryDomain.setTx(this.tx);
            this.imageLibraryDomain.setQingContext(this.qingContext);
            this.imageLibraryDomain.setDbExcuter(this.dbExcuter);
        }
        return this.imageLibraryDomain;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setTx(this.tx);
            this.schemaDomain.setDbExcuter(this.dbExcuter);
        }
        return this.schemaDomain;
    }

    public final byte[] getAllSubject(Map<String, String> params) {
        String userID = this.qingContext.getUserId();
        try {
            FolderNode root = this.getDsbDesignDomain().getAllSubject(userID);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)root);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] checkExtreportPermission(Map<String, String> params) {
        String userID = this.qingContext.getUserId();
        try {
            boolean hasExtreportPerm = this.getDsbDesignDomain().checkExtreportPermission();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)hasExtreportPerm);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] loadSubjectSchemaAttrs(Map<String, String> params) {
        String userId = this.qingContext.getUserId();
        String themeID = params.get("themeId");
        int source = Integer.parseInt(params.get("source"));
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getDsbDesignDomain().loadSubjectSchemaAttrs(userId, themeID, source));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] loadBizSchemaAttrs(Map<String, String> params) {
        try {
            String userId = this.qingContext.getUserId();
            String bizTagId = params.get("bizTag");
            int source = Integer.parseInt(params.get("source"));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getDsbDesignDomain().loadSchemaAttrs(userId, bizTagId, source)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getSubjectReferenceMap(Map<String, String> params) {
        RefTypeEnum refType = RefTypeEnum.subject;
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getDsbDesignDomain().getReferenceMap(params, refType));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getExtreportReferenceMap(Map<String, String> params) {
        RefTypeEnum refType = RefTypeEnum.qingreport;
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getDsbDesignDomain().getReferenceMap(params, refType));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getCardReferenceMap(Map<String, String> params) {
        RefTypeEnum refType = RefTypeEnum.card;
        try {
            Map<String, Object> result = this.getDsbDesignDomain().getReferenceMap(params, refType);
            HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
            publishOperMapResult.put("operation", result.get("operation"));
            publishOperMapResult.put("scene", "square");
            result.put("operation", publishOperMapResult);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getPictureReferenceMap(Map<String, String> params) {
        RefTypeEnum refType = RefTypeEnum.picture;
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getDsbDesignDomain().getReferenceMap(params, refType));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] getPublishReferenceMap(Map<String, String> params) {
        String publishType = params.get("publishType");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getDsbDesignDomain().getPublishReferenceMap(params, publishType));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] getImageSize(Map<String, String> params) {
        String imageFileName = params.get("imageFileName");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getImageLibraryDomain().getImageSize(imageFileName));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] loadQingcenterGroup(Map<String, String> params) {
        try {
            Map<String, Object> result = this.getDsbDesignDomain().loadAnalysisCenterGroupForDsb();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] loadAnalysisCenterExtreportGroup(Map<String, String> params) {
        try {
            Map<String, Object> result = this.getDsbDesignDomain().loadAnalysisCenterExtreportGroup();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getPublishSchema(Map<String, String> params) {
        try {
            String publishId = params.get("publishId");
            Map<String, Boolean> result = this.getDsbDesignDomain().checkPublishCanUseOrNot(publishId);
            if (result.get("canUse") != null) {
                int source = 0;
                String userId = this.qingContext.getUserId();
                ArrayList<SchemaAttrVO> schemaAttrVOs = this.getSchemaDomain().loadSchemaAttrsForDsb(publishId, userId, source);
                ResponseSuccessWrap wrap = new ResponseSuccessWrap(schemaAttrVOs);
                this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
                return ResponseUtil.output((IResponseWrap)wrap);
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkPublishInfoAndPermission(Map<String, String> params) {
        String publishId = params.get("publishId");
        String modelJsonString = params.get("selectModel");
        String userId = this.qingContext.getUserId();
        try {
            Map<String, String> checkResultMap = this.getSchemaDomain().checkPublishInfoAndPermission(publishId, modelJsonString, userId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(checkResultMap);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

