/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.AbstractCommonDsbDesignService;
import com.kingdee.bos.qing.dashboard.domain.DashboardDesignDomain;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ModelJsonDecoder;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDashboardDesignService
extends AbstractCommonDsbDesignService {
    private static final String PARAM_MODEL = "model";
    protected DashboardDesignDomain dashboardDesignDomain;
    protected CommonPublishDomain commonPublishDomain;

    protected DashboardDesignDomain getDashboardDesignDomain() {
        if (this.dashboardDesignDomain == null) {
            this.dashboardDesignDomain = new DashboardDesignDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.dashboardDesignDomain;
    }

    protected CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public final byte[] loadModel(Map<String, String> params) {
        String dsbId = params.get("dsbId");
        try {
            DashboardModel dashboard = this.getDashboardDesignDomain().loadModelForDesign(dsbId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dashboard);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public final byte[] saveModel(Map<String, String> params) {
        String dsbModel = params.get(PARAM_MODEL);
        String dsbId = params.get("dsbId");
        DashboardModel model = ModelJsonDecoder.decode((String)dsbModel);
        try {
            this.getDashboardDesignDomain().saveDsbAndReferences(dsbId, model);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] squareLoadSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String dsbId = params.get("dashboardUniqueId");
        String editSchema = params.get("editSchema");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ModelBook modelBook = this.getDashboardDesignDomain().loadSchema(referenceMap, dsbId, editSchema);
            result.put(PARAM_MODEL, modelBook);
            Map publishOperMap = this.getCommonPublishDomain().loadPublishOperList(referenceMap.getRefToId(), null, true, false);
            HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
            publishOperMapResult.put("operation", publishOperMap);
            publishOperMapResult.put("scene", "square");
            result.put("operation", publishOperMapResult);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] squareSaveSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String jsonModelBook = params.get(PARAM_MODEL);
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        ModelBook modelBook = com.kingdee.bos.qing.core.model.ModelJsonDecoder.decode((String)jsonModelBook);
        try {
            this.getDashboardDesignDomain().saveSchema(referenceMap, modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] longerLoadSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String dsbId = params.get("dashboardUniqueId");
        String editSchema = params.get("editSchema");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ModelBook modelBook = this.getDashboardDesignDomain().loadSchema(referenceMap, dsbId, editSchema);
            result.put(PARAM_MODEL, modelBook);
            HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
            publishOperMapResult.put("operation", this.getCommonPublishDomain().loadPublishOperList(referenceMap.getRefToId(), null, true, false));
            publishOperMapResult.put("scene", "longer");
            result.put("operation", publishOperMapResult);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] longerSaveSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String jsonModelBook = params.get(PARAM_MODEL);
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        ModelBook modelBook = com.kingdee.bos.qing.core.model.ModelJsonDecoder.decode((String)jsonModelBook);
        try {
            this.getDashboardDesignDomain().saveSchema(referenceMap, modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

