/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.AbstractCommonDsbDesignService;
import com.kingdee.bos.qing.dashboard.domain.DashboardDesignDomain;
import com.kingdee.bos.qing.dashboard.domain.PublishedDsbDesignDomain;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ModelJsonDecoder;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPublishedDsbDesignService
extends AbstractCommonDsbDesignService {
    private PublishedDsbDesignDomain publishedDsbDesignDomain;
    protected CommonPublishDomain commonPublishDomain;
    private DashboardDesignDomain dashboardDesignDomain;

    protected PublishedDsbDesignDomain getPublishedDsbDesignDomain() {
        if (this.publishedDsbDesignDomain == null) {
            this.publishedDsbDesignDomain = new PublishedDsbDesignDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.publishedDsbDesignDomain;
    }

    protected CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    @Override
    public byte[] loadModel(Map<String, String> params) {
        String publishId = params.get("publishId");
        try {
            DashboardModel dashboardModel = this.getPublishedDsbDesignDomain().loadPublishedDsbModel(publishId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)dashboardModel));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] saveModel(Map<String, String> params) {
        String publishId = params.get("dashboardUniqueId");
        String dsbModel = params.get("model");
        DashboardModel model = ModelJsonDecoder.decode((String)dsbModel);
        try {
            this.getPublishedDsbDesignDomain().savePublishedDsbModel(publishId, model);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)Boolean.TRUE));
        }
        catch (AbstractQingException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
    }

    public byte[] squareLoadSchema(Map<String, String> params) {
        String publishId = params.get("dashboardUniqueId");
        String jsonRef = params.get("ref");
        String editSchema = params.get("editSchema");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        try {
            ModelBook modelBook = this.getPublishedDsbDesignDomain().loadSchema(publishId, referenceMap, editSchema);
            HashMap<String, Object> rs = new HashMap<String, Object>();
            rs.put("model", modelBook);
            Map publishOperMap = this.getCommonPublishDomain().loadPublishOperList(referenceMap.getRefToId(), null, true, false);
            HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
            publishOperMapResult.put("operation", publishOperMap);
            publishOperMapResult.put("scene", "square");
            rs.put("operation", publishOperMapResult);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] squareSaveSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String jsonModelBook = params.get("model");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        ModelBook modelBook = com.kingdee.bos.qing.core.model.ModelJsonDecoder.decode((String)jsonModelBook);
        try {
            this.getPublishedDsbDesignDomain().saveSchema(referenceMap, modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] longerLoadSchema(Map<String, String> params) {
        String publishId = params.get("dashboardUniqueId");
        String jsonRef = params.get("ref");
        String editSchema = params.get("editSchema");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        try {
            ModelBook modelBook = this.getPublishedDsbDesignDomain().loadSchema(publishId, referenceMap, editSchema);
            HashMap<String, Object> rs = new HashMap<String, Object>();
            rs.put("model", modelBook);
            HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
            publishOperMapResult.put("operation", this.getCommonPublishDomain().loadPublishOperList(referenceMap.getRefToId(), null, true, false));
            publishOperMapResult.put("scene", "longer");
            rs.put("operation", publishOperMapResult);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] longerSaveSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String jsonModelBook = params.get("model");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        ModelBook modelBook = com.kingdee.bos.qing.core.model.ModelJsonDecoder.decode((String)jsonModelBook);
        try {
            this.getPublishedDsbDesignDomain().saveSchema(referenceMap, modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    protected DashboardDesignDomain getDashboardDesignDomain() {
        if (this.dashboardDesignDomain == null) {
            this.dashboardDesignDomain = new DashboardDesignDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.dashboardDesignDomain;
    }

    public abstract byte[] syncModelToDsbSource(Map<String, String> var1);

    public abstract byte[] syncModelToNewDsb(Map<String, String> var1);

    public abstract byte[] listUnpresetThemeGroup(Map<String, String> var1);

    public abstract byte[] checkResourceLockStatus(Map<String, String> var1);

    public abstract byte[] checkPublishExist(Map<String, String> var1);
}

