/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.domain.DashboardRuntimeDomain;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.imagelibrary.domian.ImageLibraryDomain;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.IScheduleEngineable;
import com.kingdee.bos.qing.service.AbstractDashboardService;
import com.kingdee.bos.qing.service.IDashboardService;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRuntimeDashboardService
extends AbstractDashboardService
implements IDashboardService,
IQingContextable,
IDBAccessable,
IScheduleEngineable {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected IScheduleEngine scheduleEngine;
    private DashboardRuntimeDomain dashboardRuntimeDomain;
    private ImageLibraryDomain imageLibraryDomain;
    private CommonPublishDomain commonPublishDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    protected ImageLibraryDomain getImageLibraryDomain() {
        if (this.imageLibraryDomain == null) {
            this.imageLibraryDomain = new ImageLibraryDomain();
            this.imageLibraryDomain.setTx(this.tx);
            this.imageLibraryDomain.setQingContext(this.qingContext);
            this.imageLibraryDomain.setDbExcuter(this.dbExcuter);
        }
        return this.imageLibraryDomain;
    }

    protected DashboardRuntimeDomain getDashboardRuntimeDomain() {
        if (this.dashboardRuntimeDomain == null) {
            this.dashboardRuntimeDomain = new DashboardRuntimeDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.dashboardRuntimeDomain;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    public final byte[] loadPublishedDsb(Map<String, String> params) {
        try {
            String publishId = params.get("dashboardUniqueId");
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getDashboardRuntimeDomain().loadDsbModel(publishId));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] loadPublishedDsbWithOper(Map<String, String> params) {
        try {
            String publishId = params.get("dashboardUniqueId");
            boolean timedPush = Boolean.parseBoolean(params.get("timedPush"));
            DashboardModel dashboardModel = this.getDashboardRuntimeDomain().loadDsbModel(publishId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dashboardModel);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("model", dashboardModel);
            result.put("operation", this.getCommonPublishDomain().loadSelfOperByPublishId(publishId, timedPush));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] squareLoadSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String publishId = params.get("dashboardUniqueId");
        ReferenceMap ref = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        try {
            ModelBook modelBook = this.getDashboardRuntimeDomain().loadSchema(publishId, ref);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("model", modelBook);
            Map publishOperMap = this.getCommonPublishDomain().loadPublishOperList(ref.getRefToId(), null, true, false);
            HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
            publishOperMapResult.put("operation", publishOperMap);
            publishOperMapResult.put("scene", "square");
            result.put("operation", publishOperMapResult);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] squareSaveSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String jsonModelBook = params.get("model");
        String publishId = params.get("dashboardUniqueId");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        ModelBook modelBook = ModelJsonDecoder.decode((String)jsonModelBook);
        try {
            this.getDashboardRuntimeDomain().saveSchema(publishId, referenceMap, modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] longerLoadSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String publishId = params.get("dashboardUniqueId");
        boolean timedPush = Boolean.parseBoolean(params.get("timedPush"));
        ReferenceMap ref = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        try {
            ModelBook modelBook = this.getDashboardRuntimeDomain().loadSchema(publishId, ref);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("model", modelBook);
            HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
            publishOperMapResult.put("operation", this.getCommonPublishDomain().loadPublishOperList(ref.getRefToId(), null, true, timedPush));
            publishOperMapResult.put("scene", "longer");
            result.put("operation", publishOperMapResult);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] longerSaveSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String jsonModelBook = params.get("model");
        String publishId = params.get("dashboardUniqueId");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        ModelBook modelBook = ModelJsonDecoder.decode((String)jsonModelBook);
        try {
            this.getDashboardRuntimeDomain().saveSchema(publishId, referenceMap, modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] squareResetSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String publishId = params.get("dashboardUniqueId");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        try {
            ModelBook modelBook = this.getDashboardRuntimeDomain().resetAndGetPubSchema(publishId, referenceMap);
            HashMap<String, ModelBook> result = new HashMap<String, ModelBook>();
            result.put("model", modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public final byte[] longerResetSchema(Map<String, String> params) {
        String jsonRef = params.get("ref");
        String publishId = params.get("dashboardUniqueId");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        try {
            ModelBook modelBook = this.getDashboardRuntimeDomain().resetAndGetPubSchema(publishId, referenceMap);
            HashMap<String, ModelBook> result = new HashMap<String, ModelBook>();
            result.put("model", modelBook);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getPublishDsbRefInfo(Map<String, String> params) {
        String publishId = params.get("publishId");
        String jsonRef = params.get("ref");
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        try {
            Map<String, String> result = this.getDashboardRuntimeDomain().getPublishDsbRefInfo(publishId, referenceMap);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getImageSize(Map<String, String> params) {
        String imageFileName = params.get("imageFileName");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getImageLibraryDomain().getImageSize(imageFileName));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getPublishUsername(Map<String, String> params) {
        String publishId = params.get("publishId");
        String publishUsername = null;
        try {
            PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(publishId);
            if (publishPO != null) {
                String originalCreatorId = publishPO.getCreatorId();
                publishUsername = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)originalCreatorId);
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(publishUsername);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

