/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.domain.CommonDsbDesignDomain;
import com.kingdee.bos.qing.dashboard.exception.DashboardEncryptedLicenseException;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.ModelBookTemporaryStorageException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.domain.DsbTimingPushDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class CommonTimedPushDsbDesignDomain
extends CommonDsbDesignDomain {
    private DsbTimingPushDao dsbTimingPushDao;
    private DsbTimingPushDomain dsbTimingPushDomain;

    public CommonTimedPushDsbDesignDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private DsbTimingPushDao getDsbTimingPushDao() {
        if (this.dsbTimingPushDao == null) {
            this.dsbTimingPushDao = new DsbTimingPushDao(this.dbExcuter);
        }
        return this.dsbTimingPushDao;
    }

    private DsbTimingPushDomain getDsbTimingPushDomain() {
        if (this.dsbTimingPushDomain == null) {
            this.dsbTimingPushDomain = new DsbTimingPushDomain(this.dbExcuter, this.qingContext, this.tx);
        }
        return this.dsbTimingPushDomain;
    }

    public DashboardModel loadDashboardModelForEdit(String configId, int sourceType) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, EncryptedLicenseCheckException {
        DashboardModel dashboardModel = this.getDsbTimingPushDao().loadDsbModel(configId, sourceType);
        List<ReferenceMap> refItems = this.getDsbTimingPushDao().getRefListForEditDsb(configId, sourceType);
        for (int i = 0; i < refItems.size(); ++i) {
            IRefHandler refHandler;
            String widgetSourcePath;
            ReferenceMap refItem = refItems.get(i);
            String refType = refItem.getRefType();
            if (!StringUtils.isBlank((CharSequence)((CharSequence)refItem.get((Object)"widgetSourcePath"))) || (widgetSourcePath = (refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refType))).loadRefFullPath(refItem, this.qingContext.getUserId())) == null) continue;
            refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
        }
        dashboardModel.fixReferences(refItems);
        return dashboardModel;
    }

    public void saveTimedPushDsbModel(String configId, DashboardModel dsbModel, int publishToType) throws DashboardException, AbstractQingIntegratedException, SQLException {
        List refItems = dsbModel.pickReferences();
        List<ReferenceMap> oldRefItems = this.getDsbTimingPushDomain().getRefList(configId, publishToType);
        try {
            this.getDsbTimingPushDomain().updateDsbModelContent(configId, publishToType, dsbModel);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
        for (ReferenceMap refItem : refItems) {
            IRefHandler refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refItem.getRefType()));
            if (!(refHandler instanceof ITimingPushable)) continue;
            ((ITimingPushable)((Object)refHandler)).updateTimingPushReference(configId, publishToType, refItem);
        }
        this.clearInvalidReference(configId, refItems, oldRefItems, publishToType);
    }

    public ModelBook loadSchema(String configId, ReferenceMap referenceMap, String editSchema, int publishToType) throws AbstractQingIntegratedException, DashboardException {
        String uid = referenceMap.getUid();
        String fileKey = referenceMap.getFileKey();
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(fileKey);
        ModelBook modelBook = null;
        List<OutsideReference> outsideRef = null;
        try {
            if (dashboardCache.exists()) {
                modelBook = dashboardCache.toModelBook();
                outsideRef = DashboardModelUtil.getOuterRefList(referenceMap);
            } else {
                byte[] schemaContent = this.getDsbTimingPushDomain().loadRefContent(configId, uid, publishToType);
                if (referenceMap.get((Object)"id") == null) {
                    String fid = this.getDsbTimingPushDomain().loadRefInfoPkId(configId, uid, publishToType);
                    referenceMap.put((Object)"id", (Object)fid);
                }
                outsideRef = this.getDsbTimingPushDomain().loadSchemaRef((String)referenceMap.get((Object)"id"), publishToType);
                if (schemaContent != null) {
                    modelBook = DashboardModelUtil.byteToSchemaModel(schemaContent);
                    if ("1".equals(editSchema)) {
                        dashboardCache.setValue(schemaContent);
                        try {
                            dashboardCache.save();
                            if (outsideRef != null) {
                                DashboardModelUtil.cacheOuterRef(referenceMap, outsideRef);
                            }
                        }
                        catch (IOException e) {
                            throw new ModelBookTemporaryStorageException(e);
                        }
                    }
                }
            }
            if (modelBook != null && outsideRef != null && outsideRef.size() > 0) {
                this.fixOutSideRefName(outsideRef);
                modelBook.fixReferences(outsideRef);
            }
            return modelBook;
        }
        catch (PersistentModelTooModernException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
    }

    private void clearInvalidReference(String configId, List<ReferenceMap> refItems, List<ReferenceMap> oldRefItems, int publishToType) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < oldRefItems.size(); ++i) {
            RefTypeEnum refType;
            IRefHandler refHandler;
            boolean isDelete = true;
            ReferenceMap oldRefItem = oldRefItems.get(i);
            for (int j = 0; j < refItems.size(); ++j) {
                String uid = refItems.get(j).getUid();
                if (!uid.equals(oldRefItem.getUid())) continue;
                isDelete = false;
                break;
            }
            if (!isDelete || !((refHandler = this.getRefHandler(refType = RefTypeEnum.valueOf((String)oldRefItem.getRefType()))) instanceof ITimingPushable)) continue;
            ((ITimingPushable)((Object)refHandler)).deleteTimingPushReference(configId, oldRefItem, publishToType);
        }
    }
}

