/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.IResourceLock;
import com.kingdee.bos.qing.common.lock.ResourceLockFactory;
import com.kingdee.bos.qing.common.lock.model.ResourceLockResult;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.domain.CommonDsbDesignDomain;
import com.kingdee.bos.qing.dashboard.exception.DashboardEncryptedLicenseException;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.ModelBookTemporaryStorageException;
import com.kingdee.bos.qing.dashboard.exception.NotSelectMapException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.oplog.DashboardOpLog;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.domain.impl.DashboardManageDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.ExtReportSchemaManageDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.subject.exception.SubjectNotFoundException;
import com.kingdee.bos.qing.subject.exception.SubjectNotOwnException;
import com.kingdee.bos.qing.util.OpLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class DashboardDesignDomain
extends DashboardManageDomain {
    public static final String FILE_KEY_STR = "fileKey";
    public static final String OUTER_KEY_STR = "outer";
    private SchemaManageDao SchemaManageDao;
    private ExtReportSchemaManageDao extRptSchemaManageDao;
    private PublishInfoDao publishInfoDao;
    private ThemeDomain themeDomain;
    private MapManageDao mapManageDao;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private CommonDsbDesignDomain commonDsbDesignDomain;

    public DashboardDesignDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    public DashboardDesignDomain() {
    }

    @Override
    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    protected SchemaManageDao getSchemaManageDao() {
        if (this.SchemaManageDao == null) {
            this.SchemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.SchemaManageDao;
    }

    private ExtReportSchemaManageDao getExtRptSchemaManageDao() {
        if (this.extRptSchemaManageDao == null) {
            this.extRptSchemaManageDao = new ExtReportSchemaManageDao(this.dbExcuter);
        }
        return this.extRptSchemaManageDao;
    }

    @Override
    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
        }
        return this.themeDomain;
    }

    public IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new EnumMap<RefTypeEnum, IRefHandler>(RefTypeEnum.class);
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    private CommonDsbDesignDomain getCommonDsbDesignDomain() {
        if (this.commonDsbDesignDomain == null) {
            this.commonDsbDesignDomain = new CommonDsbDesignDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.commonDsbDesignDomain;
    }

    public DashboardModel loadModelForDesign(String dsbId) throws AbstractQingIntegratedException, DashboardException {
        try {
            return this.loadModel(dsbId);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (ThemeManagementException e) {
            if (e instanceof EncryptedLicenseCheckException) {
                throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
            }
            throw new DashboardException((Throwable)((Object)e));
        }
    }

    public void saveDsbAndReferences(String dsbId, DashboardModel model) throws AbstractQingIntegratedException, DashboardException, SubjectNotFoundException, SubjectNotOwnException {
        ThemePO themePO = null;
        try {
            themePO = this.getThemeDomain().checkAndReturnOwnTheme(dsbId);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        try {
            this.tx.beginRequired();
            List<ReferenceMap> oldRefItems = this.getDashboardDao().getRefList(dsbId);
            List<ReferenceMap> refItems = new ArrayList();
            refItems = model.pickReferences();
            this.getDashboardDao().saveDsbContent(dsbId, model, null);
            this.getThemeDao().updateModifyDate(dsbId, this.qingContext.getUserId());
            for (ReferenceMap refItem : refItems) {
                RefTypeEnum refType = RefTypeEnum.valueOf((String)refItem.getRefType());
                IRefHandler refHandler = this.getRefHandler(refType);
                refHandler.saveOrUpdateReference(dsbId, refItem);
            }
            this.clearInvalidReference(dsbId, refItems, oldRefItems);
        }
        catch (DashboardException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new DashboardException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new DashboardException((Throwable)e);
        }
        finally {
            this.tx.end();
        }
        this.addOpLog(themePO);
    }

    private void addOpLog(ThemePO themePO) {
        try {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(themePO.getThemeName());
            ThemeGroupVO groupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(themePO.getUserID(), themePO.getGroupID());
            if (groupVO != null) {
                params.add(groupVO.getThemeGroupName());
            }
            DashboardOpLog qingAnalysisGroupDir = DashboardOpLog.QING_ANALYSIS_GROUP_DIR;
            qingAnalysisGroupDir.setLogScene("\u4eea\u8868\u677f");
            qingAnalysisGroupDir.setParamsDesc("\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)qingAnalysisGroupDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void syncToDsbAndReferences(String dsbId, DashboardModel model, String executionDsbId, int type) throws AbstractQingIntegratedException, DashboardException {
        ArrayList<AbstractThemeManageDomain.IFileRollback> rollbackCollector = new ArrayList<AbstractThemeManageDomain.IFileRollback>();
        try {
            this.tx.beginRequired();
            List<ReferenceMap> oldRefItems = this.getDashboardDao().getRefList(dsbId);
            List refItems = model.pickReferences();
            this.getDashboardDao().saveDsbContent(dsbId, model, null);
            this.getThemeDao().updateModifyDate(dsbId, this.qingContext.getUserId());
            for (ReferenceMap refItem : refItems) {
                RefTypeEnum refType = RefTypeEnum.valueOf((String)refItem.getRefType());
                IRefHandler refHandler = this.getRefHandler(refType);
                String dsbWidgetId = refItem.getUid();
                this.getDashboardDao().deleteDsbRef(dsbId, dsbWidgetId);
                refHandler.copyExecutionReference(executionDsbId, dsbId, refItem, rollbackCollector, type);
            }
            this.clearInvalidReference(dsbId, refItems, oldRefItems);
        }
        catch (DashboardException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new DashboardException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new DashboardException((Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    public void saveDsbAndReferencesWithoutTx(String dsbId, DashboardModel model, InputStream dsbOrignalStream) throws AbstractQingIntegratedException, DashboardException, SubjectNotFoundException, SubjectNotOwnException {
        try {
            this.getThemeDomain().checkAndReturnOwnTheme(dsbId);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        try {
            List<ReferenceMap> oldRefItems = this.getDashboardDao().getRefList(dsbId);
            List<ReferenceMap> refItems = new ArrayList();
            refItems = model.pickReferences();
            this.getDashboardDao().saveDsbContent(dsbId, model, dsbOrignalStream);
            for (ReferenceMap refItem : refItems) {
                RefTypeEnum refType = RefTypeEnum.valueOf((String)refItem.getRefType());
                IRefHandler refHandler = this.getRefHandler(refType);
                refHandler.saveOrUpdateReference(dsbId, refItem);
            }
            this.clearInvalidReference(dsbId, refItems, oldRefItems);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
        catch (DashboardException e) {
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (Exception e) {
            throw new DashboardException((Throwable)e);
        }
    }

    private void clearInvalidReference(String dsbId, List<ReferenceMap> newReferebceList, List<ReferenceMap> oldReferenceList) throws AbstractQingIntegratedException, SQLException, ModelBookTemporaryStorageException {
        for (int i = 0; i < oldReferenceList.size(); ++i) {
            boolean isDelete = true;
            ReferenceMap refItem = oldReferenceList.get(i);
            for (int j = 0; j < newReferebceList.size(); ++j) {
                String uid = newReferebceList.get(j).getUid();
                if (!uid.equals(refItem.getUid())) continue;
                isDelete = false;
                break;
            }
            if (!isDelete) continue;
            if (RefTypeEnum.valueOf((String)refItem.getRefType()) != RefTypeEnum.picture) {
                try {
                    DashboardModelBookCache dashboardCache = new DashboardModelBookCache(dsbId + refItem.getUid() + FILE_KEY_STR);
                    byte[] schemaContent = this.getDashboardDao().loadShemaContent(refItem.getUid(), dsbId);
                    List<OutsideReference> outsideRef = this.getDashboardDao().loadSchemaRef((String)refItem.get((Object)"id"));
                    if (null != schemaContent) {
                        dashboardCache.setValue(schemaContent);
                        dashboardCache.save();
                    }
                    if (outsideRef != null && outsideRef.size() > 0) {
                        refItem.put((Object)"outerRefKey", (Object)(dsbId + refItem.getUid() + OUTER_KEY_STR));
                        DashboardModelUtil.cacheOuterRef(refItem, outsideRef);
                    }
                }
                catch (IOException e) {
                    throw new ModelBookTemporaryStorageException(e);
                }
            }
            RefTypeEnum refType = RefTypeEnum.valueOf((String)refItem.getRefType());
            IRefHandler refHandler = this.getRefHandler(refType);
            refHandler.deleteReference(dsbId, refItem);
            this.getDashboardDao().deleteOuterRef((String)refItem.get((Object)"id"));
        }
    }

    public ModelBook loadSchema(ReferenceMap referenceMap, String dsbId, String editSchema) throws AbstractQingIntegratedException, DashboardException {
        String uid = referenceMap.getUid();
        String fileKey = referenceMap.getFileKey();
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(fileKey);
        ModelBook modelBook = null;
        List<OutsideReference> outsideRef = null;
        try {
            if (dashboardCache.exists()) {
                modelBook = dashboardCache.toModelBook();
                outsideRef = DashboardModelUtil.getOuterRefList(referenceMap);
            } else {
                byte[] schemaContent = this.getDashboardDao().loadShemaContent(uid, dsbId);
                if (referenceMap.get((Object)"id") == null) {
                    ReferenceMap newReferenceMap = this.getDashboardDao().loadRef(dsbId, uid);
                    referenceMap.put((Object)"id", newReferenceMap.get((Object)"id"));
                }
                outsideRef = this.getDashboardDao().loadSchemaRef((String)referenceMap.get((Object)"id"));
                if (schemaContent != null) {
                    modelBook = DashboardModelUtil.byteToSchemaModel(schemaContent);
                } else {
                    dashboardCache = new DashboardModelBookCache(dsbId + referenceMap.getUid() + FILE_KEY_STR);
                    if (dashboardCache.exists()) {
                        modelBook = dashboardCache.toModelBook();
                        referenceMap.put((Object)"outerRefKey", (Object)(dsbId + referenceMap.getUid() + OUTER_KEY_STR));
                        outsideRef = DashboardModelUtil.getOuterRefList(referenceMap);
                    }
                }
            }
            if (modelBook != null && outsideRef != null && outsideRef.size() > 0) {
                this.getCommonDsbDesignDomain().fixOutSideRefName(outsideRef);
                modelBook.fixReferences(outsideRef);
            }
            return modelBook;
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public void saveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException, NotSelectMapException {
        this.getCommonDsbDesignDomain().cacheSquareSchema(referenceMap, modelBook);
    }

    public void longerSaveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException {
        this.getCommonDsbDesignDomain().cacheLongerSchema(referenceMap, modelBook);
    }

    public byte[] loadShemaContent(String uid, String dsbId) throws AbstractQingIntegratedException, SQLException {
        return this.getDashboardDao().loadShemaContent(uid, dsbId);
    }

    public boolean tryAddResourceLock(String groupId, String resourceId) {
        IResourceLock resourceLock = ResourceLockFactory.createLock((String)groupId, (String)groupId, (boolean)true);
        ResourceLockResult lockResult = resourceLock.lock(resourceId);
        return lockResult.isSuccessed();
    }

    public void closeResourceLock(String groupId, String resourceId) {
        IResourceLock resourceLock = ResourceLockFactory.createLock((String)groupId, (String)groupId, (boolean)true);
        resourceLock.unlock(resourceId);
    }
}

