/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.domain;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.map.MapRefUpdater;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;

public class DashboardDesignTimeMapRefUpdater
implements MapRefUpdater {
    private static final String UPDATE_DSB_MAP_REFTOID_ERROR = "update dsb map RefToId error";
    private IDBExcuter dbExcuter;
    private DashboardDao dashboardDao;

    @Override
    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    @Override
    public void updateMapIdOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> dsbOutSideRefList = this.getDashboardDao().loadRefListByFullPathWidthoutUserId(fullPath, "Map");
            for (int i = 0; i < dsbOutSideRefList.size(); ++i) {
                String fId = dsbOutSideRefList.get(i);
                this.getDashboardDao().updateRefToIdByRefId(fId, mapId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)UPDATE_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)UPDATE_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
    }

    @Override
    public void updateMapFullPathOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> dsbOutSideRefList = this.getDashboardDao().loadRefListByRefToIdAndRefType(mapId, "Map");
            for (int i = 0; i < dsbOutSideRefList.size(); ++i) {
                String fId = dsbOutSideRefList.get(i);
                this.getDashboardDao().updateRefFullPathByRefId(fId, fullPath);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)UPDATE_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)UPDATE_DSB_MAP_REFTOID_ERROR, (Throwable)e);
        }
    }
}

