/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.domain.CommonTimedPushDsbDesignDomain;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.ModelBookTemporaryStorageException;
import com.kingdee.bos.qing.dashboard.exception.NotSelectMapException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.oplog.DashboardOpLog;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.domain.PublishSourceDomainFactory;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.email.dao.EmailConfigDao;
import com.kingdee.bos.qing.publish.target.email.exception.NotFoundEmailConfigException;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.OpLogUtil;
import java.sql.SQLException;
import java.util.ArrayList;

public class EmailPushDsbDesignDomain {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext context;
    private IScheduleEngine scheduleEngine;
    private EmailConfigDao emailConfigDao;
    private CommonTimedPushDsbDesignDomain commonDsbDesignDomain;

    public EmailPushDsbDesignDomain(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.context = context;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
        this.scheduleEngine = scheduleEngine;
    }

    private EmailConfigDao getEmailConfigDao() {
        if (this.emailConfigDao == null) {
            this.emailConfigDao = new EmailConfigDao(this.context, this.dbExcuter);
        }
        return this.emailConfigDao;
    }

    private CommonTimedPushDsbDesignDomain getCommonDsbDesignDomain() {
        if (this.commonDsbDesignDomain == null) {
            this.commonDsbDesignDomain = new CommonTimedPushDsbDesignDomain(this.context, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.commonDsbDesignDomain;
    }

    public void saveEmailPushDsbModel(String configId, DashboardModel dsbModel) throws DashboardException, AbstractQingIntegratedException, SQLException, NotFoundEmailConfigException {
        EmailConfig emailConfig;
        try {
            this.tx.beginRequired();
            emailConfig = this.getEmailConfigDao().getEmailConfigById(configId);
            if (emailConfig == null) {
                throw new NotFoundEmailConfigException();
            }
            this.getCommonDsbDesignDomain().saveTimedPushDsbModel(configId, dsbModel, 6);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        try {
            String sourceName = PublishSourceDomainFactory.getPublishSourceName((QingContext)this.context, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)emailConfig.getTagId(), (PublishSourceEnum)emailConfig.getPublishSourceType());
            String sourGroupName = PublishSourceDomainFactory.getPublishSourceGroupName((QingContext)this.context, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (String)emailConfig.getTagId(), (PublishSourceEnum)emailConfig.getPublishSourceType());
            if (sourceName != null && sourGroupName != null) {
                ArrayList<String> params = new ArrayList<String>(3);
                params.add(sourceName);
                params.add(sourGroupName);
                params.add(emailConfig.getNameRule().getName());
                DashboardOpLog dashboardOpLog = DashboardOpLog.QING_ANALYSIS_EMIAL_GROUP_DIR;
                dashboardOpLog.setLogScene("\u201c$param\u201d");
                dashboardOpLog.setLogScene("\u4eea\u8868\u677f");
                OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)dashboardOpLog, params));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DashboardModel loadEmailPushDsbDesignModel(String configId) throws PersistentModelParseException, AbstractQingIntegratedException, SQLException, EncryptedLicenseCheckException {
        return this.getCommonDsbDesignDomain().loadDashboardModelForEdit(configId, 6);
    }

    public ModelBook loadSchema(String configId, ReferenceMap referenceMap, String editSchema) throws AbstractQingIntegratedException, DashboardException {
        return this.getCommonDsbDesignDomain().loadSchema(configId, referenceMap, editSchema, 6);
    }

    public void saveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException, NotSelectMapException {
        this.getCommonDsbDesignDomain().cacheSquareSchema(referenceMap, modelBook);
    }

    public void longerSaveSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException {
        this.getCommonDsbDesignDomain().cacheLongerSchema(referenceMap, modelBook);
    }
}

