/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IPublishPrepareDataable;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.preparedata.exception.PublishedDsbRefCarryDataPrepareDataException;
import com.kingdee.bos.qing.publish.dao.PubDsbRefExtractDataExceptionLogDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefBillFileDao;
import com.kingdee.bos.qing.publish.model.PubDsbRefExtractDataExceptionLog;
import com.kingdee.bos.qing.publish.model.PublishDsbRefBillFile;
import com.kingdee.bos.qing.publish.model.PublishPO;
import java.sql.SQLException;

public abstract class AbstractPublishPrepareDataHandler
implements IPublishPrepareDataable {
    protected IDBExcuter dbExcuter;
    protected QingContext context;
    private PublishDsbRefBillFileDao PublishDsbRefBillFileDao;
    private PubDsbRefExtractDataExceptionLogDao pubDsbRefExtractDataExceptionLogDao;

    protected PublishDsbRefBillFileDao getPublishDsbRefBillFileDao() {
        if (this.PublishDsbRefBillFileDao == null) {
            this.PublishDsbRefBillFileDao = new PublishDsbRefBillFileDao(this.dbExcuter);
        }
        return this.PublishDsbRefBillFileDao;
    }

    protected PubDsbRefExtractDataExceptionLogDao getPubDsbRefExtractDataExceptionLogDao() {
        if (this.pubDsbRefExtractDataExceptionLogDao == null) {
            this.pubDsbRefExtractDataExceptionLogDao = new PubDsbRefExtractDataExceptionLogDao(this.dbExcuter);
        }
        return this.pubDsbRefExtractDataExceptionLogDao;
    }

    public IDBExcuter getDbExcuter() {
        return this.dbExcuter;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public QingContext getContext() {
        return this.context;
    }

    public void setContext(QingContext context) {
        this.context = context;
    }

    @Override
    public String getPublishPrepareDataTag(String tag, String publishId, String tagId) throws AbstractQingIntegratedException, SQLException {
        return null;
    }

    public void createPublishedCarryDataDataBillSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws AbstractQingIntegratedException, SQLException, PublishedDsbRefCarryDataPrepareDataException {
        SingleFileDataSource dataSource;
        String refUid = referenceMap.getUid();
        PublishDsbRefBillFile billFileModel = this.getPublishDsbRefBillFileDao().loadBillFile(publishPO.getId(), refUid);
        if (billFileModel != null) {
            dataSource = new SingleFileDataSource(billFileModel.getQsFileName(), (AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS);
            dataSource.setTag(tag);
            dataSource.setOriginalCreatorId(publishPO.getCreatorId());
            dataSource.setLastVisitTime(System.currentTimeMillis());
            if (billFileModel.getExtractDataTime() != null) {
                dataSource.setExtractDataTime(billFileModel.getExtractDataTime().getTime());
            }
        } else {
            PubDsbRefExtractDataExceptionLog exceptionLog = this.getPubDsbRefExtractDataExceptionLogDao().selectExceptionLog(publishPO.getId(), refUid);
            throw new PublishedDsbRefCarryDataPrepareDataException(exceptionLog.getErrorCode(), exceptionLog.getErrorMessage(), exceptionLog.getErrorStackTrace());
        }
        QingSessionUtil.setCache((ISessionCacheable)dataSource);
    }

    @Override
    public String getQHFPublishUniqueRefId(PublishPO publishPO, PackageMeta packageMeta) {
        return null;
    }
}

