/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference;

import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.AbstractPublishPrepareDataHandler;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRefHandler
extends AbstractPublishPrepareDataHandler
implements IRefHandler {
    protected ITransactionManagement tx;
    private DashboardDao dashboardDao;
    protected RefTypeEnum refType;
    private DashboardPublishDao dashboardPublishDao;
    private IThemeDao iThemeDao;
    private ThemeDomain themeDomain;
    private IThemeGroupDao iThemeGroupDao;
    private DsbTimingPushDao dsbTimingPushDao;

    public ITransactionManagement getTx() {
        return this.tx;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    protected void setRefType(RefTypeEnum refType) {
        this.refType = refType;
    }

    protected DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    protected DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    protected IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.context, this.dbExcuter);
        }
        return this.themeDomain;
    }

    protected IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    protected DsbTimingPushDao getDsbTimingPushDao() {
        if (this.dsbTimingPushDao == null) {
            this.dsbTimingPushDao = new DsbTimingPushDao(this.dbExcuter);
        }
        return this.dsbTimingPushDao;
    }

    @Override
    public Map<String, Object> createReference(Map<String, String> params) throws AbstractQingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String refToId = params.get("refToId");
        ReferenceMap ref = this.createRefMap(refToId);
        result.put("ref", ref);
        this.addRefContent(params, result);
        try {
            String widgetSourcePath = this.loadRefFullPath(ref, this.context.getUserId());
            ref.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
        }
        catch (SQLException e) {
            LogUtil.error((String)"load widget source path error", (Throwable)e);
        }
        return result;
    }

    public abstract ReferenceMap createRefMap(String var1) throws AbstractQingException;

    public abstract void addRefContent(Map<String, String> var1, Map<String, Object> var2) throws AbstractQingException;
}

