/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import java.sql.SQLException;
import java.util.List;

public class TimingPushDSBUpdateRefPathAndIdHandler
implements AbstractSwitchPathAndIdHandler.IUpdateRefPathAndIdHandler {
    private QingContext context;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private DsbTimingPushDao dsbTimingPushDao;

    public TimingPushDSBUpdateRefPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.context = context;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    private DsbTimingPushDao getDsbTimingPushDao() {
        if (this.dsbTimingPushDao == null) {
            this.dsbTimingPushDao = new DsbTimingPushDao(this.dbExcuter);
        }
        return this.dsbTimingPushDao;
    }

    public void updateRefIdToPath(RefTypeEnum refType, String refPath, String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        String refTypeCondition = refType.name() + "%";
        List<ReferenceMap> timingPushRefInfo = this.getDsbTimingPushDao().loadRefListByRefToId(refToId, refTypeCondition, userId);
        for (int i = 0; i < timingPushRefInfo.size(); ++i) {
            ReferenceMap ref = timingPushRefInfo.get(i);
            ref.setRefToId(" ");
            ref.setRefToFullPath(refPath);
            this.getDsbTimingPushDao().updateRef(ref);
        }
        List<ReferenceMap> robotTimingPushRef = this.getDsbTimingPushDao().loadRobotPushRefListByRefToId(refToId, refType.name(), userId);
        for (int i = 0; i < robotTimingPushRef.size(); ++i) {
            ReferenceMap ref = robotTimingPushRef.get(i);
            ref.setRefToId(" ");
            ref.setRefToFullPath(refPath);
            this.getDsbTimingPushDao().updateRef(ref);
        }
    }

    public void updateRefPathToId(RefTypeEnum refType, String refPath, String refId, String userId) throws AbstractQingIntegratedException, SQLException {
        String refTypeCondition = refType.name() + "%";
        List<ReferenceMap> emailTimingPushRefInfo = this.getDsbTimingPushDao().loadRefListByFullPath(refPath, refTypeCondition, userId);
        for (ReferenceMap ref : emailTimingPushRefInfo) {
            ref.setRefToId(refId);
            ref.setRefToFullPath(null);
            this.getDsbTimingPushDao().updateRef(ref);
        }
        List<ReferenceMap> robotTimingPushRefInfo = this.getDsbTimingPushDao().loadRobotPushRefListByFullPath(refPath, refType.name(), userId);
        for (ReferenceMap ref : robotTimingPushRefInfo) {
            ref.setRefToId(refId);
            ref.setRefToFullPath(null);
            this.getDsbTimingPushDao().updateRef(ref);
        }
    }
}

