/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.ISecondPublishable;
import com.kingdee.bos.qing.dashboard.reference.impl.CardSwitchPathAndIdHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.QingRefHandler;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.card.dao.PublishCardDao;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupPO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.SQLException;
import java.util.Map;

class CardHandler
extends QingRefHandler
implements ISecondPublishable {
    private PublishInfoDao publishInfoDao;
    private PublishCardDao publishCardDao;
    private SubjectManageDomain subjectManageDomain;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;
    private static final String SCHEMA_CACHE_SUFFIX = "_card";

    public CardHandler() {
        super(RefTypeEnum.card);
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private PublishCardDao getPublishCardDao() {
        if (this.publishCardDao == null) {
            this.publishCardDao = new PublishCardDao(this.context, this.dbExcuter);
        }
        return this.publishCardDao;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.context, null, this.dbExcuter, null);
        }
        return this.subjectManageDomain;
    }

    @Override
    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new CardSwitchPathAndIdHandler(this.context, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    @Override
    public void collectSecondPublishInfo(ReferenceMap referenceMap, Map<String, String> collector) throws AbstractQingIntegratedException, SQLException {
        PublishPO cardpublishPO = this.getPublishInfoDao().getPublishInfoByInfoId(referenceMap.getRefToId());
        collector.put("publishId", referenceMap.getRefToId());
        if (cardpublishPO != null) {
            collector.put("haveToCarryData", cardpublishPO.isCarryData() + "");
            String publishSourceType = cardpublishPO.getPublishSourceType().name();
            String bizTag = cardpublishPO.getTagId();
            collector.put("publishSourceType", publishSourceType);
            collector.put("bizTag", bizTag);
            if (PublishSourceEnum.subject == cardpublishPO.getPublishSourceType()) {
                collector.put("themeId", bizTag);
                ThemePO themePO = this.getThemeDao().getThemeByID(cardpublishPO.getTagId());
                if (themePO != null) {
                    String themeName = themePO.getThemeName();
                    collector.put("themeName", themeName);
                }
            }
        }
    }

    protected String getSchemaCacheSuffix() {
        return SCHEMA_CACHE_SUFFIX;
    }

    @Override
    public String loadRefFullPath(ReferenceMap refItem, String userId) throws AbstractQingIntegratedException, SQLException {
        String refToId = refItem.getRefToId();
        PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(refToId);
        if (publishPO != null) {
            CardGroupPO cardGroupPO;
            String publishName = publishPO.getName();
            String cardGroupId = publishPO.getPath();
            String ownerId = publishPO.getCreatorId();
            if (!userId.equals(ownerId)) {
                String ownerName = IntegratedHelper.getUserName((QingContext)this.context, (IDBExcuter)this.dbExcuter, (String)ownerId);
                refItem.put((Object)"ownerName", (Object)ownerName);
                refItem.put((Object)"publishName", (Object)publishName);
            }
            if ((cardGroupPO = this.getPublishCardDao().loadGroupByIdForExport(cardGroupId)) != null) {
                return cardGroupPO.getName() + "/" + publishName;
            }
        }
        return null;
    }
}

