/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.AbstractRefHandler;
import com.kingdee.bos.qing.dashboard.reference.ExtreportAppSwitchPathAndIdHandler;
import com.kingdee.bos.qing.dashboard.reference.IExImportPublishable;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PublishedPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelParseException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.schema.dao.ExtReportSchemaManageDao;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipOutputStream;

public class ExtreportAppHandler
extends AbstractRefHandler
implements IExImportable,
IPublishable,
IExImportPublishable,
ITimingPushable,
IPrepareDataable {
    protected String fileKey;
    protected String outerRefKey;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;
    private ExtReportSchemaManageDao extReportSchemaManageDao;
    private final String SCHEME_SPLIT_SIGN = "/";

    public ExtreportAppHandler() {
        this.setRefType(RefTypeEnum.qingreport);
    }

    public ExtreportAppHandler(RefTypeEnum refTypeEnum) {
        this.setRefType(refTypeEnum);
    }

    @Override
    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new ExtreportAppSwitchPathAndIdHandler(this.context, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    protected ExtReportSchemaManageDao getExtRptSchemaManageDao() {
        if (this.extReportSchemaManageDao == null) {
            this.extReportSchemaManageDao = new ExtReportSchemaManageDao(this.dbExcuter);
        }
        return this.extReportSchemaManageDao;
    }

    @Override
    public void addRefContent(Map<String, String> params, Map<String, Object> result) throws AbstractQingException {
    }

    @Override
    public ReferenceMap createRefMap(String refToId) {
        ReferenceMap refMap = new ReferenceMap();
        String uid = UUID.randomUUID().toString();
        refMap.setUid(uid);
        refMap.setRefToId(refToId);
        refMap.setRefType(this.refType.name());
        this.fileKey = UUID.randomUUID().toString();
        this.outerRefKey = UUID.randomUUID().toString();
        refMap.setFileKey(this.fileKey);
        refMap.put((Object)"outerRefKey", (Object)this.outerRefKey);
        return refMap;
    }

    @Override
    public void saveOrUpdateReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        String dsbWidgetId = refMap.getUid();
        this.getDashboardDao().deleteDsbRef(dsbId, dsbWidgetId);
        this.getDashboardDao().saveRefInfo(refMap, dsbId);
    }

    @Override
    public void updatePublishedRef(String publishId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException, DashboardException {
        String dsbWidgetId = refMap.getUid();
        this.getDashboardPublishDao().deleteRefAndContent(publishId, dsbWidgetId);
        this.getDashboardPublishDao().saveRefInfo(refMap, publishId);
    }

    @Override
    public void copyReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().saveRefInfo(refMap, toDsbId);
    }

    @Override
    public void copyExecutionReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector, int type) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().saveRefInfo(refMap, toDsbId);
    }

    @Override
    public void deleteReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().deleteDsbRef(dsbId, refMap.getUid());
        this.deleteExtReportSchemeInfo(dsbId + "/" + refMap.getUid());
    }

    @Override
    public void deletePublishedRef(String publishId, String refUid, String refToId) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardPublishDao().deleteRefAndContent(publishId, refUid);
        this.deleteExtReportSchemeInfo(publishId + "/" + refUid);
    }

    @Override
    public void exportRefContent(String dsbId, String dsbFolderPath, boolean isPreset, ReferenceMap referenceMap, ZipOutputStream zos) throws IOException, AbstractQingIntegratedException, SQLException, QingImglibException {
    }

    @Override
    public void exportPublishedRefContent(String publishId, String folderPath, ReferenceMap refMap, IDashboardExportFilePathGetter dashboardExportFilePathGetter, ZipOutputStream zos) throws QingImglibException, AbstractQingIntegratedException, IOException {
    }

    @Override
    public void importRefContent(String dsbId, DashboardImportModel dsbImportModel, List<IQingFile> successImportFile) throws QingImglibException, AbstractQingIntegratedException, SQLException, IOException {
    }

    @Override
    public List<ReferenceMap> importPublishedRefContent(String publishId, DashboardImportModel dsbImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> successImportFile) throws ImportThemeException, AbstractQingIntegratedException {
        ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>();
        return refItems;
    }

    @Override
    public void deletePublishContent(String publishId) throws AbstractQingIntegratedException, SQLException {
    }

    @Override
    public void savePublishReference(String dsbId, String publishId, ReferenceMap refMap, ModelBook modelBook) throws PersistentModelParseException, PersistentModelTooModernException, SQLException, AbstractQingIntegratedException {
        this.getDashboardPublishDao().saveRefInfo(refMap, publishId);
    }

    @Override
    public void saveTimingPushReference(String dashboardUniqueId, String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException {
        this.getDsbTimingPushDao().saveRefInfo(sourceId, sourceType, refItem);
    }

    @Override
    public void updateTimingPushReference(String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException {
        String refUid = refItem.getUid();
        this.getDsbTimingPushDao().deleteRefAndContent(sourceId, refUid, sourceType);
        this.getDsbTimingPushDao().saveRefInfo(sourceId, sourceType, refItem);
    }

    @Override
    public void deleteTimingPushReference(String sourceId, ReferenceMap refMap, int sourceType) throws AbstractQingIntegratedException, SQLException {
        this.getDsbTimingPushDao().deleteRefAndContent(sourceId, refMap.getUid(), sourceType);
        this.deleteExtReportSchemeInfo(sourceId + "/" + refMap.getUid());
    }

    @Override
    public void createPublishedCarryDataDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws SubjectModelParseException, PublishedPrepareDataException, ModelParseException, AbstractQingIntegratedException, SQLException, IOException {
    }

    @Override
    public String loadRefFullPath(ReferenceMap refItem, String userId) throws AbstractQingIntegratedException, SQLException {
        String fullPath = null;
        String refToId = refItem.getRefToId();
        Map<String, String> pathMap = this.getExtRptSchemaManageDao().loadExtreportPathById(refToId);
        if (null != pathMap.get("groupName")) {
            fullPath = pathMap.get("groupName") + "/" + pathMap.get("extreportName");
        }
        return fullPath;
    }

    @Override
    public void separateImportModel(DashboardPublishImportModel dsbPublishImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
    }

    @Override
    public void separateImportModel(DashboardImportModel dsbImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
    }

    @Override
    public void exportSource(String refTag, ReferenceMap referenceMap, PackageMeta meta) throws AbstractQingException, SQLException, IOException {
    }

    @Override
    public void cacheQHFDataSource(String refTag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
    }

    @Override
    public AbstractDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) {
        return null;
    }

    @Override
    public String getPrepareDataTag(String tag, String refToId) throws AbstractQingIntegratedException, SQLException {
        return null;
    }

    @Override
    public IPrepareDataContext getDataPrepareContext(String tag, String refToId, boolean isStartBySchedule, boolean isFirstFromCache, ProgressModel progressModel) {
        return null;
    }

    @Override
    public AbstractPrepareDataHandler getDataPrepareHandler(IPrepareDataContext prepareDataContext) {
        return null;
    }

    @Override
    public String getQHFUniqueRefId(String refToId, PackageMeta packageMeta) {
        return null;
    }

    private void deleteExtReportSchemeInfo(String extReportSchemeId) throws AbstractQingIntegratedException, SQLException {
        this.getExtRptSchemaManageDao().clearExtRptSchemaInfos(extReportSchemeId);
    }
}

