/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.imagelibrary.dao.ImageLibraryDao;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import java.sql.SQLException;

public class PictureSwitchPathAndIdHandler
extends AbstractSwitchPathAndIdHandler {
    private ImageLibraryDao imageLibraryDao;

    public PictureSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        super(context, tx, dbExcuter);
    }

    private ImageLibraryDao getImageLibraryDao() {
        if (this.imageLibraryDao == null) {
            this.imageLibraryDao = new ImageLibraryDao(this.dbExcuter);
        }
        return this.imageLibraryDao;
    }

    public String switchRefPathToId(String refPath, String name, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = this.getImageLibraryDao().getCategoryIdByName(refPath, userId);
        return this.getImageLibraryDao().getImageFileName(categoryId, name, userId);
    }

    public String switchRefIdToPath(String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryName = this.getImageLibraryDao().getCategoryName(refToId);
        ImageModel imageModel = this.getImageLibraryDao().loadImageModel(refToId);
        if (categoryName != null && imageModel != null) {
            String nameSpace = imageModel.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            PathModel pathModel = new PathModel();
            pathModel.setNameSpace(nameSpace);
            pathModel.setGroupName(categoryName);
            pathModel.setName(imageModel.getImageName());
            return JsonUtil.encodeToString((Object)pathModel);
        }
        return null;
    }

    public void replacePersistentPathToId(String refPath, String refId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefPathToId(RefTypeEnum.picture, refPath, refId, userId);
    }

    public void replacePersistentIdToPath(String refPath, String refToId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefIdToPath(RefTypeEnum.picture, refPath, refToId, userId);
    }

    public boolean RefIsPreset(String refToId) throws AbstractQingIntegratedException, SQLException {
        ImageModel imageModel = this.getImageLibraryDao().getImageModelByImageFileName(refToId);
        if (imageModel != null) {
            return imageModel.isPreset();
        }
        return false;
    }

    public String switchRefPathToId(String fullPath, String userId) throws AbstractQingIntegratedException, SQLException {
        PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)fullPath, PathModel.class);
        if (NameSpace.system.toPersistance().equals(pathModel.getNameSpaceWithSign()) && IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter)) {
            userId = IntegratedHelper.getPresetUserId();
        }
        String categoryId = this.getImageLibraryDao().getCategoryIdByName(pathModel.getGroupName(), userId);
        return this.getImageLibraryDao().getImageFileName(categoryId, pathModel.getName(), userId);
    }

    public String createEmptyPath() {
        return null;
    }
}

