/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.ModelBookTemporaryStorageException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.AbstractPublishPrepareDataHandler;
import com.kingdee.bos.qing.dashboard.reference.AbstractRefHandler;
import com.kingdee.bos.qing.dashboard.reference.IExImportPublishable;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.dashboard.reference.impl.RefPublishPrepareDataHandlerFactory;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishLongerSquareQHFExporter;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.impl.PublishModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PublishedDsbRefPublishNotExistPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishPrepareDataContext;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishedPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.FromType;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.dsbtimingpush.dao.DsbTimingPushDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class QingRefHandler
extends AbstractRefHandler
implements IExImportable,
IPublishable,
IExImportPublishable,
ITimingPushable,
IPrepareDataable {
    protected String fileKey;
    protected String outerRefKey;
    private SchemaManageDao SchemaManageDao;
    private PublishInfoDao publishInfoDao;
    private ISubjectDao iSubjectDao;
    private static final String CACHED_DSBID_SUFFIX = "dsb";
    private static final String CACHED_PUBLISHID_SUFFIX = "publishDsb";
    protected CommonPublishDomain commonPublishDomain;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;

    public QingRefHandler(RefTypeEnum refTypeEnum) {
        this.setRefType(refTypeEnum);
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.SchemaManageDao == null) {
            this.SchemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.SchemaManageDao;
    }

    protected CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new EnumMap<RefTypeEnum, IRefHandler>(RefTypeEnum.class);
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.context, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    private ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    public void setRefTypeEnum(RefTypeEnum refType) {
        this.setRefType(refType);
    }

    @Override
    public void addRefContent(Map<String, String> params, Map<String, Object> result) throws AbstractQingException {
        String publishId = params.get("refToId");
        String schemaId = params.get("schemaId");
        boolean validDataSource = true;
        try {
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
            if (publishPO != null && PublishSourceEnum.subject == publishPO.getPublishSourceType()) {
                ThemePO themePO = this.getThemeDomain().getThemeByID(publishPO.getTagId());
                if (themePO != null) {
                    Box box = this.getSubjectDao().loadSubjectModelIncludePreset(themePO.getUserID(), publishPO.getTagId());
                    if (box == null || box.getEntities().isEmpty()) {
                        result.put("noModeling", Boolean.TRUE);
                        validDataSource = false;
                    }
                } else {
                    result.put("noTheme", Boolean.TRUE);
                    validDataSource = false;
                }
            }
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        if (validDataSource) {
            ModelBook modelBook = this.copySchemaToCache(schemaId);
            result.put("model", modelBook);
        }
    }

    @Override
    public ReferenceMap createRefMap(String refToId) {
        ReferenceMap refMap = new ReferenceMap();
        String uid = UUID.randomUUID().toString();
        refMap.setUid(uid);
        refMap.setRefToId(refToId);
        refMap.setRefType(this.refType.name());
        this.fileKey = UUID.randomUUID().toString();
        this.outerRefKey = UUID.randomUUID().toString();
        refMap.setFileKey(this.fileKey);
        refMap.put((Object)"outerRefKey", (Object)this.outerRefKey);
        return refMap;
    }

    @Override
    public void saveOrUpdateReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException, DashboardException {
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(refMap.getFileKey());
        if (!dashboardCache.exists() && !(dashboardCache = new DashboardModelBookCache(dsbId + refMap.getUid() + "fileKey")).exists()) {
            return;
        }
        String dsbWidgetId = refMap.getUid();
        this.getDashboardDao().deleteDsbRef(dsbId, dsbWidgetId);
        this.getDashboardDao().saveRefInfo(refMap, dsbId);
        try {
            List<OutsideReference> outsideRef = DashboardModelUtil.getOuterRefList(refMap);
            if (outsideRef != null && outsideRef.size() == 0) {
                refMap.put((Object)"outerRefKey", (Object)(dsbId + refMap.getUid() + "outer"));
                outsideRef = DashboardModelUtil.getOuterRefList(refMap);
            }
            this.saveOuterRef(outsideRef, refMap);
            this.getDashboardDao().saveRefSource(refMap, dashboardCache.toModelBook(), dsbId);
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
    }

    @Override
    public void updatePublishedRef(String publishId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException, DashboardException {
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(refMap.getFileKey());
        if (!dashboardCache.exists()) {
            return;
        }
        String refUid = refMap.getUid();
        try {
            String refFid = this.getDashboardPublishDao().getRefPK(publishId, refUid);
            this.getDashboardPublishDao().deleteOuterRef(refFid);
            List<OutsideReference> outsideRef = DashboardModelUtil.getOuterRefList(refMap);
            this.getDashboardPublishDao().deleteRefAndContent(publishId, refUid);
            this.getDashboardPublishDao().saveRefInfo(refMap, publishId);
            this.getDashboardPublishDao().saveRefContent(publishId, refUid, dashboardCache.toModelBook());
            this.savePublishOuterRef(outsideRef, refMap);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
    }

    public void saveOuterRef(List<OutsideReference> outsideRefList, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outsideRef = outsideRefList.get(i);
            ReferenceMap newRefMap = this.createReferenceMap(outsideRef);
            this.getDashboardDao().saveRefInfo(newRefMap, (String)refMap.get((Object)"id"));
        }
    }

    public void savePublishOuterRef(List<OutsideReference> outsideRefList, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outsideRef = outsideRefList.get(i);
            ReferenceMap newRefMap = this.createReferenceMap(outsideRef);
            this.getDashboardPublishDao().saveRefInfo(newRefMap, (String)refMap.get((Object)"id"));
        }
    }

    public ReferenceMap createReferenceMap(OutsideReference outsideRef) {
        ReferenceMap newRefMap = new ReferenceMap();
        newRefMap.setRefToFullPath(outsideRef.getRefToFullPath());
        newRefMap.setRefToId(outsideRef.getRefToId());
        newRefMap.setRefType(outsideRef.getRefType());
        newRefMap.setUid(outsideRef.getUid());
        return newRefMap;
    }

    @Override
    public void copyReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws AbstractQingIntegratedException, SQLException {
        List<OutsideReference> outsideRefList = this.getDashboardDao().loadSchemaRef((String)refMap.get((Object)"id"));
        this.getDashboardDao().saveRefInfo(refMap, toDsbId);
        this.saveOuterRef(outsideRefList, refMap);
        byte[] schemaContent = this.getDashboardDao().loadShemaContent(refMap.getUid(), fromDsbId);
        if (schemaContent != null) {
            this.getDashboardDao().saveRefSource(refMap, schemaContent, toDsbId);
        }
    }

    @Override
    public void copyExecutionReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector, int type) throws AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        List<OutsideReference> outsideRefList = this.getDashboardDao().loadExecutionSchemaRef((String)refMap.get((Object)"id"), type);
        this.getDashboardDao().saveRefInfo(refMap, toDsbId);
        this.saveOuterRef(outsideRefList, refMap);
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(refMap.getFileKey());
        if (dashboardCache.exists()) {
            outsideRefList = DashboardModelUtil.getOuterRefList(refMap);
            ModelBook modelBook = dashboardCache.toModelBook();
            modelBook.fixReferences(outsideRefList);
            this.getDashboardDao().saveRefSource(refMap, modelBook, toDsbId);
            this.saveOuterRef(outsideRefList, refMap);
        } else if (FileFactory.newFileVisitor((AbstractQingFileType)QingAppLocalTempFileType.LOCAL_TEMP, (String)refMap.getFileKey()).exists()) {
            outsideRefList = DashboardModelUtil.getOuterRefList(refMap);
            ModelBook modelBook = DashboardModelUtil.getFileModelBook(refMap.getFileKey());
            modelBook.fixReferences(outsideRefList);
            this.getDashboardDao().saveRefSource(refMap, dashboardCache.toModelBook(), toDsbId);
            this.saveOuterRef(outsideRefList, refMap);
        } else {
            byte[] schemaContent = this.getDashboardDao().loadExecutionShemaContent(refMap.getUid(), fromDsbId, type);
            if (schemaContent != null) {
                this.getDashboardDao().saveRefSource(refMap, schemaContent, toDsbId);
            }
        }
    }

    @Override
    public void deleteReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().deleteDsbRef(dsbId, refMap.getUid());
    }

    @Override
    public String loadRefFullPath(ReferenceMap refMap, String userId) throws AbstractQingIntegratedException, SQLException {
        return null;
    }

    @Override
    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        return null;
    }

    @Override
    public void deletePublishedRef(String publishId, String refUid, String refToId) throws AbstractQingIntegratedException, SQLException {
        String refFid = this.getDashboardPublishDao().getRefPK(publishId, refUid);
        this.getDashboardPublishDao().deleteRefAndContent(publishId, refFid);
        this.getDashboardPublishDao().deleteRefAndContent(publishId, refUid);
        this.getDashboardPublishDao().deleteRefContentUser(this.context.getUserId(), publishId, refUid);
        this.getDashboardPublishDao().deleteOuterRefOfUser(publishId, refUid);
        this.getSchemaManageDao().deleteSchemaByBizTag(refFid);
    }

    @Override
    public void exportRefContent(String dsbId, String dsbFolderPath, boolean isPreset, ReferenceMap referenceMap, ZipOutputStream zos) throws IOException, AbstractQingIntegratedException, SQLException {
        String schemaFolder = dsbFolderPath + File.separator + "qing-dsb-schema";
        String fullPath = (String)referenceMap.get((Object)"fullPath");
        String refType = (String)referenceMap.get((Object)"refType");
        String uid = (String)referenceMap.get((Object)"uid");
        ExportDsbSchemaProperty dsbSchemaProperty = new ExportDsbSchemaProperty();
        dsbSchemaProperty.setFullPath(fullPath);
        dsbSchemaProperty.setRefType(refType);
        dsbSchemaProperty.setUid(uid);
        dsbSchemaProperty.setReference((String)referenceMap.get((Object)"outSideRef"));
        String uuid = UUID.randomUUID().toString();
        String schemaPropertyXmlPath = schemaFolder + File.separator + uuid + File.separator + "qing-dsb-schema.xml";
        zos.putNextEntry(new ZipEntry(schemaPropertyXmlPath));
        XmlUtil.save((Element)dsbSchemaProperty.toXml(), (OutputStream)zos);
        byte[] schemaContent = this.getDashboardDao().loadShemaContent(uid, dsbId);
        String schemaContentPath = schemaFolder + File.separator + uuid + File.separator + "qing-dsb-schema.schema";
        zos.putNextEntry(new ZipEntry(schemaContentPath));
        zos.write(schemaContent);
    }

    @Override
    public void importRefContent(String dsbId, DashboardImportModel dsbImportModel, List<IQingFile> successImportFile) throws PersistentModelTooModernException, AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException {
        List<ExportDsbSchemaProperty> schemaPropertys = dsbImportModel.getRefSchemaPropertyByType(this.refType);
        List<String> schemaFileKeys = dsbImportModel.getFileKeyByType(this.refType);
        Map<String, String> qingCenterPathAndId = dsbImportModel.getPathAndIdByType(this.refType);
        if (schemaPropertys != null && schemaFileKeys != null) {
            for (int i = 0; i < schemaPropertys.size(); ++i) {
                ExportDsbSchemaProperty dsbSchemaProperty = schemaPropertys.get(i);
                String schemaFileKey = schemaFileKeys.get(i);
                this.saveRefContent(qingCenterPathAndId, dsbId, dsbSchemaProperty, schemaFileKey, dsbImportModel);
            }
        }
    }

    @Override
    public void exportSource(String refTag, ReferenceMap referenceMap, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("publishId", referenceMap.getRefToId());
        params.put("tag", refTag);
        PublishLongerSquareQHFExporter dsbRefPublishQHFExporter = new PublishLongerSquareQHFExporter(this.context, this.dbExcuter, this.tx);
        dsbRefPublishQHFExporter.export(params, meta);
    }

    @Override
    public void separateImportModel(DashboardImportModel dsbImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
        dsbImportModel.getRefSchemaPropertyByType(this.refType).add(dsbSchemaProperty);
        dsbImportModel.getFileKeys(this.refType).add(schemaFileKey);
    }

    @Override
    public void exportPublishedRefContent(String publishId, String folderPath, ReferenceMap refMap, IDashboardExportFilePathGetter dashboardExportFilePathGetter, ZipOutputStream zos) throws QingImglibException, AbstractQingIntegratedException, IOException, SQLException {
        String schemaPropertyPath = folderPath + File.separator + dashboardExportFilePathGetter.getSchemaPropertyFileNameInZip();
        String schemaPath = folderPath + File.separator + dashboardExportFilePathGetter.getSchemaFileNameInZip();
        zos.putNextEntry(new ZipEntry(schemaPropertyPath));
        ExportDsbSchemaProperty dsbSchemaProperty = new ExportDsbSchemaProperty();
        dsbSchemaProperty.setFullPath((String)refMap.get((Object)"fullPath"));
        dsbSchemaProperty.setRefType((String)refMap.get((Object)"refType"));
        dsbSchemaProperty.setUid((String)refMap.get((Object)"uid"));
        dsbSchemaProperty.setRefToId((String)refMap.get((Object)"refToId"));
        dsbSchemaProperty.setReference((String)refMap.get((Object)"outSideRef"));
        Element schemaPropertyElement = dsbSchemaProperty.toXml();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlUtil.save((Element)schemaPropertyElement, (OutputStream)baos);
        zos.write(baos.toByteArray());
        byte[] schemaContent = this.getDashboardPublishDao().selectRefContentUser(this.context.getUserId(), publishId, (String)refMap.get((Object)"uid"));
        if (schemaContent == null) {
            schemaContent = this.getDashboardPublishDao().loadRefContent(publishId, (String)refMap.get((Object)"uid"));
        }
        zos.putNextEntry(new ZipEntry(schemaPath));
        zos.write(schemaContent);
    }

    @Override
    public List<ReferenceMap> importPublishedRefContent(String publishId, DashboardImportModel dashboardImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> successImportFile) throws AbstractQingIntegratedException, ImportThemeException {
        List<ExportDsbSchemaProperty> dsbSchemaProperty = dashboardPublishImportModel.getRefByType(this.refType);
        List<String> dsbSchemaFileKey = dashboardPublishImportModel.getFileKeysByType(this.refType);
        Map<String, String> pathAndId = dashboardImportModel.getPathAndIdByType(this.refType);
        List<ReferenceMap> refItems = new ArrayList<ReferenceMap>();
        if (dsbSchemaProperty != null && dsbSchemaFileKey != null) {
            refItems = this.createRefList(pathAndId, dsbSchemaProperty, dsbSchemaFileKey, dashboardImportModel, dashboardPublishImportModel);
        }
        return refItems;
    }

    @Override
    public void separateImportModel(DashboardPublishImportModel dsbPublishImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
        dsbPublishImportModel.getRefByType(this.refType).add(dsbSchemaProperty);
        dsbPublishImportModel.getFileKeysByType(this.refType).add(schemaFileKey);
    }

    protected void saveRefContent(Map<String, String> refPathAndId, String dsbId, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey, DashboardImportModel dsbImportModel) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, AbstractQingIntegratedException, SQLException {
        String fullPath = dsbSchemaProperty.getFullPath();
        String refType = dsbSchemaProperty.getRefType();
        String uid = dsbSchemaProperty.getUid();
        ReferenceMap refItem = new ReferenceMap();
        refItem.setRefType(refType);
        refItem.setUid(uid);
        fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
        String newRefToId = refPathAndId.get(fullPath);
        String newFullPath = null;
        if (newRefToId != null) {
            refItem.setRefToId(newRefToId);
            refItem.setRefToFullPath(null);
        } else {
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            IRefHandler refHandler = this.getRefHandler(refTypeEnum);
            newFullPath = fullPath;
            ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
            if (switchPathAndIdHandler != null) {
                String[] path = fullPath.split("/");
                String nameSpace = path[0];
                String userId = this.context.getUserId();
                String groupName = path[1];
                String refSourceName = path[2];
                if (nameSpace.equals(NameSpace.system.toPersistance())) {
                    if (IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter) && (newRefToId = switchPathAndIdHandler.switchRefPathToId(groupName, refSourceName, userId = IntegratedHelper.getPresetUserId())) != null) {
                        newFullPath = null;
                    }
                } else {
                    newRefToId = switchPathAndIdHandler.switchRefPathToId(groupName, refSourceName, userId);
                    if (newRefToId != null) {
                        newFullPath = null;
                    }
                }
            }
            refItem.setRefToFullPath(newFullPath);
            refItem.setRefToId(newRefToId);
            this.cacheDashboardWidgetID(dsbImportModel, dsbId, uid, fullPath);
        }
        IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingAppLocalTempFileType.LOCAL_TEMP, (String)schemaFileKey);
        if (qingFileVisitor.exists()) {
            List<Map<String, String>> outSideRefMapList = dsbSchemaProperty.getReference();
            ModelBook modelBook = DashboardModelUtil.getFileModelBook(schemaFileKey);
            byte[] dsbModelBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
            this.getDashboardDao().saveRefInfo(refItem, dsbId);
            this.getDashboardDao().saveRefSource(refItem, dsbModelBytes, dsbId);
            if (outSideRefMapList != null && outSideRefMapList.size() > 0) {
                Set<String> mapPaths = dsbImportModel.getMapPath();
                for (int j = 0; j < outSideRefMapList.size(); ++j) {
                    Map<String, String> outSideRef = outSideRefMapList.get(j);
                    String mapPath = outSideRef.get("fullPath");
                    mapPaths.add(mapPath);
                }
                this.saveOutSideRef(outSideRefMapList, refItem);
            }
        }
    }

    private void saveOutSideRef(List<Map<String, String>> outSideRefMapList, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException {
        String fId = (String)refItem.get((Object)"id");
        for (int i = 0; i < outSideRefMapList.size(); ++i) {
            Map<String, String> refMap = outSideRefMapList.get(i);
            ReferenceMap newRefItem = new ReferenceMap();
            newRefItem.setRefToFullPath(refMap.get("fullPath"));
            newRefItem.setRefType(refMap.get("refType"));
            newRefItem.setUid(refMap.get("uid"));
            this.getDashboardDao().saveRefInfo(newRefItem, fId);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected List<ReferenceMap> createRefList(Map<String, String> refPathAndId, List<ExportDsbSchemaProperty> dsbSchemaProperty, List<String> dsbSchemaFileKey, DashboardImportModel dashboardImportModel, DashboardPublishImportModel dashboardPublishImportModel) throws AbstractQingIntegratedException, ImportThemeException {
        refItems = new ArrayList<ReferenceMap>(dsbSchemaProperty.size());
        for (j = 0; j < dsbSchemaProperty.size(); ++j) {
            schemaProperty = dsbSchemaProperty.get(j);
            schemaFileKey = dsbSchemaFileKey.get(j);
            refItem = new ReferenceMap();
            refType = schemaProperty.getRefType();
            fullPath = schemaProperty.getFullPath();
            refItem.setRefType(refType);
            refItem.setUid(schemaProperty.getUid());
            refItem.setFileKey(schemaFileKey);
            outSideRefKey = UUID.randomUUID().toString();
            refItem.put((Object)"outerRefKey", (Object)outSideRefKey);
            outSideRefMapList = schemaProperty.getReference();
            fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
            newRefToId = refPathAndId.get(fullPath);
            if (outSideRefMapList != null && outSideRefMapList.size() > 0) {
                outSideRefList = schemaProperty.getReference();
                mapPaths = dashboardImportModel.getMapPath();
                for (i = 0; i < outSideRefList.size(); ++i) {
                    outSideRef = outSideRefList.get(i);
                    mapPath = outSideRef.get("fullPath");
                    mapPaths.add(mapPath);
                }
                outerRefList = ImportUtil.createOutSideRef(outSideRefMapList, false);
                DashboardModelUtil.cacheOuterRef(refItem, outerRefList);
            }
            if (newRefToId != null) {
                refItem.setRefToId(newRefToId);
                refItem.setRefToFullPath(null);
            } else {
                refTypeEnum = RefTypeEnum.valueOf((String)refType);
                refHandler = this.getRefHandler(refTypeEnum);
                switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
                if (switchPathAndIdHandler != null) {
                    path = fullPath.split("/");
                    nameSpace = path[0];
                    groupName = path[1];
                    refSourceName = path[2];
                    userId = this.context.getUserId();
                    try {
                        if (nameSpace.equals(NameSpace.system.toPersistance())) {
                            if (!IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter) || (newRefToId = switchPathAndIdHandler.switchRefPathToId(groupName, refSourceName, userId = IntegratedHelper.getPresetUserId())) == null) ** GOTO lbl53
                            fullPath = null;
                        }
                        newRefToId = switchPathAndIdHandler.switchRefPathToId(groupName, refSourceName, userId);
                        if (newRefToId == null) ** GOTO lbl53
                        fullPath = null;
                    }
                    catch (SQLException e) {
                        throw new ImportThemeException(e);
                    }
                } else {
                    newRefToId = schemaProperty.getRefToId();
                }
lbl53:
                // 5 sources

                refItem.setRefToFullPath(fullPath);
                refItem.setRefToId(newRefToId);
            }
            refItems.add(refItem);
            this.cacheDashboardWidgetID(dashboardImportModel, dashboardPublishImportModel, schemaProperty.getUid(), schemaProperty.getFullPath());
        }
        return refItems;
    }

    private void cacheDashboardWidgetID(DashboardImportModel dashboardImportModel, DashboardPublishImportModel dashboardPublishImportModel, String uid, String fullPath) {
        Map<String, List<String>> cacheDsbIdAndUid = dashboardImportModel.getCacheDsbIdAndUid();
        String publishId = dashboardPublishImportModel.getPublishModel().getPublishId();
        String publishIdAndUid = publishId + "," + uid + "," + CACHED_PUBLISHID_SUFFIX;
        List<String> publishIdAndUids = cacheDsbIdAndUid.get(fullPath);
        if (null != publishIdAndUids) {
            publishIdAndUids.add(publishIdAndUid);
        } else {
            publishIdAndUids = new ArrayList<String>();
            publishIdAndUids.add(publishIdAndUid);
            cacheDsbIdAndUid.put(fullPath, publishIdAndUids);
        }
    }

    @Override
    public void savePublishReference(String dsbId, String publishId, ReferenceMap refMap, ModelBook modelBook) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, SQLException, AbstractQingIntegratedException {
        String fId = (String)refMap.get((Object)"id");
        List<Object> outsideRefList = new ArrayList();
        this.getDashboardPublishDao().saveRefInfo(refMap, publishId);
        if (modelBook == null) {
            DashboardModelBookCache dashboardCache = new DashboardModelBookCache(refMap.getFileKey());
            if (dashboardCache.exists()) {
                outsideRefList = DashboardModelUtil.getOuterRefList(refMap);
                modelBook = dashboardCache.toModelBook();
                modelBook.fixReferences(outsideRefList);
            } else if (FileFactory.newFileVisitor((AbstractQingFileType)QingAppLocalTempFileType.LOCAL_TEMP, (String)refMap.getFileKey()).exists()) {
                outsideRefList = DashboardModelUtil.getOuterRefList(refMap);
                modelBook = DashboardModelUtil.getFileModelBook(refMap.getFileKey());
                modelBook.fixReferences(outsideRefList);
            } else {
                byte[] schemaContent = this.getDashboardDao().loadShemaContent(refMap.getUid(), dsbId);
                if (fId == null) {
                    fId = (String)this.getDashboardDao().loadRef(dsbId, refMap.getUid()).get((Object)"id");
                }
                outsideRefList = this.getDashboardDao().loadSchemaRef(fId);
                if (schemaContent != null) {
                    modelBook = DashboardModelUtil.byteToSchemaModel(schemaContent);
                    modelBook.fixReferences(outsideRefList);
                }
            }
            if (modelBook != null) {
                this.getDashboardPublishDao().saveRefContent(publishId, refMap.getUid(), modelBook);
            }
        } else {
            this.getDashboardPublishDao().saveRefContent(publishId, refMap.getUid(), modelBook);
        }
        if (modelBook != null) {
            this.savePublishOuterRef(modelBook.pickReferences(), refMap);
        }
    }

    @Override
    public void deletePublishContent(String publishId) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardPublishDao().deletePublishedSchemaContent(publishId);
        List<String> refPKs = this.getDashboardPublishDao().getRefPKList(publishId);
        for (String refPk : refPKs) {
            this.getSchemaManageDao().deleteSchemaByBizTag(refPk);
        }
    }

    private void cacheDashboardWidgetID(DashboardImportModel dashboardImportModel, String dsbId, String uid, String fullPath) {
        Map<String, List<String>> cacheDsbIdAndUid = dashboardImportModel.getCacheDsbIdAndUid();
        String dashboardWidgetID = dsbId + "," + uid + "," + CACHED_DSBID_SUFFIX;
        List<String> dsbIdAndUids = cacheDsbIdAndUid.get(fullPath);
        if (null != dsbIdAndUids) {
            dsbIdAndUids.add(dashboardWidgetID);
        } else {
            dsbIdAndUids = new ArrayList<String>();
            dsbIdAndUids.add(dashboardWidgetID);
            cacheDsbIdAndUid.put(fullPath, dsbIdAndUids);
        }
    }

    protected ModelBook copySchemaToCache(String schemaId) throws AbstractQingException {
        try {
            byte[] schemaContent = this.getSchemaManageDao().loadSchemaContent(schemaId);
            List<OutsideReference> outerRef = this.getSchemaManageDao().loadSchemaRef(schemaId);
            if (CollectionUtils.isNotEmpty(outerRef)) {
                ReferenceMap referenceMap = new ReferenceMap();
                referenceMap.put((Object)"outerRefKey", (Object)this.outerRefKey);
                DashboardModelUtil.cacheOuterRef(referenceMap, outerRef);
            }
            if (schemaContent.length > 0) {
                DashboardModelBookCache dashboardCache = new DashboardModelBookCache(this.fileKey);
                dashboardCache.setValue(schemaContent);
                ModelBook modelBook = DashboardModelUtil.byteToSchemaModel(schemaContent);
                modelBook.fixReferences(outerRef);
                dashboardCache.save();
                return modelBook;
            }
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (IOException e) {
            throw new ModelBookTemporaryStorageException(e);
        }
        return null;
    }

    @Override
    public void saveTimingPushReference(String dashboardUniqueId, String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        String fId = this.getDsbTimingPushDao().saveRefInfo(sourceId, sourceType, refItem);
        this.saveTimingPushRefContent(sourceId, sourceType, dashboardUniqueId, refItem, fId);
    }

    private void saveTimingPushRefContent(String sourceId, int sourceType, String dashboardUniqueId, ReferenceMap refItem, String fId) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, AbstractQingIntegratedException, SQLException {
        ModelBook modelBook = new ModelBook();
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(refItem.getFileKey());
        List<Object> outSideRef = new ArrayList();
        if (dashboardCache.exists()) {
            modelBook = dashboardCache.toModelBook();
            outSideRef = DashboardModelUtil.getOuterRefList(refItem);
        } else {
            byte[] schemaContent = this.getDashboardDao().loadShemaContent(refItem.getUid(), dashboardUniqueId);
            modelBook = DashboardModelUtil.byteToSchemaModel(schemaContent);
            String refToId = (String)refItem.get((Object)"id");
            if (refToId == null) {
                refToId = (String)this.getDashboardDao().loadRef(dashboardUniqueId, refItem.getUid()).get((Object)"id");
            }
            outSideRef = this.getDashboardDao().loadSchemaRef(refToId);
        }
        this.saveTimingPushOutSideRef(outSideRef, fId, sourceType);
        this.getDsbTimingPushDao().saveRefContent(sourceId, sourceType, refItem, modelBook);
    }

    @Override
    public void updateTimingPushReference(String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException {
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(refItem.getFileKey());
        if (!dashboardCache.exists()) {
            return;
        }
        String refUid = refItem.getUid();
        try {
            DsbTimingPushDao dsbTimingPushDao = this.getDsbTimingPushDao();
            String refFid = dsbTimingPushDao.loadRefPkId(sourceId, refUid, sourceType);
            dsbTimingPushDao.deleteRefAndContent(sourceId, refFid, sourceType);
            List<OutsideReference> outsideRef = DashboardModelUtil.getOuterRefList(refItem);
            dsbTimingPushDao.deleteRefAndContent(sourceId, refUid, sourceType);
            String fId = dsbTimingPushDao.saveRefInfo(sourceId, sourceType, refItem);
            this.saveTimingPushOutSideRef(outsideRef, fId, sourceType);
            dsbTimingPushDao.saveRefContent(sourceId, sourceType, refItem, dashboardCache.toModelBook());
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw PersistentModelParseException.createParseError((Throwable)e);
        }
        dashboardCache.delete();
    }

    @Override
    public void deleteTimingPushReference(String sourceId, ReferenceMap refMap, int sourceType) throws AbstractQingIntegratedException, SQLException {
        DsbTimingPushDao dsbTimingPushDao = this.getDsbTimingPushDao();
        String refFid = this.getDsbTimingPushDao().loadRefPkId(sourceId, refMap.getUid(), sourceType);
        dsbTimingPushDao.deleteRefAndContent(sourceId, refFid, sourceType);
        dsbTimingPushDao.deleteRefAndContent(sourceId, refMap.getUid(), sourceType);
    }

    private void saveTimingPushOutSideRef(List<OutsideReference> outsideRefList, String fId, int sourceType) throws AbstractQingIntegratedException, SQLException {
        DsbTimingPushDao dsbTimingPushDao = this.getDsbTimingPushDao();
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outsideRef = outsideRefList.get(i);
            ReferenceMap newRefMap = this.createReferenceMap(outsideRef);
            dsbTimingPushDao.saveRefInfo(fId, sourceType, newRefMap);
        }
    }

    @Override
    public String getPrepareDataTag(String tag, String refToId) throws AbstractQingIntegratedException, SQLException {
        PublishPO refSourcePublishInfo = this.getCommonPublishDomain().loadPublishInfo(refToId);
        if (refSourcePublishInfo != null) {
            if (!refSourcePublishInfo.isCarryData()) {
                PublishSourceEnum publishSourceEnum = refSourcePublishInfo.getPublishSourceType();
                AbstractPublishPrepareDataHandler refHandler = RefPublishPrepareDataHandlerFactory.createPublishHandler(publishSourceEnum, this.dbExcuter, this.context);
                return refHandler.getPublishPrepareDataTag(tag, refToId, refSourcePublishInfo.getTagId());
            }
            return tag + "_publishCarryData_" + refToId;
        }
        LogUtil.warn((String)("publishInfo not find publishId:" + refToId));
        return null;
    }

    @Override
    public IPrepareDataContext getDataPrepareContext(String tag, String refToId, boolean isStartBySchedule, boolean isFirstFromCache, ProgressModel progressModel) {
        PublishPrepareDataContext prepareDataContext = new PublishPrepareDataContext();
        prepareDataContext.setQingContext(this.context);
        prepareDataContext.setDbExcuter(this.dbExcuter);
        prepareDataContext.setTx(this.tx);
        prepareDataContext.setTag(tag);
        prepareDataContext.setTimeStamp(System.currentTimeMillis());
        prepareDataContext.setFromType(FromType.publish);
        prepareDataContext.setDealProgresss(false);
        prepareDataContext.setStartBySchedule(isStartBySchedule);
        prepareDataContext.setFirstFromCache(isFirstFromCache);
        prepareDataContext.setProgressModel(progressModel);
        prepareDataContext.setPublishId(refToId);
        return prepareDataContext;
    }

    @Override
    public AbstractPrepareDataHandler getDataPrepareHandler(IPrepareDataContext prepareDataContext) {
        return new PublishedPrepareDataHandler(prepareDataContext);
    }

    @Override
    public void createPublishedCarryDataDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws ModelParseException, AbstractQingIntegratedException, SQLException, IOException, PrepareDataException {
        String refToId = referenceMap.getRefToId();
        String refUid = referenceMap.getUid();
        PublishPO sourcePublishPO = this.getCommonPublishDomain().loadPublishInfo(refToId);
        if (sourcePublishPO == null) {
            throw new PublishedDsbRefPublishNotExistPrepareDataException(refUid);
        }
        PublishSourceEnum publishSourceEnum = this.getCommonPublishDomain().confirmSourceTypeByPublishInfo(sourcePublishPO);
        AbstractPublishPrepareDataHandler refHandler = RefPublishPrepareDataHandlerFactory.createPublishHandler(publishSourceEnum, this.dbExcuter, this.context);
        if (refHandler instanceof AbstractPublishPrepareDataHandler) {
            AbstractPublishPrepareDataHandler prepareDataable = refHandler;
            prepareDataable.createPublishedCarryDataDataSource(tag, publishPO, referenceMap);
        }
    }

    @Override
    public void cacheQHFDataSource(String refTag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        String refToId = referenceMap.getRefToId();
        new PublishModelParser().cacheDataSourceById(refTag, refToId, importedModel);
    }

    @Override
    public AbstractDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        return new PublishModelParser().getQHFDataSourceInfo(tag, referenceMap, importedModel);
    }

    @Override
    public String getQHFUniqueRefId(String refToId, PackageMeta packageMeta) {
        List<AbstractPublishObject> publishObjects = packageMeta.getPublishObjs();
        if (publishObjects != null && !publishObjects.isEmpty()) {
            for (AbstractPublishObject abstractPublishObject : publishObjects) {
                PublishPO refSourcePublishInfo = abstractPublishObject.getPublishPO();
                if (!refSourcePublishInfo.getId().equals(refToId)) continue;
                if (!refSourcePublishInfo.isCarryData()) {
                    PublishSourceEnum publishSourceEnum = refSourcePublishInfo.getPublishSourceType();
                    AbstractPublishPrepareDataHandler refHandler = RefPublishPrepareDataHandlerFactory.createPublishHandler(publishSourceEnum, this.dbExcuter, this.context);
                    return refHandler.getQHFPublishUniqueRefId(refSourcePublishInfo, packageMeta);
                }
                return "publishCarryData_" + refToId;
            }
        }
        return "";
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }
}

