/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.ISecondPublishable;
import com.kingdee.bos.qing.dashboard.reference.impl.QingRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.SubjectSwitchPathAndIdHandler;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishSubjectQHFExporter;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.impl.SubjectModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.SubjectDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PrepareEncryptedLicenseCheckException;
import com.kingdee.bos.qing.preparedata.exception.PublishedDsbRefCarryDataPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectNotFoundPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.subject.SubjectPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.SubjectPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.FromType;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefSubjectFileDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefSubjectModelDao;
import com.kingdee.bos.qing.publish.model.PubDsbRefExtractDataExceptionLog;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishSubjectFilePO;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.JDOMException;

class SubjectHandler
extends QingRefHandler
implements ISecondPublishable {
    private static final String SCHEMA_CACHE_SUFFIX = "_subject";
    private PublishDsbRefSubjectFileDao publishDsbRefSubjectFileDao;
    private PublishDsbRefSubjectModelDao publishDsbRefSubjectModelDao;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;

    public SubjectHandler() {
        super(RefTypeEnum.subject);
    }

    private PublishDsbRefSubjectModelDao getPublishDsbRefSubjectModelDao() {
        if (this.publishDsbRefSubjectModelDao == null) {
            this.publishDsbRefSubjectModelDao = new PublishDsbRefSubjectModelDao(this.dbExcuter);
        }
        return this.publishDsbRefSubjectModelDao;
    }

    private PublishDsbRefSubjectFileDao getPublishDsbRefSubjectFileDao() {
        if (this.publishDsbRefSubjectFileDao == null) {
            this.publishDsbRefSubjectFileDao = new PublishDsbRefSubjectFileDao(this.dbExcuter);
        }
        return this.publishDsbRefSubjectFileDao;
    }

    @Override
    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new SubjectSwitchPathAndIdHandler(this.context, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    @Override
    public void addRefContent(Map<String, String> params, Map<String, Object> result) throws AbstractQingException {
        String schemaId = params.get("schemaId");
        ModelBook modelBook = super.copySchemaToCache(schemaId);
        result.put("model", modelBook);
    }

    @Override
    public void collectSecondPublishInfo(ReferenceMap referenceMap, Map<String, String> collector) throws AbstractQingIntegratedException, SQLException {
        String publishSourceType = PublishSourceEnum.subject.name();
        String themeId = referenceMap.getRefToId();
        collector.put("themeId", themeId);
        collector.put("bizTag", themeId);
        ThemePO themePO = this.getThemeDao().getThemeByID(themeId);
        if (themePO != null) {
            String themeName = themePO.getThemeName();
            collector.put("themeName", themeName);
        }
        collector.put("publishSourceType", publishSourceType);
    }

    protected String getSchemaCacheSuffix() {
        return SCHEMA_CACHE_SUFFIX;
    }

    @Override
    public String getPrepareDataTag(String tag, String refToId) {
        return tag + "_" + PublishSourceEnum.subject.name() + "_" + refToId;
    }

    @Override
    public String getPublishPrepareDataTag(String tag, String publishId, String bizId) {
        return this.getPrepareDataTag(tag, bizId);
    }

    @Override
    public IPrepareDataContext getDataPrepareContext(String tag, String refToId, boolean isStartBySchedule, boolean isFirstFromCache, ProgressModel progressModel) {
        SubjectPrepareDataContext subjectPrepareDataContext = new SubjectPrepareDataContext();
        subjectPrepareDataContext.setQingContext(this.context);
        subjectPrepareDataContext.setDbExcuter(this.dbExcuter);
        subjectPrepareDataContext.setTx(this.tx);
        subjectPrepareDataContext.setTag(tag);
        subjectPrepareDataContext.setTimeStamp(System.currentTimeMillis());
        subjectPrepareDataContext.setFromType(FromType.subject);
        subjectPrepareDataContext.setDealProgresss(false);
        subjectPrepareDataContext.setStartBySchedule(isStartBySchedule);
        subjectPrepareDataContext.setFirstFromCache(isFirstFromCache);
        subjectPrepareDataContext.setThemeId(refToId);
        subjectPrepareDataContext.setSaveMode(!isStartBySchedule);
        subjectPrepareDataContext.setProgressModel(progressModel);
        return subjectPrepareDataContext;
    }

    @Override
    public AbstractPrepareDataHandler getDataPrepareHandler(IPrepareDataContext prepareDataContext) {
        return new SubjectPrepareDataHandler(prepareDataContext);
    }

    @Override
    public void createPublishedCarryDataDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws PrepareDataException, ModelParseException, AbstractQingIntegratedException, SQLException, IOException {
        this.createSubjectTimingPushPublishedDataSource(tag, publishPO, referenceMap);
    }

    public void createSubjectTimingPushPublishedDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws PrepareDataException, ModelParseException, AbstractQingIntegratedException, SQLException, IOException {
        HashMap<String, String> newTempDataFiles;
        long extractDataTime;
        String refUid = referenceMap.getUid();
        Box box = null;
        try {
            box = this.getPublishDsbRefSubjectModelDao().loadBoxByPublishId(publishPO.getId(), refUid);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new PrepareEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
        }
        if (box != null) {
            List<PublishSubjectFilePO> publishSubjectFilePOs = this.getPublishDsbRefSubjectFileDao().loadPublishSubjectFile(publishPO.getId(), refUid);
            extractDataTime = System.currentTimeMillis();
            HashMap<String, String> dataPathMap = new HashMap<String, String>(publishSubjectFilePOs.size());
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                dataPathMap.put(publishSubjectFilePO.getEntityName(), publishSubjectFilePO.getFilePath());
                if (publishSubjectFilePO.getExtractDataTime() == null) continue;
                extractDataTime = publishSubjectFilePO.getExtractDataTime().getTime();
            }
            newTempDataFiles = new HashMap<String, String>();
            for (Map.Entry entry : dataPathMap.entrySet()) {
                String dataFileName = (String)dataPathMap.get(entry.getKey());
                IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)dataFileName);
                if (dataFile.exists()) {
                    IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
                    String cacheKey = "Qing.TempQsFile." + dataFileName;
                    String tempDataFileName = globalQingSession.get(cacheKey);
                    IQingFileVisitor tmpDataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)tempDataFileName);
                    if (tempDataFileName == null || !tmpDataFile.exists()) {
                        IQingFile tempDataFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
                        FileFactory.copy((IQingFileVisitor)dataFile, (IQingFile)tempDataFile, (boolean)true);
                        tempDataFileName = tempDataFile.getName();
                        globalQingSession.set(cacheKey, tempDataFileName);
                    }
                    newTempDataFiles.put((String)entry.getKey(), tempDataFileName);
                    continue;
                }
                throw new FileNotFoundException(dataFileName);
            }
        } else {
            PubDsbRefExtractDataExceptionLog exceptionLog = this.getPubDsbRefExtractDataExceptionLogDao().selectExceptionLog(publishPO.getId(), refUid);
            if (exceptionLog == null) {
                throw new SubjectNotFoundPrepareDataException();
            }
            if (exceptionLog.getErrorCode() == 2101006) {
                throw new PublishedDsbRefCarryDataPrepareDataException(exceptionLog.getErrorCode(), exceptionLog.getErrorStackTrace(), exceptionLog.getErrorStackTrace());
            }
            throw new PublishedDsbRefCarryDataPrepareDataException(exceptionLog.getErrorCode(), exceptionLog.getErrorMessage(), exceptionLog.getErrorStackTrace());
        }
        ThemeDataSource dataSource = new ThemeDataSource();
        dataSource.setThemeId(publishPO.getTagId());
        dataSource.setTag(tag);
        dataSource.setOriginalCreatorId(publishPO.getCreatorId());
        dataSource.setDataFiles(newTempDataFiles);
        dataSource.setLastVisitTime(System.currentTimeMillis());
        dataSource.setExtractDataTime(extractDataTime);
        dataSource.setBox(box);
        QingSessionUtil.setCache((ISessionCacheable)dataSource);
    }

    @Override
    public String loadRefFullPath(ReferenceMap refItem, String userId) throws AbstractQingIntegratedException, SQLException {
        String refToId = refItem.getRefToId();
        ThemePO themePO = this.getThemeDomain().getThemeByID(refToId);
        if (themePO != null) {
            ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(themePO.getUserID(), themePO.getGroupID());
            return themeGroupVO.getThemeGroupName() + "/" + themePO.getThemeName();
        }
        return null;
    }

    @Override
    public void exportSource(String refTag, ReferenceMap referenceMap, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("themeId", referenceMap.getRefToId());
        params.put("tag", refTag);
        PublishSubjectQHFExporter publishSubjectQHFExporter = new PublishSubjectQHFExporter(this.context, this.dbExcuter, this.tx);
        publishSubjectQHFExporter.export(params, meta);
    }

    @Override
    public void cacheQHFDataSource(String refTag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        String refToId = referenceMap.getRefToId();
        new SubjectModelParser().cacheDataSourceById(refTag, refToId, importedModel);
    }

    @Override
    public SubjectDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        return new SubjectModelParser().getQHFDataSourceInfo(tag, referenceMap, importedModel);
    }

    @Override
    public String getQHFPublishUniqueRefId(PublishPO publishPO, PackageMeta packageMeta) {
        return PublishSourceEnum.subject.name() + "_" + publishPO.getTagId();
    }

    @Override
    public String getQHFUniqueRefId(String refToId, PackageMeta packageMeta) {
        return PublishSourceEnum.subject.name() + "_" + refToId;
    }
}

