/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.common;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.dbmanage.domain.DBConnectionDomain;
import com.kingdee.bos.qing.dbmanage.export.DBExportModelConvertor;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.dbmanage.model.DBRefInfo;
import com.kingdee.bos.qing.dbmanage.model.RefFromType;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.imagelibrary.dao.ImageLibraryDao;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.resource.DBConnInfo;
import com.kingdee.bos.qing.imexport.model.resource.Picture;
import com.kingdee.bos.qing.imexport.model.resource.QingMap;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import com.kingdee.bos.qing.imexport.model.resource.Thumbnail;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.macro.domain.MacroDomainFactory;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.export.ExportModelConvertor;
import com.kingdee.bos.qing.macro.model.MacroType;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.domain.MapDesignerDomain;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.model.MapModelContent;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.jdom2.JDOMException;

public abstract class AbstractExportDomain {
    protected QingContext qingContext;
    protected IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    protected IScheduleEngine scheduleEngine;
    private MapManageDao mapManageDao;
    private ImageLibraryDao imageLibraryDao;
    private MapDesignerDomain mapDesignerDomain;
    private MacroCommonDomain macroDomain;
    private Map<MacroType, AbstractMacroDomain> macroDomainMap;
    private DBConnectionDomain dbConnDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private MapDesignerDomain getMapDesignerDomain() {
        if (this.mapDesignerDomain == null) {
            this.mapDesignerDomain = new MapDesignerDomain();
            this.mapDesignerDomain.setDbExcuter(this.dbExcuter);
            this.mapDesignerDomain.setTx(this.tx);
            this.mapDesignerDomain.setQingContext(this.qingContext);
        }
        return this.mapDesignerDomain;
    }

    private ImageLibraryDao getImageLibraryDao() {
        if (this.imageLibraryDao == null) {
            this.imageLibraryDao = new ImageLibraryDao(this.dbExcuter);
        }
        return this.imageLibraryDao;
    }

    private MacroCommonDomain getMacroCommonDomain() {
        if (this.macroDomain == null) {
            this.macroDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        }
        return this.macroDomain;
    }

    private AbstractMacroDomain getMacroManageDomain(MacroType macroType) throws QingMacroException {
        AbstractMacroDomain manageDomain = null;
        if (this.macroDomainMap == null) {
            this.macroDomainMap = new HashMap<MacroType, AbstractMacroDomain>();
        } else {
            manageDomain = this.macroDomainMap.get(macroType);
        }
        if (manageDomain == null) {
            manageDomain = MacroDomainFactory.getDomain((MacroType)macroType, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (QingContext)this.qingContext);
        }
        return manageDomain;
    }

    private DBConnectionDomain getDBConnDomain() {
        if (this.dbConnDomain == null) {
            this.dbConnDomain = new DBConnectionDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.dbConnDomain;
    }

    protected abstract PackageMeta export(Map<String, String> var1) throws SQLException, AbstractQingException, IOException, JDOMException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doExport(Map<String, String> params) throws SQLException, AbstractQingException, IOException, JDOMException {
        PackageMeta packageMeta = null;
        try {
            packageMeta = this.export(params);
            String string = this.exportZip(packageMeta);
            return string;
        }
        finally {
            try {
                this.endCleanFiles(packageMeta);
            }
            catch (Exception e) {
                LogUtil.error((String)"endCleanFiles error", (Throwable)e);
            }
        }
    }

    private void endCleanFiles(PackageMeta packageMeta) {
        if (packageMeta == null) {
            return;
        }
        packageMeta.endCleanFiles();
    }

    protected String exportZip(PackageMeta meta) throws ExportException {
        this.attachResources(meta);
        return this.writeToZip(meta);
    }

    private void attachResources(PackageMeta meta) throws ExportException {
        try {
            Resources resource = meta.getResources();
            List<QingMap> qingMaps = this.getQingMaps(resource.getMapIds());
            resource.setQingMaps(qingMaps);
            List<Picture> pictures = this.getPictures(resource.getPictureFileNames());
            resource.setPictures(pictures);
            List<Thumbnail> cardThumbnails = this.getThumbnails(resource.getThumbnailImagePaths());
            List<Thumbnail> lappThumbnails = this.getThumbnails(resource.getLappImagePaths());
            resource.setCardThumbnails(cardThumbnails);
            resource.setLappThumbnails(lappThumbnails);
            this.addMacrosAndDBConnInfo(resource.getMacroUids(), resource);
        }
        catch (MapException e) {
            throw new ExportException((Throwable)((Object)e));
        }
        catch (AbstractQingIntegratedException e) {
            throw new ExportException(e);
        }
        catch (SQLException e) {
            throw new ExportException(e);
        }
    }

    private String writeToZip(PackageMeta meta) throws ExportException {
        String string;
        IQingFileWriter zipFileWriter = null;
        QingOutputStream fos = null;
        ZipOutputStream zos = null;
        Exception exception = null;
        IQingFile exportFile = null;
        try {
            exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
            zipFileWriter = exportFile.createWriter();
            fos = zipFileWriter.getOutputStream();
            zos = new ZipOutputStream((OutputStream)fos);
            meta.exportToZip(zos);
            string = exportFile.getName();
        }
        catch (Exception e) {
            try {
                FileFactory.clearFile((IQingFile)exportFile);
                exception = e;
                throw new ExportException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zos});
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                if (zipFileWriter != null) {
                    zipFileWriter.close(exception);
                    zipFileWriter = null;
                }
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zos});
        CloseUtil.close((Closeable[])new Closeable[]{fos});
        if (zipFileWriter != null) {
            zipFileWriter.close(exception);
            zipFileWriter = null;
        }
        return string;
    }

    private List<QingMap> getQingMaps(Set<String> mapIds) throws AbstractQingIntegratedException, SQLException, MapException {
        ArrayList<QingMap> qingMaps = new ArrayList<QingMap>(10);
        for (String mapId : mapIds) {
            MapVO mapVO = this.getMapManageDao().loadMapForExport(mapId, NameSpace.user.getCode());
            MapModelContent mapModelContent = this.getMapDesignerDomain().loadMapContent(mapId);
            if (mapVO == null || mapVO != null && NameSpace.getNameSpace((String)mapVO.getNameSpace()) == NameSpace.system) continue;
            QingMap qingMap = new QingMap();
            qingMap.setId(mapVO.getMapId());
            qingMap.setCategoryName(mapVO.getMapGroupName());
            qingMap.setDesc(mapVO.getMapDescription());
            qingMap.setName(mapVO.getMapName());
            qingMap.setVersion(mapVO.getVersion());
            qingMap.setNameSpace(mapVO.getNameSpace());
            if (mapModelContent != null) {
                qingMap.setModelFileName(mapModelContent.getMapModelFileName());
                qingMap.setSvgFileName(mapModelContent.getMapSvgFileName());
                qingMap.setConfigFileName(mapModelContent.getMapConfigFileName());
                qingMap.setThumbnailFileName(mapModelContent.getMapThumbnailFileName());
                qingMap.setBackgroundImageFileName(mapModelContent.getImageFileName());
            }
            qingMaps.add(qingMap);
        }
        return qingMaps;
    }

    private List<Picture> getPictures(Set<String> pictureFileNames) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Picture> pictures = new ArrayList<Picture>(pictureFileNames.size());
        Iterator<String> iterator = pictureFileNames.iterator();
        String userId = this.qingContext.getUserId();
        while (iterator.hasNext()) {
            String pictureFileName = iterator.next();
            ImageModel imageModel = this.getImageLibraryDao().loadImageModel(pictureFileName, userId);
            if (imageModel == null) continue;
            String categoryName = this.getImageLibraryDao().getCategoryName(pictureFileName, userId);
            Picture picture = new Picture();
            picture.setCategoryName(categoryName);
            picture.setId(imageModel.getImageFileName());
            picture.setImageName(imageModel.getImageName());
            picture.setNameSpace(imageModel.getNameSpace().toPersistance());
            pictures.add(picture);
        }
        return pictures;
    }

    private List<Thumbnail> getThumbnails(Set<String> thumbnailImagePaths) {
        ArrayList<Thumbnail> thumbnails = new ArrayList<Thumbnail>(thumbnailImagePaths.size());
        for (String imagePath : thumbnailImagePaths) {
            Thumbnail thumbnail = new Thumbnail();
            thumbnail.setId(imagePath);
            thumbnails.add(thumbnail);
        }
        return thumbnails;
    }

    private void addMacrosAndDBConnInfo(Set<String> macroUids, Resources resource) {
        ArrayList<com.kingdee.bos.qing.imexport.model.resource.Macro> macros = new ArrayList<com.kingdee.bos.qing.imexport.model.resource.Macro>();
        ArrayList<DBConnInfo> dbConnInfos = new ArrayList<DBConnInfo>();
        for (String macroUid : macroUids) {
            try {
                Macro commonMacro = this.getMacroCommonDomain().loadCommonMacroByUid(macroUid);
                Macro macro = this.getMacroManageDomain(commonMacro.getType()).loadMacro(commonMacro.getFid());
                com.kingdee.bos.qing.imexport.model.resource.Macro macroForExport = ExportModelConvertor.convertMacroToExportModel(macro);
                if (macro instanceof SQLMacro) {
                    DBConnection dbConn;
                    List dbRefInfos = this.getDBConnDomain().loadDBRefInfoByFromId(macro.getFid(), RefFromType.Macro);
                    if (!dbRefInfos.isEmpty()) {
                        ((com.kingdee.bos.qing.imexport.model.resource.SQLMacro)macroForExport).setRefDBHashcode(((DBRefInfo)dbRefInfos.get(0)).getDBHashcode());
                    }
                    if ((dbConn = ((SQLMacro)macro).getDBInfo()) != null && dbConn.isDBCenterSource()) {
                        dbConnInfos.add(DBExportModelConvertor.convertDBConnToExportModel((DBConnection)dbConn));
                    }
                }
                macros.add(macroForExport);
            }
            catch (Exception e) {
                LogUtil.error((String)("load macro failed when export, macroUid:" + macroUid));
            }
        }
        resource.setMacros(macros);
        resource.setDBConnInfos(dbConnInfos);
    }
}

