/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.trace.TraceSpansCacheUtil;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.AbstractQHFExporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaNamespaceEnum;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaTypeEnum;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSchemaObjsQHFExporter
extends AbstractQHFExporter {
    private SchemaManageDao schemaDao;
    private MapManageDao mapManageDao;

    protected AbstractSchemaObjsQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    protected SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    protected List<SchemaObject> getDBSchema(String bizTag, PackageMeta meta) throws ExportException, SQLException, AbstractQingException, IOException {
        ArrayList<SchemaObject> schemaObjs = new ArrayList<SchemaObject>(10);
        ArrayList<SchemaBO> schemaList = this.getSchemaDao().getSchemaByBiztag(bizTag, this.qingContext.getUserId());
        for (SchemaBO schemaBO : schemaList) {
            SchemaObject schemaObj = new SchemaObject();
            SchemaInfo schemaInfo = new SchemaInfo();
            schemaInfo.setSchemaBO(schemaBO);
            byte[] schemaContent = this.getSchemaDao().loadSchemaContent(schemaBO.getfId());
            String schemaContentFileName = ImExportUtil.writeBytesToExportTempFile(schemaContent);
            schemaInfo.setSchemaContentFile(schemaContentFileName);
            schemaObj.setSchemaInfo(schemaInfo);
            List<OutsideReference> outSideRefList = this.getOutsideRefs(schemaBO, meta);
            schemaObj.setOutSideRefs(outSideRefList);
            schemaObjs.add(schemaObj);
        }
        return schemaObjs;
    }

    protected List<SchemaObject> getExtraSchemaObjects(Map<String, String> params, String tag, PackageMeta meta) throws IOException, AbstractQingIntegratedException, SQLException {
        ArrayList<SchemaObject> schemaObjs = new ArrayList<SchemaObject>(10);
        String schemaTypeStr = params.get("schemaType");
        if (StringUtils.isNotBlank((CharSequence)schemaTypeStr)) {
            String finalSchemaContext;
            int schemaType = Integer.parseInt(schemaTypeStr);
            SchemaTypeEnum schemaTypeEnum = SchemaTypeEnum.getSchemaTypeEnum(schemaType);
            String initSchemaContext = params.get("initSchemaContext");
            if (StringUtils.isNotBlank((CharSequence)initSchemaContext)) {
                SchemaObject schemaObj = new SchemaObject();
                SchemaInfo schemaInfo = new SchemaInfo();
                SchemaBO initSchemaBO = new SchemaBO();
                initSchemaBO.setfId(ImExportUtil.getInitSchemaId(schemaTypeEnum));
                initSchemaBO.setIsDefault(false);
                initSchemaBO.setSchemaName("\u521d\u59cb\u65b9\u6848\uff08QHF\uff09");
                initSchemaBO.setSchemaType(SchemaNamespaceEnum.system.getType());
                initSchemaBO.setSource(schemaTypeEnum.getType());
                initSchemaBO.setSeq(-1);
                schemaInfo.setSchemaBO(initSchemaBO);
                ModelBook modelBook = ModelJsonDecoder.decode((String)initSchemaContext);
                byte[] schemaContent = ModelBookUtil.toByte(modelBook);
                String schemaContentFileName = ImExportUtil.writeBytesToExportTempFile(schemaContent);
                schemaInfo.setSchemaContentFile(schemaContentFileName);
                schemaObj.setSchemaInfo(schemaInfo);
                List<OutsideReference> outSideRefList = this.getOutsideRefs(initSchemaBO, meta);
                schemaObj.setOutSideRefs(outSideRefList);
                schemaObjs.add(schemaObj);
            }
            if (StringUtils.isNotBlank((CharSequence)(finalSchemaContext = params.get("finalSchemaContext")))) {
                SchemaObject schemaObj = new SchemaObject();
                SchemaInfo schemaInfo = new SchemaInfo();
                SchemaBO initSchemaBO = new SchemaBO();
                initSchemaBO.setfId(ImExportUtil.getFinalSchemaId(schemaTypeEnum));
                initSchemaBO.setIsDefault(false);
                initSchemaBO.setSchemaName("\u6700\u7ec8\u65b9\u6848\uff08QHF\uff09");
                initSchemaBO.setSchemaType(SchemaNamespaceEnum.system.getType());
                initSchemaBO.setSource(schemaTypeEnum.getType());
                initSchemaBO.setSeq(-2);
                schemaInfo.setSchemaBO(initSchemaBO);
                ModelBook modelBook = ModelJsonDecoder.decode((String)finalSchemaContext);
                byte[] schemaContent = ModelBookUtil.toByte(modelBook);
                String schemaContentFileName = ImExportUtil.writeBytesToExportTempFile(schemaContent);
                schemaInfo.setSchemaContentFile(schemaContentFileName);
                List executeTraceSpans = TraceSpansCacheUtil.getCacheTraceSpans((String)tag, (TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE);
                schemaInfo.setExecuteTraceSpans(executeTraceSpans);
                List joinTraceSpans = TraceSpansCacheUtil.getCacheTraceSpans((String)tag, (TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.JOIN);
                schemaInfo.setJoinTraceSpans(joinTraceSpans);
                schemaObj.setSchemaInfo(schemaInfo);
                List<OutsideReference> outSideRefList = this.getOutsideRefs(initSchemaBO, meta);
                schemaObj.setOutSideRefs(outSideRefList);
                schemaObjs.add(schemaObj);
            }
        }
        return schemaObjs;
    }

    protected List<OutsideReference> getOutsideRefs(SchemaBO schemaBO, PackageMeta meta) throws AbstractQingIntegratedException, SQLException {
        List<OutsideReference> outSideRefList = this.getSchemaDao().loadSchemaRef(schemaBO.getfId());
        if (outSideRefList != null && !outSideRefList.isEmpty()) {
            for (int j = 0; j < outSideRefList.size(); ++j) {
                OutsideReference outsideReference = outSideRefList.get(j);
                String mapId = outsideReference.getRefToId();
                PathModel pathModel = new PathModel();
                if (mapId != null) {
                    ExportMapModel mapVO = this.getMapManageDao().loadMapWithGroupName(mapId);
                    if (mapVO != null) {
                        pathModel.setNameSpace(NameSpace.user.toPersistance());
                        pathModel.setGroupName(mapVO.getMapGroupName());
                        pathModel.setName(mapVO.getMapName());
                        outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                    }
                    meta.getResources().getMapIds().add(mapId);
                    continue;
                }
                try {
                    JsonUtil.decodeFromString((String)outsideReference.getRefToFullPath(), PathModel.class);
                    continue;
                }
                catch (Exception e) {
                    String[] path = StringUtils.split((String)outsideReference.getRefToFullPath(), (char)'/');
                    if (path.length < 3) continue;
                    pathModel.setNameSpace(path[0]);
                    pathModel.setGroupName(path[1]);
                    pathModel.setName(path[2]);
                    outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                }
            }
        }
        return outSideRefList;
    }
}

