/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpansCacheUtil;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.domain.DashboardDesignDomain;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.imexport.exporter.exception.ExportException;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.AbstractQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishLongerSquareQHFExporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.imexport.util.QHFDsbUtil;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.ThemeNotFoundException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.JDOMException;

public class DsbDesignerQHFExporter
extends AbstractQHFExporter {
    private IThemeDao iThemeDao;
    private IThemeGroupDao themeGroupDao;
    private DashboardDao dashboardDao;
    private DashboardDesignDomain dashboardDesignDomain;
    private MapManageDao mapManageDao;
    private CommonPublishDomain commonPublishDomain;

    public DsbDesignerQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    private DashboardDesignDomain getDashboardDesignDomain() {
        if (this.dashboardDesignDomain == null) {
            this.dashboardDesignDomain = new DashboardDesignDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.dashboardDesignDomain;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.themeGroupDao == null) {
            this.themeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.themeGroupDao;
    }

    protected DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    @Override
    public void export(Map<String, String> params, PackageMeta meta) throws ExportException, SQLException, AbstractQingException, IOException, JDOMException {
        String dsbId = params.get("dsbId");
        String userId = this.qingContext.getUserId();
        DashboardObject dashboardObj = new DashboardObject();
        ThemeVO themeVo = this.getThemeDao().loadThemeIncludePreset(userId, dsbId);
        if (themeVo == null) {
            throw new ThemeNotFoundException();
        }
        dashboardObj.setThemeVO(themeVo);
        ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(this.qingContext.getUserId(), themeVo.getThemeGroupID());
        dashboardObj.setThemeGroupVO(themeGroupVO);
        DashboardModel dashboardModel = this.getDashboardDesignDomain().loadModel(dsbId);
        InputStream dbStream = this.getDashboardDao().loadDashboardStream(dsbId);
        byte[] boxBytes = DashboardSerializationUtil.toBytes(dashboardModel, null, dbStream);
        String dsbModelTempFileName = ImExportUtil.writeBytesToExportTempFile(boxBytes);
        dashboardObj.setDsbModelFileName(dsbModelTempFileName);
        ArrayList<DsbRefObject> dsbRefObjs = new ArrayList<DsbRefObject>(10);
        List<ReferenceMap> references = this.getDashboardDao().getRefList(dsbId);
        dashboardModel.fixReferences(references);
        List referenceMaps = dashboardModel.pickReferences();
        int c = referenceMaps.size();
        for (int i = 0; i < c; ++i) {
            String refToId;
            String refType;
            String fullPath;
            String uid;
            ReferenceMap referenceMap;
            block15: {
                referenceMap = (ReferenceMap)referenceMaps.get(i);
                uid = referenceMap.getUid();
                fullPath = referenceMap.getRefToFullPath();
                refType = referenceMap.getRefType();
                refToId = referenceMap.getRefToId();
                IRefHandler refHandler = this.getDashboardDesignDomain().getRefHandler(RefTypeEnum.valueOf((String)refType));
                ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
                if (switchPathAndIdHandler != null) {
                    String fullPathAfterSwitch = switchPathAndIdHandler.switchRefIdToPath(refToId, userId);
                    if (fullPathAfterSwitch != null) {
                        fullPath = fullPathAfterSwitch;
                    } else {
                        try {
                            fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
                            JsonUtil.decodeFromString((String)fullPath, PathModel.class);
                        }
                        catch (Exception e) {
                            String[] path = StringUtils.split((String)fullPath, (char)'/');
                            if (path == null || path.length < 3) break block15;
                            PathModel pathModel = new PathModel();
                            pathModel.setNameSpace(path[0]);
                            pathModel.setGroupName(path[1]);
                            pathModel.setName(path[2]);
                            fullPath = JsonUtil.encodeToString((Object)pathModel);
                        }
                    }
                }
            }
            referenceMap.setRefToFullPath(fullPath);
            String fId = (String)referenceMap.get((Object)"id");
            List<OutsideReference> outerRefs = this.getDashboardDao().loadSchemaRef(fId);
            byte[] refSchemaContent = this.getDashboardDesignDomain().loadShemaContent(uid, dsbId);
            DsbRefObject dsbRef = new DsbRefObject();
            dsbRef.setReferenceMap(referenceMap);
            if (RefTypeEnum.valueOf((String)referenceMap.getRefType()) != RefTypeEnum.picture && refSchemaContent != null) {
                String refSchemaContentFileName = ImExportUtil.writeBytesToExportTempFile(refSchemaContent);
                dsbRef.setRefSchemaContentFileName(refSchemaContentFileName);
            }
            String uniqueKey = QHFDsbUtil.getRefUniqueKey(dsbId, false, uid);
            String refTag = QingSessionUtil.get((String)uniqueKey);
            List executeTraceSpans = TraceSpansCacheUtil.getCacheTraceSpans((String)refTag, (TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE);
            dsbRef.setExecuteTraceSpans(executeTraceSpans);
            List joinTraceSpans = TraceSpansCacheUtil.getCacheTraceSpans((String)refTag, (TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.JOIN);
            dsbRef.setJoinTraceSpans(joinTraceSpans);
            if (outerRefs != null && !outerRefs.isEmpty()) {
                for (int k = 0; k < outerRefs.size(); ++k) {
                    OutsideReference outsideReference = outerRefs.get(k);
                    String mapId = outsideReference.getRefToId();
                    PathModel pathModel = new PathModel();
                    if (mapId != null) {
                        ExportMapModel mapVO = this.getMapManageDao().loadMapWithGroupName(mapId);
                        if (mapVO != null) {
                            pathModel.setNameSpace(NameSpace.user.toPersistance());
                            pathModel.setGroupName(mapVO.getMapGroupName());
                            pathModel.setName(mapVO.getMapName());
                            outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                        }
                        meta.getResources().getMapIds().add(mapId);
                        continue;
                    }
                    try {
                        JsonUtil.decodeFromString((String)outsideReference.getRefToFullPath(), PathModel.class);
                        continue;
                    }
                    catch (Exception e) {
                        String[] path = StringUtils.split((String)outsideReference.getRefToFullPath(), (char)'/');
                        if (path.length < 3) continue;
                        pathModel.setNameSpace(path[0]);
                        pathModel.setGroupName(path[1]);
                        pathModel.setName(path[2]);
                        outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                    }
                }
                dsbRef.setOuterRefs(outerRefs);
            }
            if (RefTypeEnum.valueOf((String)refType) == RefTypeEnum.picture && refToId != null) {
                meta.getResources().getPictureFileNames().add(refToId);
            }
            dsbRefObjs.add(dsbRef);
        }
        dashboardObj.setDsbRefObjs(dsbRefObjs);
        meta.getDashboardObjs().add(dashboardObj);
        this.exprotSource(dashboardModel.pickReferences(), dsbId, meta);
    }

    private void exprotSource(List<ReferenceMap> referenceMapList, String dsbId, PackageMeta packageMeta) throws SQLException, AbstractQingException, IOException, JDOMException {
        IRefHandler refHandler;
        RefTypeEnum refTypeEnum;
        String refType;
        Map<String, ReferenceMap> uniqueRefSourceMap = this.getUniqueRefSourceMap(referenceMapList);
        for (Map.Entry<String, ReferenceMap> refTagEntry : uniqueRefSourceMap.entrySet()) {
            ReferenceMap referenceMap = uniqueRefSourceMap.get(refTagEntry.getKey());
            String uid = referenceMap.getUid();
            refType = referenceMap.getRefType();
            refTypeEnum = RefTypeEnum.valueOf((String)refType);
            refHandler = this.getDashboardDesignDomain().getRefHandler(refTypeEnum);
            if (!(refHandler instanceof IExImportable)) continue;
            String refTag = QHFDsbUtil.getRefUniqueKey(dsbId, false, uid);
            String tag = QingSessionUtil.get((String)refTag);
            ((IExImportable)((Object)refHandler)).exportSource(tag, referenceMap, packageMeta);
        }
        List<ReferenceMap> needExportPublishInfoRefList = ImExportUtil.getNeedExportPublishInfoRefList(uniqueRefSourceMap, referenceMapList);
        for (ReferenceMap referenceMap : needExportPublishInfoRefList) {
            String refToId = referenceMap.getRefToId();
            if (!PublishUtil.isPublish((String)refToId) || (refType = referenceMap.getRefType()).equals(RefTypeEnum.qingcenter_rpt.toPersistance()) || refType.equals(RefTypeEnum.appmenu_rpt.toPersistance())) continue;
            refTypeEnum = RefTypeEnum.valueOf((String)refType);
            refHandler = this.getDashboardDesignDomain().getRefHandler(refTypeEnum);
            if (!(refHandler instanceof IExImportable)) continue;
            PublishLongerSquareQHFExporter publishLongerSquareQHFExporter = new PublishLongerSquareQHFExporter(this.qingContext, this.dbExcuter, this.tx);
            publishLongerSquareQHFExporter.exportPublishInfo(refToId, packageMeta);
        }
    }

    private Map<String, ReferenceMap> getUniqueRefSourceMap(List<ReferenceMap> referenceMapList) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, ReferenceMap> uniqueRefSourceMap = new HashMap<String, ReferenceMap>();
        for (ReferenceMap referenceMap : referenceMapList) {
            String refTag;
            String refType = referenceMap.getRefType();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            IRefHandler refHandler = this.getDashboardDesignDomain().getRefHandler(refTypeEnum);
            if (!(refHandler instanceof IPrepareDataable) || (refTag = ((IPrepareDataable)((Object)refHandler)).getPrepareDataTag("", referenceMap.getRefToId())) == null) continue;
            if (refTag.startsWith("_" + PublishSourceEnum.bill.name())) {
                refTag = referenceMap.getUid() + refTag;
            }
            if (uniqueRefSourceMap.containsKey(refTag) && refTypeEnum == RefTypeEnum.subject) continue;
            uniqueRefSourceMap.put(refTag, referenceMap);
        }
        return uniqueRefSourceMap;
    }
}

