/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpansCacheUtil;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.domain.DashboardDesignDomain;
import com.kingdee.bos.qing.dashboard.domain.DashboardRuntimeDomain;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.AbstractPublishQHFExporter;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishLongerSquareQHFExporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.imexport.util.QHFDsbUtil;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.ThemeNotFoundException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class PublishDsbQHFExporter
extends AbstractPublishQHFExporter {
    private DashboardRuntimeDomain dashboardRuntimeDomain;
    private IThemeDao iThemeDao;
    private IThemeGroupDao themeGroupDao;
    private DashboardDesignDomain dashboardDesignDomain;
    private MapManageDao mapManageDao;

    public PublishDsbQHFExporter(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    private DashboardRuntimeDomain getDashboardRuntimeDomain() {
        if (this.dashboardRuntimeDomain == null) {
            this.dashboardRuntimeDomain = new DashboardRuntimeDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.dashboardRuntimeDomain;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private IThemeGroupDao getThemeGroupDao() {
        if (this.themeGroupDao == null) {
            this.themeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.themeGroupDao;
    }

    private DashboardDesignDomain getDashboardDesignDomain() {
        if (this.dashboardDesignDomain == null) {
            this.dashboardDesignDomain = new DashboardDesignDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.dashboardDesignDomain;
    }

    @Override
    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    @Override
    public void exportPublishSource(PublishPO publishPO, Map<String, String> params, String tag, AbstractPublishObject publishObj, PackageMeta meta) throws SQLException, IOException, AbstractQingException, JDOMException {
        String publishId = publishPO.getId();
        DashboardModel dashboardModel = this.getDashboardRuntimeDomain().loadDsbModel(publishId);
        DsbPublishObject dsbPublishObj = (DsbPublishObject)publishObj;
        Element dashboardModelElement = dashboardModel.toXml();
        String dsbModelTempFileName = ImExportUtil.writeXmlToExportTempFile(dashboardModelElement);
        dsbPublishObj.setDsbModelFileName(dsbModelTempFileName);
        ArrayList<DsbRefObject> dsbRefObjs = new ArrayList<DsbRefObject>(10);
        List<ReferenceMap> references = this.getDashboardRuntimeDomain().getRefList(publishId);
        dashboardModel.fixReferences(references);
        List referenceMaps = dashboardModel.pickReferences();
        int c = referenceMaps.size();
        for (int i = 0; i < c; ++i) {
            List<SchemaObject> analysisSchemaObjects;
            String refToId;
            String refType;
            String fullPath;
            String uid;
            ReferenceMap referenceMap;
            block15: {
                referenceMap = (ReferenceMap)referenceMaps.get(i);
                uid = referenceMap.getUid();
                fullPath = referenceMap.getRefToFullPath();
                refType = referenceMap.getRefType();
                refToId = referenceMap.getRefToId();
                IRefHandler refHandler = this.getDashboardDesignDomain().getRefHandler(RefTypeEnum.valueOf((String)refType));
                ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
                if (switchPathAndIdHandler != null) {
                    String fullPathAfterSwitch = switchPathAndIdHandler.switchRefIdToPath(refToId, publishPO.getCreatorId());
                    if (fullPathAfterSwitch != null) {
                        fullPath = fullPathAfterSwitch;
                    } else {
                        try {
                            fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
                            JsonUtil.decodeFromString((String)fullPath, PathModel.class);
                        }
                        catch (Exception e) {
                            String[] path = StringUtils.split((String)fullPath, (char)'/');
                            if (path.length < 3) break block15;
                            PathModel pathModel = new PathModel();
                            pathModel.setNameSpace(path[0]);
                            pathModel.setGroupName(path[1]);
                            pathModel.setName(path[2]);
                            fullPath = JsonUtil.encodeToString((Object)pathModel);
                        }
                    }
                }
            }
            referenceMap.setRefToFullPath(fullPath);
            String fId = (String)referenceMap.get((Object)"id");
            List<OutsideReference> outerRefs = this.getDashboardRuntimeDomain().loadOutsideReferences(fId);
            byte[] refSchemaContent = this.getDashboardRuntimeDomain().selectRefContent(publishId, referenceMap);
            DsbRefObject dsbRefObject = new DsbRefObject();
            dsbRefObject.setReferenceMap(referenceMap);
            if (refSchemaContent != null && RefTypeEnum.valueOf((String)referenceMap.getRefType()) != RefTypeEnum.picture) {
                String refSchemaContentFileName = ImExportUtil.writeBytesToExportTempFile(refSchemaContent);
                dsbRefObject.setRefSchemaContentFileName(refSchemaContentFileName);
            }
            String uniqueKey = QHFDsbUtil.getRefUniqueKey(publishId, true, uid);
            String refTag = QingSessionUtil.get((String)uniqueKey);
            List executeTraceSpans = TraceSpansCacheUtil.getCacheTraceSpans((String)refTag, (TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE);
            dsbRefObject.setExecuteTraceSpans(executeTraceSpans);
            List joinTraceSpans = TraceSpansCacheUtil.getCacheTraceSpans((String)refTag, (TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.JOIN);
            dsbRefObject.setJoinTraceSpans(joinTraceSpans);
            if (outerRefs != null && !outerRefs.isEmpty()) {
                for (int k = 0; k < outerRefs.size(); ++k) {
                    OutsideReference outsideReference = outerRefs.get(k);
                    String mapId = outsideReference.getRefToId();
                    PathModel pathModel = new PathModel();
                    if (mapId != null) {
                        ExportMapModel mapVO = this.getMapManageDao().loadMapWithGroupName(mapId);
                        if (mapVO != null) {
                            pathModel.setNameSpace(NameSpace.user.toPersistance());
                            pathModel.setGroupName(mapVO.getMapGroupName());
                            pathModel.setName(mapVO.getMapName());
                            outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                        }
                        meta.getResources().getMapIds().add(mapId);
                        continue;
                    }
                    try {
                        JsonUtil.decodeFromString((String)outsideReference.getRefToFullPath(), PathModel.class);
                        continue;
                    }
                    catch (Exception e) {
                        String[] path = StringUtils.split((String)outsideReference.getRefToFullPath(), (char)'/');
                        if (path.length < 3) continue;
                        pathModel.setNameSpace(path[0]);
                        pathModel.setGroupName(path[1]);
                        pathModel.setName(path[2]);
                        outsideReference.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
                    }
                }
                dsbRefObject.setOuterRefs(outerRefs);
            }
            if (RefTypeEnum.valueOf((String)refType) == RefTypeEnum.picture && refToId != null) {
                meta.getResources().getPictureFileNames().add(refToId);
            }
            if (RefTypeEnum.valueOf((String)refType) != RefTypeEnum.picture && RefTypeEnum.valueOf((String)refType) != RefTypeEnum.map && CollectionUtils.isNotEmpty(analysisSchemaObjects = this.getDBSchema(fId, meta))) {
                dsbRefObject.setAnalysisSchemaObjects(analysisSchemaObjects);
            }
            dsbRefObjs.add(dsbRefObject);
        }
        dsbPublishObj.setDsbRefObjs(dsbRefObjs);
        meta.getPublishObjs().add(dsbPublishObj);
        this.exportDsbSourceInfo(publishPO.getTagId(), meta);
        this.exportDsbRefSource(dashboardModel.pickReferences(), publishId, meta);
    }

    @Override
    public AbstractPublishObject getPublishObj(PublishPO publishPO) {
        return new DsbPublishObject();
    }

    private void exportDsbSourceInfo(String dsbId, PackageMeta meta) throws AbstractQingIntegratedException, SQLException, ThemeNotFoundException {
        ThemePO themePO = this.getThemeDao().getThemeByID(dsbId);
        if (themePO == null) {
            return;
        }
        DashboardObject dashboardObject = new DashboardObject();
        dashboardObject.setThemeVO(themePO.toVo());
        ThemeGroupVO themeGroupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(themePO.getUserID(), themePO.getGroupID());
        dashboardObject.setThemeGroupVO(themeGroupVO);
        meta.getDashboardObjs().add(dashboardObject);
    }

    private void exportDsbRefSource(List<ReferenceMap> referenceMapList, String publishId, PackageMeta packageMeta) throws SQLException, AbstractQingException, IOException, JDOMException {
        IRefHandler refHandler;
        RefTypeEnum refTypeEnum;
        String refType;
        Map<String, ReferenceMap> uniqueRefSourceMap = this.getUniqueRefSourceMap(referenceMapList);
        for (Map.Entry<String, ReferenceMap> refTagEntry : uniqueRefSourceMap.entrySet()) {
            ReferenceMap referenceMap = uniqueRefSourceMap.get(refTagEntry.getKey());
            String uid = referenceMap.getUid();
            refType = referenceMap.getRefType();
            refTypeEnum = RefTypeEnum.valueOf((String)refType);
            refHandler = this.getDashboardRuntimeDomain().getRefHandler(refTypeEnum);
            if (!(refHandler instanceof IExImportable)) continue;
            String refTag = QHFDsbUtil.getRefUniqueKey(publishId, true, uid);
            String tag = QingSessionUtil.get((String)refTag);
            ((IExImportable)((Object)refHandler)).exportSource(tag, referenceMap, packageMeta);
        }
        List<ReferenceMap> needExportPublishInfoRefList = ImExportUtil.getNeedExportPublishInfoRefList(uniqueRefSourceMap, referenceMapList);
        for (ReferenceMap referenceMap : needExportPublishInfoRefList) {
            String refToId = referenceMap.getRefToId();
            if (!PublishUtil.isPublish((String)refToId) || (refType = referenceMap.getRefType()).equals(RefTypeEnum.qingcenter_rpt.toPersistance()) || refType.equals(RefTypeEnum.appmenu_rpt.toPersistance())) continue;
            refTypeEnum = RefTypeEnum.valueOf((String)refType);
            refHandler = this.getDashboardDesignDomain().getRefHandler(refTypeEnum);
            if (!(refHandler instanceof IExImportable)) continue;
            PublishLongerSquareQHFExporter publishLongerSquareQHFExporter = new PublishLongerSquareQHFExporter(this.qingContext, this.dbExcuter, this.tx);
            publishLongerSquareQHFExporter.exportPublishInfo(refToId, packageMeta);
        }
    }

    private Map<String, ReferenceMap> getUniqueRefSourceMap(List<ReferenceMap> referenceMapList) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, ReferenceMap> uniqueRefSourceMap = new HashMap<String, ReferenceMap>();
        for (ReferenceMap referenceMap : referenceMapList) {
            String refTag;
            String refType = referenceMap.getRefType();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            IRefHandler refHandler = this.getDashboardRuntimeDomain().getRefHandler(refTypeEnum);
            if (!(refHandler instanceof IPrepareDataable) || (refTag = ((IPrepareDataable)((Object)refHandler)).getPrepareDataTag("", referenceMap.getRefToId())) == null) continue;
            if (refTag.startsWith("_" + PublishSourceEnum.bill.name())) {
                refTag = referenceMap.getUid() + refTag;
            }
            if (uniqueRefSourceMap.containsKey(refTag) && refTypeEnum == RefTypeEnum.subject) continue;
            uniqueRefSourceMap.put(refTag, referenceMap);
        }
        return uniqueRefSourceMap;
    }
}

