/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.common;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingEncryptedStreamUtil;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.importer.exception.ImportMetaFileException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportMetaTypeException;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.MetaTypeEnum;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class AbstractImportDomain {
    protected abstract Map<String, String> doImport(String var1) throws SQLException, AbstractQingException, IOException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ImportedModel parseZipFile(String fileName, MetaTypeEnum metaTypeEnum) throws Throwable {
        ImportedModel importedModel;
        ZipInputStream zis;
        QingInputStream in;
        block19: {
            Map<String, String> tempFileMap;
            in = null;
            zis = null;
            ImportedModel importedModel2 = null;
            Object exception = null;
            try {
                importedModel2 = new ImportedModel();
                IQingFileVisitor zipFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
                in = zipFile.getInputStream();
                zis = QingEncryptedStreamUtil.createZipInputStream((InputStream)in);
                ZipEntry zipEntry = zis.getNextEntry();
                if (!zipEntry.getName().endsWith("package-meta.xml")) {
                    throw new ImportMetaFileException();
                }
                PackageMeta packageMeta = new PackageMeta();
                Element mateXmlElement = XmlUtil.loadRootElement((InputStream)ImportUtil.getInputStreamFromZipInputStream(zis));
                packageMeta.fromXml(mateXmlElement);
                importedModel2.setPackageMeta(packageMeta);
                String type = packageMeta.getType();
                if (!metaTypeEnum.name().equals(type)) {
                    throw new ImportMetaTypeException();
                }
                while ((zipEntry = zis.getNextEntry()) != null) {
                    String[] zipEntryPath = ImExportUtil.parseEntryNameToList(zipEntry.getName());
                    String zipEntryFileName = zipEntryPath[zipEntryPath.length - 1];
                    QingTempFileType qingTempFileType = QingTempFileType.UPLOAD;
                    if (zipEntryFileName.endsWith(".qs")) {
                        qingTempFileType = QingTempFileType.TEMP_QS;
                    }
                    byte[] bytes = ImportUtil.getBytesFromZipInputStream(zis);
                    IQingFile tempFile = FileFactory.newTempFile((QingTempFileType)qingTempFileType);
                    tempFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(bytes), false), true);
                    importedModel2.getTempFileMap().put(zipEntryFileName, tempFile.getName());
                }
                importedModel = importedModel2;
                if (exception == null) break block19;
            }
            catch (IOException e) {
                try {
                    exception = e;
                    throw e;
                    catch (ImportMetaFileException e2) {
                        exception = e2;
                        throw e2;
                    }
                    catch (JDOMException e3) {
                        exception = e3;
                        throw e3;
                    }
                    catch (ModelParseException e4) {
                        exception = e4;
                        throw e4;
                    }
                    catch (Throwable e5) {
                        exception = e5;
                        throw e5;
                    }
                }
                catch (Throwable throwable) {
                    if (exception != null) {
                        Map<String, String> tempFileMap2;
                        FileFactory.clearTempFile((QingTempFileType)QingTempFileType.UPLOAD, (String)fileName);
                        if (importedModel2 != null && (tempFileMap2 = importedModel2.getTempFileMap()) != null) {
                            for (Map.Entry<String, String> zipFileEntry : tempFileMap2.entrySet()) {
                                QingTempFileType qingTempFileType = QingTempFileType.UPLOAD;
                                if (zipFileEntry.getKey().endsWith(".qs")) {
                                    qingTempFileType = QingTempFileType.TEMP_QS;
                                }
                                FileFactory.clearTempFile((QingTempFileType)qingTempFileType, (String)zipFileEntry.getValue());
                            }
                        }
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{zis});
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
            }
            FileFactory.clearTempFile((QingTempFileType)QingTempFileType.UPLOAD, (String)fileName);
            if (importedModel2 != null && (tempFileMap = importedModel2.getTempFileMap()) != null) {
                for (Map.Entry<String, String> zipFileEntry : tempFileMap.entrySet()) {
                    QingTempFileType qingTempFileType = QingTempFileType.UPLOAD;
                    if (zipFileEntry.getKey().endsWith(".qs")) {
                        qingTempFileType = QingTempFileType.TEMP_QS;
                    }
                    FileFactory.clearTempFile((QingTempFileType)qingTempFileType, (String)zipFileEntry.getValue());
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        CloseUtil.close((Closeable[])new Closeable[]{in});
        return importedModel;
    }
}

