/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.publish;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imagelibrary.exception.GroupDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageFileSizeLimitException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageTypeException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportDashboardPublishException;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.source.MapImporter;
import com.kingdee.bos.qing.imexport.importer.pkg.source.PictureImporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.dashboard.DsbRefObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DashboardQsInfo;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbDataModelObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToLapp;
import com.kingdee.bos.qing.imexport.strategy.IQHFStrategy;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PermissionObject;
import com.kingdee.bos.qing.publish.model.PermissionTypeEnum;
import com.kingdee.bos.qing.publish.model.PublishDashboardModel;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsObject;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetImexportDomainFactory;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom2.JDOMException;

public class DashboardPublishImporter {
    private static final String CACHED_PUBLISHID_SUFFIX = "publishDsb";
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MapImporter mapImporter;
    private PictureImporter pictureImporter;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private MapManageDomain mapManageDomain;
    private ImportPKGDomain.IPublishInfoCollector publishInfoCollector;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private MapImporter getMapImporter() {
        if (this.mapImporter == null) {
            this.mapImporter = new MapImporter();
            this.mapImporter.setDbExcuter(this.dbExcuter);
            this.mapImporter.setQingContext(this.qingContext);
            this.mapImporter.setTx(this.tx);
        }
        return this.mapImporter;
    }

    private PictureImporter getPictureImporter() {
        if (this.pictureImporter == null) {
            this.pictureImporter = new PictureImporter();
            this.pictureImporter.setDbExcuter(this.dbExcuter);
            this.pictureImporter.setQingContext(this.qingContext);
            this.pictureImporter.setTx(this.tx);
        }
        return this.pictureImporter;
    }

    private MapManageDomain getMapManageDomain() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    public void registerPublishInfoCollector(ImportPKGDomain.IPublishInfoCollector publishInfoCollector) {
        this.publishInfoCollector = publishInfoCollector;
    }

    public void doImport(ImportParamModel importParamModel, ThemeVO themeVO, String oldDsbId, boolean overWrite, List<DsbPublishObject> lappDsbPublishObjects) throws ImportDashboardPublishException, ImageFileSizeLimitException {
        PackageMeta meta = importParamModel.getPackageMeta();
        List<AbstractPublishObject> publishObjs = meta.getPublishObjs();
        try {
            Collections.sort(publishObjs, new Comparator<AbstractPublishObject>(){

                @Override
                public int compare(AbstractPublishObject object1, AbstractPublishObject object2) {
                    int object1Size = 0;
                    int object2Size = 0;
                    if (object1.getPublishPO() != null && object1.getPublishPO().getParentPublishIdFullPath() != null) {
                        object1Size = object1.getPublishPO().getParentPublishIdFullPath().length();
                    }
                    if (object2.getPublishPO() != null && object2.getPublishPO().getParentPublishIdFullPath() != null) {
                        object2Size = object2.getPublishPO().getParentPublishIdFullPath().length();
                    }
                    return object1Size - object2Size;
                }
            });
            for (AbstractPublishObject dsbPublishObject : publishObjs) {
                PublishPO publishPO = dsbPublishObject.getPublishPO();
                String sourceId = publishPO.getTagId();
                if (!oldDsbId.equals(sourceId)) continue;
                publishPO.setOverwrite(overWrite);
                publishPO.setTagId(themeVO.getThemeID());
                String newPublishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
                importParamModel.getNewPublishIdMap().put(publishPO.getId(), newPublishId);
                int publishType = dsbPublishObject.getPublishTarget().getTargetType();
                String productName = importParamModel.getPackageMeta().getEnvironment().getProduct().getName();
                if (publishType == 2) {
                    PublishToLapp PublishToLapp2 = (PublishToLapp)dsbPublishObject.getPublishTarget();
                    PublishToLapp2.setThemeType("1");
                    PublishToLapp2.setThemeName(themeVO.getThemeName());
                    lappDsbPublishObjects.add((DsbPublishObject)dsbPublishObject);
                    continue;
                }
                if (publishType == 0) {
                    IQHFStrategy qhfStrategy = (IQHFStrategy)CustomStrategyRegistrar.getStrategy(IQHFStrategy.class);
                    if (qhfStrategy == null) {
                        throw new RuntimeException("cannot found the implement of IQHFStrategy.");
                    }
                    if (!qhfStrategy.getProductName(productName).equals(productName)) continue;
                }
                this.savePublish(dsbPublishObject, themeVO, importParamModel);
            }
        }
        catch (ImageFileSizeLimitException e) {
            if (this.publishInfoCollector != null) {
                this.publishInfoCollector.clear();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.publishInfoCollector != null) {
                this.publishInfoCollector.clear();
            }
            throw new ImportDashboardPublishException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePublish(AbstractPublishObject lappDsbPublishObject, ThemeVO dsbVO, ImportParamModel importParamModel) throws ImportThemeException, GroupDuplicateNameException, ImageTypeException, ImageFileSizeLimitException, PersistentModelParseException, MapException, AbstractQingIntegratedException, SQLException, IOException, JDOMException, PublishException, EncryptedLicenseCheckException, ModelParseException {
        block23: {
            List<IQingFile> successImportFiles = importParamModel.getSuccessImportFiles();
            List<PermissionObject> permissionObjs = lappDsbPublishObject.getPermissionObjs();
            PublishTarget publishTarget = lappDsbPublishObject.getPublishTarget();
            ArrayList<PermissionInfo> permInfos = new ArrayList<PermissionInfo>();
            PublishPO publishPO = lappDsbPublishObject.getPublishPO();
            String exportPublishId = publishPO.getId();
            String publishId = importParamModel.getNewPublishIdMap().get(exportPublishId);
            String needOverwritePublishId = importParamModel.getNeedOverwritePublishId().get(publishId);
            List<PublishOperPermissionsObject> publishOperPermissionsObjects = lappDsbPublishObject.getPublishOperPermissionsObjects();
            HashMap<String, Integer> noOperValueMap = new HashMap<String, Integer>(16);
            publishPO.setId(publishId);
            if (permissionObjs != null) {
                for (int i = 0; i < permissionObjs.size(); ++i) {
                    Object userName;
                    PermissionInfo permissionInfo = permissionObjs.get(i).getPermissionInfo();
                    int permissionType = permissionInfo.getType();
                    String viewId = permissionInfo.getViewerId();
                    if (permissionType == PermissionTypeEnum.role.getType()) {
                        String roleName = IntegratedHelper.getRoleName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)viewId);
                        if (roleName == null) continue;
                        PermissionInfo rolePermissionInfo = new PermissionInfo();
                        String roleUuid = UUID.randomUUID().toString();
                        rolePermissionInfo.setCreateTime(new Date());
                        rolePermissionInfo.setId(roleUuid);
                        rolePermissionInfo.setPublishId(publishId);
                        rolePermissionInfo.setType(1);
                        rolePermissionInfo.setViewerId(viewId);
                        permInfos.add(rolePermissionInfo);
                        continue;
                    }
                    if (permissionType != PermissionTypeEnum.user.getType() || (userName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)viewId)) == null) continue;
                    PermissionInfo userPermissionInfo = new PermissionInfo();
                    String[] userUuid = UUID.randomUUID().toString();
                    userPermissionInfo.setCreateTime(new Date());
                    userPermissionInfo.setId((String)userUuid);
                    userPermissionInfo.setPublishId(publishId);
                    userPermissionInfo.setType(0);
                    userPermissionInfo.setViewerId(viewId);
                    permInfos.add(userPermissionInfo);
                }
            }
            if (publishOperPermissionsObjects != null) {
                for (PublishOperPermissionsObject publishOperPermissionsObject : publishOperPermissionsObjects) {
                    noOperValueMap.put(publishOperPermissionsObject.getPublishOperPermissionsPO().getType(), publishOperPermissionsObject.getPublishOperPermissionsPO().getNoOperAuthValue());
                }
            }
            PublishPO newPublishPO = new PublishPO();
            DsbPublishObject dsbPublishObject = (DsbPublishObject)lappDsbPublishObject;
            PublishDashboardModel publishDashboardModel = this.getImportDashboardSource(importParamModel, dsbPublishObject, publishId);
            AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, null, publishTarget.getTargetType());
            if (publishTargetImexportDomain != null) {
                newPublishPO = publishTargetImexportDomain.loadNewPublishPO(publishTarget, importParamModel.getTempFile());
            }
            newPublishPO.setCreatorId(this.qingContext.getUserId());
            newPublishPO.setCreateTime(new Date());
            newPublishPO.setUpdateTime(new Date());
            newPublishPO.setSchemaId("currentAnalysisState");
            newPublishPO.setImport(true);
            newPublishPO.setTagId(publishPO.getTagId());
            newPublishPO.setTimingPush(false);
            if (IntegratedHelper.getPresetUserId().equals(this.qingContext.getUserId())) {
                newPublishPO.setId(exportPublishId);
                for (PermissionInfo permissionInfo : permInfos) {
                    permissionInfo.setPublishId(exportPublishId);
                }
            } else {
                newPublishPO.setId(publishId);
            }
            newPublishPO.setOverwrite(publishPO.isOverwrite());
            newPublishPO.setAddOldPermission(false);
            newPublishPO.setPublishTargetType(publishTarget.getTargetType());
            newPublishPO.setCanAnalysis(publishPO.isCanAnalysis());
            newPublishPO.setCarryData(publishPO.isCarryData());
            newPublishPO.setName(publishPO.getName());
            newPublishPO.setPublishSourceType(publishPO.getPublishSourceType());
            newPublishPO.setFailedUserIds(publishPO.getFailedUserIds());
            newPublishPO.setNoOperValueMap(noOperValueMap);
            if (!publishPO.isOverwrite() && publishPO.getParentPublishIdFullPath() != null) {
                String[] oldParentPublishIds = publishPO.getParentPublishIdFullPath().split(",");
                ArrayList<String> newParentPublishIdFullPath = new ArrayList<String>(oldParentPublishIds.length);
                for (String oldParentPublishId : oldParentPublishIds) {
                    if (importParamModel.getOverwriteFinalPublishIdMap().get(oldParentPublishId) == null) continue;
                    newParentPublishIdFullPath.add(importParamModel.getOverwriteFinalPublishIdMap().get(oldParentPublishId));
                }
                newPublishPO.setParentPublishIdFullPath(StringUtils.join((Object[])newParentPublishIdFullPath.toArray(), (char)','));
            }
            if (publishPO.isCarryData()) {
                HashMap<String, String> executingTagMap = new HashMap<String, String>(16);
                if (lappDsbPublishObject.getCarryDataInfo() != null) {
                    DsbCarryDataInfo dsbCarryDataInfo = (DsbCarryDataInfo)lappDsbPublishObject.getCarryDataInfo();
                    this.cachePublishCarryData(executingTagMap, importParamModel, publishDashboardModel, dsbCarryDataInfo);
                }
                newPublishPO.setExecutingTagMap(executingTagMap);
            }
            AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)publishTarget.getTargetType(), (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
            try {
                if (publishManageDomain == null) break block23;
                ArrayList<PublishDashboardModel> abstractPublishSourceModelList = new ArrayList<PublishDashboardModel>(1);
                abstractPublishSourceModelList.add(publishDashboardModel);
                String finalPublishId = publishManageDomain.savePublishInfoNotTx(null, newPublishPO, permInfos, abstractPublishSourceModelList, successImportFiles, needOverwritePublishId, null);
                importParamModel.getOverwriteFinalPublishIdMap().put(exportPublishId, finalPublishId);
                if (this.publishInfoCollector == null) break block23;
                this.publishInfoCollector.collectPublishInfo(exportPublishId, newPublishPO);
            }
            catch (PublishNameDuplicateException e) {
                if (publishTargetImexportDomain != null) {
                    publishTargetImexportDomain.doPublishNameDuplicate(importParamModel.getConfilctPublishList(), dsbVO, publishTarget.getPath(), newPublishPO.getName());
                }
            }
            catch (PublishSameSourceNameDuplicateException e) {
                if (publishTargetImexportDomain != null) {
                    publishTargetImexportDomain.doPublishNameDuplicate(importParamModel.getConfilctPublishList(), dsbVO, publishTarget.getPath(), newPublishPO.getName());
                }
            }
            finally {
                Map executingTagMap = newPublishPO.getExecutingTagMap();
                if (executingTagMap == null) break block23;
                for (Map.Entry entry : executingTagMap.entrySet()) {
                    String cacheKey = "Qing.Datasource." + (String)entry.getValue();
                    QingSessionUtil.remove((String)cacheKey);
                }
            }
        }
    }

    private void cachePublishCarryData(Map<String, String> executingTagMap, ImportParamModel importParamModel, PublishDashboardModel publishDashboardModel, DsbCarryDataInfo dsbCarryDataInfo) throws IOException, AbstractQingIntegratedException, SQLException, ModelParseException, EncryptedLicenseCheckException {
        DashboardQsInfo dashboardQsInfo = dsbCarryDataInfo.getDashboardQsInfo();
        Map<String, String> tempFile = importParamModel.getTempFile();
        HashMap<String, HashMap<String, String>> qsMap = new HashMap<String, HashMap<String, String>>(16);
        HashMap<String, Long> subjectUidMap = new HashMap<String, Long>(16);
        List<Map<String, String>> subjectQsList = dashboardQsInfo.getSubjectQsList();
        List<Map<String, String>> billQsList = dashboardQsInfo.getBillQsList();
        for (Map<String, String> map : subjectQsList) {
            String refUid = map.get("refUid");
            subjectUidMap.put(refUid, Long.valueOf(map.get("extractTimestamp")));
            HashMap<String, String> qs = (HashMap<String, String>)qsMap.get(refUid);
            if (qs == null) {
                qs = new HashMap<String, String>(16);
            }
            qs.put(map.get("entityName"), tempFile.get(map.get("file")));
            qsMap.put(refUid, qs);
        }
        List<DsbDataModelObject> dsbDataModelObjects = dsbCarryDataInfo.getDsbDataModelObjects();
        DashboardModel dsbModel = publishDashboardModel.getDsbModel();
        List referenceMaps = dsbModel.pickReferences();
        for (ReferenceMap referenceMap : referenceMaps) {
            String uid = referenceMap.getUid();
            String tag = UUID.randomUUID().toString();
            if (subjectUidMap.get(uid) != null) {
                for (DsbDataModelObject dsbDataModelObject : dsbDataModelObjects) {
                    String boxFileName;
                    InputStream boxOrignalStream;
                    if (!uid.equals(dsbDataModelObject.getRefUid()) || (boxOrignalStream = BoxUtil.getBoxStreamByFileName(boxFileName = importParamModel.getTempFile().get(dsbDataModelObject.getBoxFileName()), (AbstractQingFileType)QingTempFileType.UPLOAD)) == null) continue;
                    Box box = BoxSerializationUtil.toModel(boxOrignalStream, true);
                    ThemeDataSource themeDataSource = new ThemeDataSource();
                    themeDataSource.setOriginalCreatorId(this.qingContext.getUserId());
                    themeDataSource.setTag(tag);
                    themeDataSource.setBox(box);
                    themeDataSource.setDataFiles((Map)qsMap.get(uid));
                    themeDataSource.setExtractDataTime((Long)subjectUidMap.get(uid));
                    QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
                    executingTagMap.put(uid, tag);
                }
                continue;
            }
            for (Map map : billQsList) {
                if (!uid.equals(map.get("refUid"))) continue;
                SingleFileDataSource dataSource = new SingleFileDataSource(tempFile.get(map.get("file")), (AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS);
                dataSource.setTag(tag);
                dataSource.setOriginalCreatorId(this.qingContext.getUserId());
                dataSource.setLastVisitTime(System.currentTimeMillis());
                dataSource.setExtractDataTime(Long.parseLong((String)map.get("extractTimestamp")));
                QingSessionUtil.setCache((ISessionCacheable)dataSource);
                executingTagMap.put(uid, tag);
            }
        }
    }

    public PublishDashboardModel getImportDashboardSource(ImportParamModel importParamModel, DsbPublishObject dsbPublishObj, String publishId) throws AbstractQingIntegratedException, ImportThemeException, MapException, SQLException, GroupDuplicateNameException, ImageTypeException, ImageFileSizeLimitException, IOException, PersistentModelParseException, JDOMException, EncryptedLicenseCheckException {
        Map<String, String> importIds = importParamModel.getImportIds();
        List<DsbRefObject> dsbRefObjs = dsbPublishObj.getDsbRefObjs();
        ArrayList<ReferenceMap> refList = new ArrayList<ReferenceMap>(10);
        Map<String, String> tempFile = importParamModel.getTempFile();
        String userId = this.qingContext.getUserId();
        for (DsbRefObject dsbRefObj : dsbRefObjs) {
            ReferenceMap referenceMap = dsbRefObj.getReferenceMap();
            List<OutsideReference> outSideRefs = dsbRefObj.getOuterRefs();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)referenceMap.getRefType());
            ReferenceMap newReferenceMap = new ReferenceMap();
            if (refTypeEnum != RefTypeEnum.picture) {
                String schemaTempfileName = tempFile.get(dsbRefObj.getRefSchemaContentFileName());
                String fileKey = UUID.randomUUID().toString();
                newReferenceMap.setFileKey(fileKey);
                if (schemaTempfileName != null) {
                    DashboardModelBookCache dashboardCache = new DashboardModelBookCache(fileKey);
                    byte[] schemaContent = FileFactory.getFileContent((AbstractQingFileType)QingTempFileType.UPLOAD, (String)schemaTempfileName);
                    dashboardCache.setValue(schemaContent);
                    dashboardCache.save();
                }
            }
            newReferenceMap.setRefType(referenceMap.getRefType());
            newReferenceMap.setUid(referenceMap.getUid());
            if (importIds.get(referenceMap.getRefToId()) != null) {
                newReferenceMap.setRefToId(importIds.get(referenceMap.getRefToId()));
                newReferenceMap.setRefToFullPath(null);
            } else {
                String newRefToId = null;
                if (refTypeEnum == RefTypeEnum.picture && referenceMap.getRefToId() != null) {
                    newRefToId = this.getPictureImporter().doImport(importParamModel, referenceMap.getRefToId());
                }
                if (newRefToId != null) {
                    importIds.put(referenceMap.getRefToId(), newRefToId);
                    newReferenceMap.setRefToId(newRefToId);
                    newReferenceMap.setRefToFullPath(null);
                } else {
                    String fullPath = referenceMap.getRefToFullPath();
                    IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                    ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
                    if (switchPathAndIdHandler != null) {
                        newRefToId = switchPathAndIdHandler.switchRefPathToId(fullPath, userId);
                        if (newRefToId != null) {
                            fullPath = null;
                        }
                        newReferenceMap.setRefToId(newRefToId);
                        newReferenceMap.setRefToFullPath(fullPath);
                        ImExportUtil.cacheDashboardWidgetID(importParamModel, publishId, referenceMap.getUid(), referenceMap.getRefToFullPath(), CACHED_PUBLISHID_SUFFIX);
                    }
                }
            }
            String outerRefKey = UUID.randomUUID().toString();
            newReferenceMap.put((Object)"outerRefKey", (Object)outerRefKey);
            if (outSideRefs != null && outSideRefs.size() > 0) {
                for (OutsideReference outsideReference : outSideRefs) {
                    outsideReference.setRefType("Map");
                    String oldMapId = outsideReference.getRefToId();
                    String newMapId = null;
                    if (importIds.get(oldMapId) != null) {
                        newMapId = importIds.get(oldMapId);
                    } else if (oldMapId != null && (newMapId = this.getMapImporter().doImportWithoutTx(importParamModel, oldMapId)) != null) {
                        importIds.put(oldMapId, newMapId);
                    }
                    if (newMapId != null) {
                        outsideReference.setRefToFullPath(null);
                        outsideReference.setRefToId(newMapId);
                        importIds.put(oldMapId, newMapId);
                        continue;
                    }
                    String mapFullPath = outsideReference.getRefToFullPath();
                    if (StringUtils.isNotEmpty((CharSequence)mapFullPath)) {
                        PathModel pathModel = (PathModel)JsonUtil.decodeFromString((String)mapFullPath, PathModel.class);
                        String nameSpace = NameSpace.valueOf((String)pathModel.getNameSpace()).getCode();
                        ExportMapModel exportMapModel = this.getMapManageDomain().loadMapByNameAndGroupName(pathModel.getGroupName(), pathModel.getName(), nameSpace);
                        if (exportMapModel != null) {
                            outsideReference.setRefToFullPath(null);
                            outsideReference.setRefToId(exportMapModel.getMapId());
                            continue;
                        }
                        outsideReference.setRefToId(null);
                        continue;
                    }
                    outsideReference.setRefToId(null);
                }
                DashboardModelUtil.cacheOuterRef(newReferenceMap, outSideRefs);
            }
            refList.add(newReferenceMap);
        }
        String dsbModelFileName = tempFile.get(dsbPublishObj.getDsbModelFileName());
        DashboardModel dashboardModel = new DashboardModel();
        InputStream dsbStream = BoxUtil.getBoxStreamByFileName(dsbModelFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
        if (dsbStream != null) {
            dashboardModel = DashboardSerializationUtil.toModel(dsbStream);
        }
        dashboardModel.fixReferences(refList);
        PublishDashboardModel importDashboardSource = new PublishDashboardModel();
        importDashboardSource.setDsbModel(dashboardModel);
        InputStream dsbModelStream = BoxUtil.getBoxStreamByFileName(dsbModelFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
        importDashboardSource.setDashboardStream(dsbModelStream);
        return importDashboardSource;
    }

    private void resolvePublishNameDuplicateConflict(String tag, PublishPO publishInfo, List<PermissionInfo> permInfos, AbstractPublishSourceModel abstractPublishSourceModel, List<IQingFile> savedQingFiles, String needOverwritePublishId, String exportPublishId, AbstractPublishManageDomain publishManageDomain, ImportParamModel importParamModel) throws AbstractQingIntegratedException, SQLException {
        ArrayList<AbstractPublishSourceModel> abstractPublishSourceModelList = new ArrayList<AbstractPublishSourceModel>(1);
        abstractPublishSourceModelList.add(abstractPublishSourceModel);
        boolean isNewName = true;
        while (isNewName) {
            String conflictName = publishInfo.getName();
            String newName = ImExportUtil.rename(conflictName);
            publishInfo.setName(newName);
            if (publishManageDomain.judgeNameIsExist(Integer.valueOf(publishInfo.getPublishTargetType()), publishInfo.getName(), publishInfo.getPath())) continue;
            isNewName = false;
        }
        try {
            String finalPublishId = publishManageDomain.savePublishInfoNotTx(tag, publishInfo, permInfos, abstractPublishSourceModelList, savedQingFiles, needOverwritePublishId, null);
            importParamModel.getOverwriteFinalPublishIdMap().put(exportPublishId, finalPublishId);
        }
        catch (PublishException publishException) {
            // empty catch block
        }
    }
}

