/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.publish;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.imexport.importer.exception.ImportSubjectPublishException;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.imexport.importer.pkg.integration.IntegrationImportHelper;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.AbstractPublishInfoImporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedBillInfoObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.embedded.EmbeddedPublishObject;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileSizeLimitException;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishFileLimitException;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetImexportDomainFactory;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class EmbeddedPublishImporter
extends AbstractPublishInfoImporter {
    private ImportPKGDomain.IPublishInfoCollector publishInfoCollector;

    public void registerPublishInfoCollector(ImportPKGDomain.IPublishInfoCollector publishInfoCollector) {
        this.publishInfoCollector = publishInfoCollector;
    }

    public void doImportWithoutTx(ImportParamModel importParamModel) throws ImportSubjectPublishException, ImportThemeFileSizeLimitException {
        PackageMeta packageMeta = importParamModel.getPackageMeta();
        List<AbstractPublishObject> publishObjects = packageMeta.getPublishObjs();
        try {
            this.sortPublishObjs(publishObjects);
            for (AbstractPublishObject billPublishObject : publishObjects) {
                PublishPO publishPO = billPublishObject.getPublishPO();
                publishPO.setOverwrite(true);
                String newPublishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
                importParamModel.getNewPublishIdMap().put(publishPO.getId(), newPublishId);
                this.savePublishWithoutTx(billPublishObject, null, importParamModel);
                IntegrationImportHelper.importIntegrationWithoutTx(this.qingContext, this.dbExcuter, importParamModel);
            }
        }
        catch (PublishFileLimitException e) {
            if (this.publishInfoCollector != null) {
                this.publishInfoCollector.clear();
            }
            throw new ImportThemeFileSizeLimitException((Throwable)((Object)e));
        }
        catch (Exception e) {
            if (this.publishInfoCollector != null) {
                this.publishInfoCollector.clear();
            }
            throw new ImportSubjectPublishException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSavePublishInfo(AbstractPublishObject publishObj, ThemeVO subjectVO, ImportParamModel importParamModel, String exportPublishId, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> publishSchemaModelList, PublishPO publishPO, PublishPO newPublishPO) throws IOException, PublishException, SQLException, AbstractQingIntegratedException {
        block9: {
            Map<String, String> importIds = importParamModel.getImportIds();
            List<IQingFile> successImportFiles = importParamModel.getSuccessImportFiles();
            Map<String, String> tempFile = importParamModel.getTempFile();
            EmbeddedBillInfoObject embeddedBillInfoObject = ((EmbeddedPublishObject)publishObj).getEmbeddedBillInfoObject();
            PublishTarget publishTarget = publishObj.getPublishTarget();
            String ctrlKey = embeddedBillInfoObject.getCtrlKey();
            String filterContent = embeddedBillInfoObject.getFilterContent();
            IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempFile.get(filterContent + ".filter"));
            byte[] filterInfo = null;
            QingInputStream inputStream = null;
            try {
                inputStream = fileVisitor.getInputStream();
                filterInfo = new byte[inputStream.available()];
                inputStream.read(filterInfo);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, null, publishTarget.getTargetType());
            if (publishPO.getLastBiztag() != null) {
                newPublishPO.setLastBiztag(PublishUtil.isPublish((String)publishPO.getLastBiztag()) ? importParamModel.getNewPublishIdMap().get(publishPO.getLastBiztag()) : publishPO.getTagId());
            }
            AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)publishTarget.getTargetType(), (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
            String tag = UUID.randomUUID().toString();
            try {
                if (publishManageDomain != null) {
                    String finalPublishId = publishManageDomain.saveBillPublishInfo(tag, newPublishPO, permInfos, publishSchemaModelList, successImportFiles, ctrlKey, filterInfo);
                    importIds.put(exportPublishId, newPublishPO.getId());
                    importParamModel.getOverwriteFinalPublishIdMap().put(exportPublishId, finalPublishId);
                    if (this.publishInfoCollector != null) {
                        this.publishInfoCollector.collectPublishInfo(exportPublishId, newPublishPO);
                    }
                }
            }
            catch (PublishNameDuplicateException e) {
                if (publishTargetImexportDomain != null) {
                    ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
                    String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"card", (String)"\u5361\u7247\u5e93", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + publishTarget.getPath() + "/" + publishPO.getName();
                    exportPublicConflict.setPublishPath(publishPath);
                    importParamModel.getConfilctPublishList().add(exportPublicConflict);
                }
            }
            catch (PublishSameSourceNameDuplicateException e) {
                if (publishTargetImexportDomain == null) break block9;
                ExportPublishConflictVO exportPublicConflict = new ExportPublishConflictVO();
                String publishPath = Messages.getMLS((QingContext)this.qingContext, (String)"card", (String)"\u5361\u7247\u5e93", (Messages.ProjectName)Messages.ProjectName.QING_THEME) + " : " + publishTarget.getPath() + "/" + publishPO.getName();
                exportPublicConflict.setPublishPath(publishPath);
                importParamModel.getConfilctPublishList().add(exportPublicConflict);
            }
        }
    }
}

