/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.pkg.publish;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportSubjectPublishException;
import com.kingdee.bos.qing.imexport.importer.pkg.domain.ImportPKGDomain;
import com.kingdee.bos.qing.imexport.importer.pkg.model.ImportParamModel;
import com.kingdee.bos.qing.imexport.importer.pkg.publish.AbstractPublishInfoImporter;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.subject.SubjectCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToLapp;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.imexport.strategy.IQHFStrategy;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileSizeLimitException;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishFileLimitException;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetImexportDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetImexportDomainFactory;
import com.kingdee.bos.qing.publish.thumbnail.domain.ThumbnailDomain;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom2.JDOMException;

public class SubjectPublishImporter
extends AbstractPublishInfoImporter {
    private IScheduleEngine scheduleEngine;
    private ThumbnailDomain thumbnailDomain;
    private ImportPKGDomain.IPublishInfoCollector publishInfoCollector;

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private ThumbnailDomain getThumbnailDomain() {
        if (this.thumbnailDomain == null) {
            this.thumbnailDomain = new ThumbnailDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.thumbnailDomain;
    }

    public void registerPublishInfoCollector(ImportPKGDomain.IPublishInfoCollector publishInfoCollector) {
        this.publishInfoCollector = publishInfoCollector;
    }

    public void doImportWithoutTx(ImportParamModel importParamModel, ThemeVO themeVO, String oldSubjectId, boolean overWrite, List<LongerSquarePublishObject> lappSubjectPublishObjects) throws ImportSubjectPublishException, ImportThemeFileSizeLimitException {
        PackageMeta packageMeta = importParamModel.getPackageMeta();
        List<AbstractPublishObject> publishObjects = packageMeta.getPublishObjs();
        try {
            this.sortPublishObjs(publishObjects);
            for (AbstractPublishObject subjectPublishObject : publishObjects) {
                PublishPO publishPO = subjectPublishObject.getPublishPO();
                String sourceId = publishPO.getTagId();
                if (!oldSubjectId.equals(sourceId)) continue;
                publishPO.setOverwrite(overWrite);
                publishPO.setTagId(themeVO.getThemeID());
                String newPublishId = PublishUtil.getPublishId((String)UUID.randomUUID().toString());
                importParamModel.getNewPublishIdMap().put(publishPO.getId(), newPublishId);
                int publishType = subjectPublishObject.getPublishTarget().getTargetType();
                String productName = importParamModel.getPackageMeta().getEnvironment().getProduct().getName();
                if (publishType == 2) {
                    PublishToLapp publishToLapp = (PublishToLapp)subjectPublishObject.getPublishTarget();
                    publishToLapp.setThemeType("0");
                    publishToLapp.setThemeName(themeVO.getThemeName());
                    lappSubjectPublishObjects.add((LongerSquarePublishObject)subjectPublishObject);
                    continue;
                }
                if (publishType == 0) {
                    IQHFStrategy qhfStrategy = (IQHFStrategy)CustomStrategyRegistrar.getStrategy(IQHFStrategy.class);
                    if (qhfStrategy == null) {
                        throw new RuntimeException("cannot found the implement of IQHFStrategy.");
                    }
                    if (!qhfStrategy.getProductName(productName).equals(productName)) continue;
                }
                this.savePublishWithoutTx(subjectPublishObject, themeVO, importParamModel);
            }
        }
        catch (PublishFileLimitException e) {
            if (this.publishInfoCollector != null) {
                this.publishInfoCollector.clear();
            }
            throw new ImportThemeFileSizeLimitException((Throwable)((Object)e));
        }
        catch (Exception e) {
            if (this.publishInfoCollector != null) {
                this.publishInfoCollector.clear();
            }
            throw new ImportSubjectPublishException(e);
        }
    }

    @Override
    public void doSavePublishInfo(AbstractPublishObject publishObj, ThemeVO subjectVO, ImportParamModel importParamModel, String exportPublishId, List<PermissionInfo> permInfos, List<AbstractPublishSourceModel> publishSchemaModelList, PublishPO publishPO, PublishPO newPublishPO) throws IOException, PublishException, SQLException, AbstractQingIntegratedException, ImportThemeException, EncryptedLicenseCheckException, PersistentModelParseException, PersistentModelTooModernException, JDOMException {
        PublishTarget publishTarget;
        Map<String, String> tempFile;
        String newPublishId;
        block13: {
            newPublishId = importParamModel.getNewPublishIdMap().get(exportPublishId);
            String needOverwritePublishId = importParamModel.getNeedOverwritePublishId().get(newPublishId);
            Map<String, String> importIds = importParamModel.getImportIds();
            tempFile = importParamModel.getTempFile();
            List<IQingFile> successImportFiles = importParamModel.getSuccessImportFiles();
            publishTarget = publishObj.getPublishTarget();
            String tag = UUID.randomUUID().toString();
            if (publishPO.isCarryData()) {
                SubjectCarryDataInfo subjectCarryDataInfo = (SubjectCarryDataInfo)publishObj.getCarryDataInfo();
                SubjectQsInfo subjectQsInfo = subjectCarryDataInfo.getSubjectQsInfo();
                String modelFileKey = subjectCarryDataInfo.getDataModelingObj().getBoxFileName();
                this.cachePublishCarrayData(importParamModel, tag, modelFileKey, subjectQsInfo);
            }
            AbstractPublishTargetImexportDomain publishTargetImexportDomain = PublishTargetImexportDomainFactory.createPublishTargetImexportDomain(this.qingContext, this.tx, this.dbExcuter, null, publishTarget.getTargetType());
            if (publishPO.getLastBiztag() != null) {
                newPublishPO.setLastBiztag(PublishUtil.isPublish((String)publishPO.getLastBiztag()) ? importParamModel.getNewPublishIdMap().get(publishPO.getLastBiztag()) : subjectVO.getThemeID());
            }
            AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)publishTarget.getTargetType(), (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
            try {
                if (publishManageDomain != null) {
                    String finalPublishId = publishManageDomain.savePublishInfoNotTx(tag, newPublishPO, permInfos, publishSchemaModelList, successImportFiles, needOverwritePublishId, null);
                    importIds.put(exportPublishId, newPublishPO.getId());
                    importParamModel.getOverwriteFinalPublishIdMap().put(exportPublishId, finalPublishId);
                    if (this.publishInfoCollector != null) {
                        this.publishInfoCollector.collectPublishInfo(exportPublishId, newPublishPO);
                    }
                }
            }
            catch (PublishNameDuplicateException e) {
                if (publishTargetImexportDomain != null) {
                    publishTargetImexportDomain.doPublishNameDuplicate(importParamModel.getConfilctPublishList(), subjectVO, publishTarget.getPath(), publishPO.getName());
                }
            }
            catch (PublishSameSourceNameDuplicateException e) {
                if (publishTargetImexportDomain == null) break block13;
                publishTargetImexportDomain.doPublishNameDuplicate(importParamModel.getConfilctPublishList(), subjectVO, publishTarget.getPath(), publishPO.getName());
            }
        }
        if (newPublishPO.getPublishTargetType() == 2 && newPublishPO.getPublishSourceType() != PublishSourceEnum.dashboard) {
            ThumbnailInfo thumbnailInfo = ((PublishToLapp)publishTarget).getThumbnailInfo();
            String schemaFileName = ((PublishToLapp)publishTarget).getSchemaFileName();
            ModelBook modelBook = ModelBookUtil.fromFile((AbstractQingFileType)QingTempFileType.UPLOAD, tempFile.get(schemaFileName));
            Map<String, String> analysisIdMap = importParamModel.getAnalysisIdMap();
            String analysisId = analysisIdMap.get(newPublishPO.getId());
            if (analysisId == null) {
                analysisId = " ";
            }
            boolean isDuplicate = false;
            boolean isOverwrite = newPublishPO.isOverwrite();
            if (importParamModel.getDuplicateMap().containsKey(newPublishId)) {
                isDuplicate = importParamModel.getDuplicateMap().get(newPublishId);
                if (!isDuplicate) {
                    isOverwrite = false;
                }
            } else {
                isOverwrite = false;
            }
            thumbnailInfo.setAnalysisId(analysisId);
            thumbnailInfo.setPublishId(newPublishPO.getId());
            thumbnailInfo.setModelBook(modelBook);
            thumbnailInfo.setSchemaId(null);
            this.getThumbnailDomain().saveThumbnailInfo(thumbnailInfo, this.qingContext.getUserId(), isOverwrite);
        }
    }

    private void cachePublishCarrayData(ImportParamModel importParamModel, String tag, String modelFileKey, SubjectQsInfo subjectQsInfo) throws ImportThemeException, IOException, EncryptedLicenseCheckException {
        try {
            Box box = new Box();
            String boxFileName = importParamModel.getTempFile().get(modelFileKey);
            InputStream boxOrignalStream = BoxUtil.getBoxStreamByFileName(boxFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
            if (boxOrignalStream != null) {
                box = BoxSerializationUtil.toModel(boxOrignalStream, true);
            }
            ThemeDataSource themeDataSource = new ThemeDataSource();
            themeDataSource.setOriginalCreatorId(this.qingContext.getUserId());
            Map<String, String> tempFile = importParamModel.getTempFile();
            HashMap<String, String> qs = new HashMap<String, String>();
            Map<String, String> oldQs = subjectQsInfo.getQs();
            for (Map.Entry<String, String> oldQsEntry : oldQs.entrySet()) {
                if (tempFile.get(oldQsEntry.getValue()) == null) continue;
                qs.put(oldQsEntry.getKey(), tempFile.get(oldQsEntry.getValue()));
            }
            themeDataSource.setDataFiles(qs);
            themeDataSource.setBox(box);
            themeDataSource.setTag(tag);
            QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
            InputStream boxStream = BoxUtil.getBoxStreamByFileName(boxFileName, (AbstractQingFileType)QingTempFileType.UPLOAD);
            BoxUtil.cacheBoxStream(boxStream);
        }
        catch (ModelParseException e) {
            throw new ImportThemeException(e);
        }
    }
}

