/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain;

import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.domain.MapDomain;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportCacheNotFoundException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.map.MapLoader;
import com.kingdee.bos.qing.map.builder.ConfigBuilder;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ImportMapQHFDomain {
    public MapDomain.MapTemplate loadMapTemplate(String tag, String refToId, String refToFullPath) throws ImportException {
        MapLoader.Reference ref = new MapLoader.Reference(refToId, refToFullPath);
        String content = null;
        MapLoader.BackImage backImage = null;
        try {
            String cacheKey;
            ImportedModel importedModel;
            String cacheTag = QingSessionUtil.get((String)tag);
            if (StringUtils.isNotBlank((CharSequence)cacheTag)) {
                tag = cacheTag;
            }
            if ((importedModel = (ImportedModel)QingSessionUtil.getCache((String)(cacheKey = ImportedModel.getCacheKey(tag)), ImportedModel.class)) == null) {
                throw new ImportCacheNotFoundException();
            }
            Map<String, String> tempFileMap = importedModel.getTempFileMap();
            content = this.loadTemplateContent(tempFileMap, ref);
            backImage = this.loadBackImageDescription(tempFileMap, ref);
        }
        catch (MapLoader.MapNotFoundException e) {
            LogUtil.error((String)"MapNotFoundException", (Throwable)e);
        }
        catch (MapLoader.MapLoaderException e) {
            LogUtil.error((String)"MapLoaderException", (Throwable)e);
        }
        MapDomain.MapTemplate inst = new MapDomain.MapTemplate();
        inst.setContent(content);
        inst.setBackImage(backImage);
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTemplateContent(Map<String, String> tempFileMap, MapLoader.Reference reference) throws MapLoader.MapLoaderException, MapLoader.MapNotFoundException {
        String string;
        InputStream inStm = null;
        try {
            inStm = this.loadTemplate(tempFileMap, reference);
            string = MapLoader.toStringContent((InputStream)inStm);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inStm});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inStm});
        return string;
    }

    private MapLoader.BackImage loadBackImageDescription(Map<String, String> tempFileMap, MapLoader.Reference reference) throws MapLoader.MapLoaderException, MapLoader.MapNotFoundException {
        Element xmlRoot;
        InputStream inStm = this.loadConfig(tempFileMap, reference);
        try {
            xmlRoot = XmlUtil.loadRootElement((InputStream)inStm);
        }
        catch (JDOMException ex) {
            throw new MapLoader.MapLoaderException((Throwable)ex, "Parse config error.");
        }
        catch (IOException ex) {
            throw new MapLoader.MapLoaderException((Throwable)ex, "Parse config error.");
        }
        if (ConfigBuilder.isBackImageDisplay((Element)xmlRoot)) {
            int width = ConfigBuilder.getBackImagePageWidth((Element)xmlRoot);
            int height = ConfigBuilder.getBackImagePageHeight((Element)xmlRoot);
            MapLoader.BackImage backImage = new MapLoader.BackImage();
            backImage.setUrl(this.getBackImageUrl(tempFileMap, reference));
            backImage.setPageSize(width, height);
            return backImage;
        }
        return null;
    }

    private InputStream loadTemplate(Map<String, String> tempFileMap, MapLoader.Reference reference) throws MapLoader.MapNotFoundException {
        String mapSvgFileName = tempFileMap.get(reference.getRefToId() + ".svg");
        return this.loadFileContent(mapSvgFileName);
    }

    private InputStream loadConfig(Map<String, String> tempFileMap, MapLoader.Reference reference) throws MapLoader.MapNotFoundException {
        String mapConfigFileName = tempFileMap.get(reference.getRefToId() + ".config");
        return this.loadFileContent(mapConfigFileName);
    }

    private String getBackImageUrl(Map<String, String> tempFileMap, MapLoader.Reference reference) {
        String mapBackImageFileName = tempFileMap.get(reference.getRefToId() + ".background-image");
        return "/qing/loadImg.do?fileName=" + mapBackImageFileName + "&fileType=upload";
    }

    private InputStream loadFileContent(String fileName) throws MapLoader.MapNotFoundException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        if (fileVisitor.exists()) {
            try {
                return fileVisitor.getInputStream();
            }
            catch (IOException e) {
                throw new MapLoader.MapNotFoundException((Throwable)e, "laod file error");
            }
        }
        throw new MapLoader.MapNotFoundException("file not found");
    }
}

