/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.common.AbstractImportDomain;
import com.kingdee.bos.qing.imexport.importer.exception.ImportCacheNotFoundException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportEncryptedLicenseCheckException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.IModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.scene.ModelParserFactory;
import com.kingdee.bos.qing.imexport.importer.qhf.model.EntranceInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.EnvironmentVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.FileInfoVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.QingMapFileVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.Environment;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.MetaTypeEnum;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.subject.SubjectCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.resource.Picture;
import com.kingdee.bos.qing.imexport.model.resource.QingMap;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import com.kingdee.bos.qing.imexport.model.resource.Thumbnail;
import com.kingdee.bos.qing.imexport.model.subject.DataModelingObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import com.kingdee.bos.qing.schema.model.SchemaTypeEnum;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom2.JDOMException;

public class ImportQHFDomain
extends AbstractImportDomain {
    @Override
    public Map<String, String> doImport(String fileName) throws ImportException {
        ImportedModel importedModel = null;
        try {
            importedModel = this.parseZipFile(fileName, MetaTypeEnum.qhf);
            String tag = UUID.randomUUID().toString();
            importedModel.setTag(tag);
            QingSessionUtil.setCache((ISessionCacheable)importedModel);
            String sceneType = importedModel.getPackageMeta().getEnvironment().getSceneType();
            IModelParser parser = ModelParserFactory.getParserBySceneType(sceneType);
            parser.cacheDataSource(tag, importedModel);
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("tag", tag);
            map.put("sceneType", sceneType);
            return map;
        }
        catch (EncryptedLicenseCheckException e) {
            throw new ImportEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
        }
        catch (Exception e) {
            if (e instanceof ImportException) {
                throw (ImportException)((Object)e);
            }
            throw new ImportException(e);
        }
        catch (Throwable e) {
            throw new ImportException(e);
        }
    }

    public EnvironmentVO loadEnvironmentVO(String tag) throws ImportCacheNotFoundException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            EnvironmentVO environmentVO = new EnvironmentVO();
            environmentVO.setEnvironment(importedModel.getPackageMeta().getEnvironment());
            environmentVO.setQhfVersion(importedModel.getPackageMeta().getVersion());
            return environmentVO;
        }
        throw new ImportCacheNotFoundException();
    }

    public EntranceInfoVO loadEntranceInfo(String tag) throws ImportException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            String sceneType = importedModel.getPackageMeta().getEnvironment().getSceneType();
            IModelParser parser = ModelParserFactory.getParserBySceneType(sceneType);
            return parser.getEntranceInfo(tag, importedModel);
        }
        throw new ImportCacheNotFoundException();
    }

    public AbstractDataSourceInfoVO loadDataSourceInfo(String tag) throws ImportException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            String sceneType = importedModel.getPackageMeta().getEnvironment().getSceneType();
            IModelParser parser = ModelParserFactory.getParserBySceneType(sceneType);
            return parser.getDataSourceInfo(tag, importedModel);
        }
        throw new ImportCacheNotFoundException();
    }

    public SchemaContentVO loadSchema(String tag, String schemaId, String schemaType) throws ImportException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            Environment environment = importedModel.getPackageMeta().getEnvironment();
            String sceneType = environment.getSceneType();
            IModelParser parser = ModelParserFactory.getParserBySceneType(sceneType);
            List<SchemaObject> schemaObjs = parser.getSchemaObjs(importedModel);
            if (schemaObjs != null) {
                if (StringUtils.isEmpty((CharSequence)schemaId)) {
                    SchemaTypeEnum schemaTypeEnum = SchemaTypeEnum.getSchemaTypeEnum(Integer.parseInt(schemaType));
                    schemaId = ImExportUtil.getFinalSchemaId(schemaTypeEnum);
                }
                for (SchemaObject schemaObj : schemaObjs) {
                    SchemaBO schemaBO;
                    SchemaInfo schemaInfo = schemaObj.getSchemaInfo();
                    if (schemaInfo == null || (schemaBO = schemaInfo.getSchemaBO()) == null) continue;
                    boolean flag = false;
                    if (schemaType.equals(String.valueOf(schemaBO.getSource())) && schemaBO.getfId().equals(schemaId)) {
                        flag = true;
                    }
                    if (!flag) continue;
                    SchemaContentVO contentVO = new SchemaContentVO();
                    contentVO.setfId(schemaBO.getfId());
                    contentVO.setSchemaName(schemaBO.getSchemaName());
                    contentVO.setSchemaType(schemaBO.getSchemaType());
                    Map<String, String> tempMap = importedModel.getTempFileMap();
                    String zipFileName = schemaInfo.getSchemaContentFile();
                    String tempFileName = tempMap.get(zipFileName);
                    try {
                        ModelBook modelBook = ModelBookUtil.fromFile((AbstractQingFileType)QingTempFileType.UPLOAD, tempFileName);
                        List<OutsideReference> outSideRefList = schemaObj.getOutSideRefs();
                        if (outSideRefList != null && !outSideRefList.isEmpty()) {
                            modelBook.fixReferences(outSideRefList);
                        }
                        contentVO.setSchemaContent(modelBook);
                        return contentVO;
                    }
                    catch (PersistentModelParseException e) {
                        throw new ImportException(e);
                    }
                    catch (PersistentModelTooModernException e) {
                        throw new ImportException(e);
                    }
                    catch (IOException e) {
                        throw new ImportException(e);
                    }
                    catch (JDOMException e) {
                        throw new ImportException(e);
                    }
                }
            }
            return null;
        }
        throw new ImportCacheNotFoundException();
    }

    public ArrayList<SchemaAttrVO> loadSchemaAttrs(String tag, String source) throws IOException, PersistentModelParseException, PersistentModelTooModernException, ImportException {
        ArrayList<SchemaAttrVO> listVO = new ArrayList<SchemaAttrVO>();
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            String sceneType = importedModel.getPackageMeta().getEnvironment().getSceneType();
            IModelParser parser = ModelParserFactory.getParserBySceneType(sceneType);
            List<SchemaObject> schemaObjs = parser.getSchemaObjs(importedModel);
            if (schemaObjs != null) {
                for (SchemaObject schemaObj : schemaObjs) {
                    SchemaBO schemaBO;
                    SchemaInfo schemaInfo = schemaObj.getSchemaInfo();
                    if (schemaInfo == null || (schemaBO = schemaInfo.getSchemaBO()) == null || schemaBO.getSource() != Integer.parseInt(source)) continue;
                    SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
                    schemaAttrVO.setfId(schemaBO.getfId());
                    schemaAttrVO.setSchemaName(schemaBO.getSchemaName());
                    schemaAttrVO.setSchemaType(schemaBO.getSchemaType());
                    schemaAttrVO.setIsDefault(schemaBO.IsDefault());
                    schemaAttrVO.setSource(schemaBO.getSource());
                    schemaAttrVO.setSeq(schemaBO.getSeq());
                    listVO.add(schemaAttrVO);
                }
            }
            Collections.sort(listVO, new Comparator<SchemaAttrVO>(){

                @Override
                public int compare(SchemaAttrVO v1, SchemaAttrVO v2) {
                    int seqDiff = v1.getSeq() - v2.getSeq();
                    if (seqDiff < 0) {
                        return 1;
                    }
                    if (seqDiff > 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            return listVO;
        }
        throw new ImportCacheNotFoundException();
    }

    public FileInfoVO loadFileInfo(String tag) throws ImportCacheNotFoundException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            Resources resources;
            List<AbstractPublishObject> list;
            FileInfoVO fileInfoVO = new FileInfoVO();
            Map<String, String> tempFileMap = importedModel.getTempFileMap();
            for (String string : tempFileMap.keySet()) {
                if (!string.endsWith(".qs")) continue;
                fileInfoVO.getQsFileNames().add(string);
            }
            List<SubjectObject> subjectObjects = importedModel.getPackageMeta().getSubjectObjs();
            if (subjectObjects != null && !subjectObjects.isEmpty()) {
                for (SubjectObject subjectObject : subjectObjects) {
                    DataModelingObject dataModelingObject = subjectObject.getDataModelingObj();
                    if (dataModelingObject == null) continue;
                    fileInfoVO.getDsFileNames().addAll(dataModelingObject.getDsFileNames());
                }
            }
            if ((list = importedModel.getPackageMeta().getPublishObjs()) != null && !list.isEmpty()) {
                for (AbstractPublishObject abstractPublishObject : list) {
                    if (PublishSourceEnum.subject != abstractPublishObject.getPublishPO().getPublishSourceType() || !abstractPublishObject.getPublishPO().isCarryData()) continue;
                    SubjectCarryDataInfo subjectCarryDataInfo = (SubjectCarryDataInfo)abstractPublishObject.getCarryDataInfo();
                    fileInfoVO.getDsFileNames().addAll(subjectCarryDataInfo.getDataModelingObj().getDsFileNames());
                }
            }
            if ((resources = importedModel.getPackageMeta().getResources()) != null) {
                List<Thumbnail> list2;
                List<Thumbnail> list3;
                List<QingMap> qingMaps;
                List<Picture> pictures = resources.getPictures();
                if (pictures != null && !pictures.isEmpty()) {
                    for (Picture picture : pictures) {
                        fileInfoVO.getPictureFileNames().add(picture.getFileName());
                    }
                }
                if ((qingMaps = resources.getQingMaps()) != null && !qingMaps.isEmpty()) {
                    for (QingMap qingMap : qingMaps) {
                        QingMapFileVO qingMapFileVO = new QingMapFileVO();
                        qingMapFileVO.setModelFileName(qingMap.getModelZipFileName());
                        qingMapFileVO.setSvgFileName(qingMap.getSvgZipFileName());
                        qingMapFileVO.setConfigFileName(qingMap.getConfigZipFileName());
                        qingMapFileVO.setThumbnailFileName(qingMap.getThumbnailZipFileName());
                        qingMapFileVO.setBackgroundImageFileName(qingMap.getBackgroundImageZipFileName());
                        fileInfoVO.getQingMapFileVOs().add(qingMapFileVO);
                    }
                }
                if ((list3 = resources.getLappThumbnails()) != null && !list3.isEmpty()) {
                    for (Thumbnail thumbnail : list3) {
                        fileInfoVO.getLappThumbnailFileNames().add(thumbnail.getThumbnailFileName());
                    }
                }
                if ((list2 = resources.getCardThumbnails()) != null && !list2.isEmpty()) {
                    for (Thumbnail thumbnail : list2) {
                        fileInfoVO.getCardThumbnailFileNames().add(thumbnail.getThumbnailFileName());
                    }
                }
            }
            return fileInfoVO;
        }
        throw new ImportCacheNotFoundException();
    }

    public List<TraceSpanVO> loadTraceSpanInfo(String tag) throws ImportException {
        String cacheKey = ImportedModel.getCacheKey(tag);
        ImportedModel importedModel = (ImportedModel)QingSessionUtil.getCache((String)cacheKey, ImportedModel.class);
        if (importedModel != null) {
            String sceneType = importedModel.getPackageMeta().getEnvironment().getSceneType();
            IModelParser parser = ModelParserFactory.getParserBySceneType(sceneType);
            return parser.getTraceSpanInfo(tag, importedModel);
        }
        throw new ImportCacheNotFoundException();
    }
}

