/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.EmbededDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaInfo;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataInfo;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataObject;
import com.kingdee.bos.qing.imexport.model.embeddeddata.EmbeddedDataQsInfo;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AbstractEmbeddedModelParser {
    protected void cacheDataSource(EmbeddedDataQsInfo embeddedDataQsInfo, String tag, ImportedModel importedModel) {
        if (embeddedDataQsInfo != null) {
            SingleFileDataSource dataSource = new SingleFileDataSource();
            dataSource.setStoreFileType((AbstractQingFileType)QingTempFileType.TEMP_QS);
            dataSource.setExtractDataTime(embeddedDataQsInfo.getExtractTimestamp());
            dataSource.setOriginalCreatorId(embeddedDataQsInfo.getOriginalCreatorId());
            String zipFileName = embeddedDataQsInfo.getQsFileName();
            Map<String, String> tempMap = importedModel.getTempFileMap();
            dataSource.setFileName(tempMap.get(zipFileName));
            dataSource.setTag(tag);
            QingSessionUtil.setCache((ISessionCacheable)dataSource);
        }
    }

    protected EmbededDataSourceInfoVO getDataSourceInfoByEmbeddedDataObject(EmbeddedDataObject embeddedDataObject, ImportedModel importedModel) throws ImportException {
        EmbeddedDataInfo embeddedDataInfo = embeddedDataObject.getEmbeddedDataInfo();
        EmbededDataSourceInfoVO embededDataSourceInfoVO = embeddedDataInfo.getDataSourceInfoVO();
        EmbeddedDataQsInfo embeddedDataQsInfo = embeddedDataObject.getEmbeddedDataQsInfo();
        if (embeddedDataQsInfo != null) {
            List<TraceSpan> extractDataTraceSpans = ImExportUtil.getTraceSpansByZipFileName(embeddedDataQsInfo.getExtractDataTraceFile(), importedModel);
            embededDataSourceInfoVO.setExtractDataTraceSpans(extractDataTraceSpans);
        }
        return embededDataSourceInfoVO;
    }

    protected List<TraceSpanVO> getTraceSpanInfo(EmbeddedDataQsInfo embeddedDataQsInfo, List<SchemaObject> schemaObjects, ImportedModel importedModel) throws ImportException {
        ArrayList<TraceSpanVO> traceSpanVOList = new ArrayList<TraceSpanVO>(10);
        if (embeddedDataQsInfo != null) {
            String extractDataTraceFileName = embeddedDataQsInfo.getExtractDataTraceFile();
            List<TraceSpanVO> extractDataTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(extractDataTraceFileName, importedModel, 0, Messages.getMLS((String)"dataExtract", (String)"\u6570\u636e\u62bd\u53d6", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
            traceSpanVOList.addAll(extractDataTraceSpanVOs);
        }
        if (schemaObjects != null && !schemaObjects.isEmpty()) {
            for (SchemaObject schemaObject : schemaObjects) {
                SchemaInfo schemaInfo = schemaObject.getSchemaInfo();
                if (!StringUtils.isNotBlank((CharSequence)schemaInfo.getExecuteTraceFile())) continue;
                String joinTraceFileName = schemaInfo.getJoinTraceFile();
                List<TraceSpanVO> joinTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(joinTraceFileName, importedModel, 0, Messages.getMLS((String)"joinTask", (String)"JOIN\u4efb\u52a1", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                traceSpanVOList.addAll(joinTraceSpanVOs);
                String executeTraceFileName = schemaInfo.getExecuteTraceFile();
                List<TraceSpanVO> executeTraceSpanVOs = ImExportUtil.getTraceSpanVOsByZipTraceFileName(executeTraceFileName, importedModel, 0, Messages.getMLS((String)"schemaExecute", (String)"\u65b9\u6848\u6267\u884c", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                traceSpanVOList.addAll(executeTraceSpanVOs);
                break;
            }
        }
        return traceSpanVOList;
    }
}

