/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.impl;

import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common.AbstractDsbModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.IPublishModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.dashboard.DashboardObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbPublishObject;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import java.util.List;

public class PublishDsbModelParser
extends AbstractDsbModelParser
implements IPublishModelParser {
    @Override
    public void cacheDataSource(String tag, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjs) {
                if (publishObject.getPublishPO().getPublishSourceType() != PublishSourceEnum.dashboard) continue;
                this.cachePublishedDsbRefDataSource(tag, publishObject, importedModel);
                break;
            }
        }
    }

    @Override
    public AbstractDataSourceInfoVO getDataSourceInfo(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjs) {
                List<DashboardObject> dashboardObjs;
                if (publishObject.getPublishPO().getPublishSourceType() != PublishSourceEnum.dashboard || !publishObject.getPublishPO().getId().equals(publishPO.getId()) || (dashboardObjs = importedModel.getPackageMeta().getDashboardObjs()) == null || dashboardObjs.isEmpty()) continue;
                for (DashboardObject dashboardObject : dashboardObjs) {
                    if (dashboardObject == null || !dashboardObject.getThemeVO().getThemeID().equals(publishPO.getTagId())) continue;
                    DsbPublishObject dsbPublishObject = (DsbPublishObject)publishObject;
                    return this.getDsbDataSourceInfo(tag, publishPO.getId(), true, dashboardObject.getThemeVO(), dashboardObject.getThemeGroupVO(), dsbPublishObject.getDsbModelFileName(), dsbPublishObject.getDsbRefObjs(), importedModel);
                }
            }
        }
        throw new ImportNoInfoFoundException();
    }

    @Override
    public void cacheDataSourceByPublishPO(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjs) {
                if (publishObject.getPublishPO().getPublishSourceType() != PublishSourceEnum.dashboard || !publishObject.getPublishPO().getId().equals(publishPO.getId())) continue;
                this.cachePublishedDsbRefDataSource(tag, publishObject, importedModel);
                break;
            }
        }
    }

    private void cachePublishedDsbRefDataSource(String tag, AbstractPublishObject publishObject, ImportedModel importedModel) throws ImportException {
        DsbPublishObject dsbPublishObject = (DsbPublishObject)publishObject;
        this.cacheDsbRefsDataSource(tag, importedModel, dsbPublishObject.getDsbRefObjs(), publishObject.getPublishPO().getId(), true);
    }

    @Override
    public List<TraceSpanVO> getTraceSpanInfo(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjs) {
                if (publishObject.getPublishPO().getPublishSourceType() != PublishSourceEnum.dashboard || !publishObject.getPublishPO().getId().equals(publishPO.getId())) continue;
                DsbPublishObject dsbPublishObject = (DsbPublishObject)publishObject;
                return this.getTraceSpanInfo(tag, dsbPublishObject.getDsbModelFileName(), dsbPublishObject.getDsbRefObjs(), importedModel);
            }
        }
        return null;
    }
}

