/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.impl;

import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportNoInfoFoundException;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.common.AbstractSubjectModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.domain.modelparser.publish.IPublishModelParser;
import com.kingdee.bos.qing.imexport.importer.qhf.model.SourceTypeVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.TraceSpanVO;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.SubjectDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import com.kingdee.bos.qing.imexport.model.publish.LongerSquarePublishObject;
import com.kingdee.bos.qing.imexport.model.publish.subject.SubjectCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.subject.SubjectObject;
import com.kingdee.bos.qing.imexport.model.subject.SubjectQsInfo;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.publish.model.PublishPO;
import java.util.List;

public class PublishSubjectModelParser
extends AbstractSubjectModelParser
implements IPublishModelParser {
    @Override
    public void cacheDataSource(String tag, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjs = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjs != null && !publishObjs.isEmpty()) {
            AbstractPublishObject publishObject = publishObjs.get(0);
            PublishPO publishPO = publishObject.getPublishPO();
            String id = publishPO.getTagId();
            if (publishPO.isCarryData()) {
                this.cachePublishedCarryDataDataSource(tag, publishObject, importedModel);
            } else {
                this.cacheNotCarryDataDataSourceById(tag, id, importedModel);
            }
        }
    }

    @Override
    public SubjectDataSourceInfoVO getDataSourceInfo(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        block4: {
            block3: {
                if (!publishPO.isCarryData()) break block3;
                List<AbstractPublishObject> publishObjects = importedModel.getPackageMeta().getPublishObjs();
                if (publishObjects == null || publishObjects.isEmpty()) break block4;
                for (AbstractPublishObject publishObject : publishObjects) {
                    if (publishObject == null || !publishPO.getId().equals(publishObject.getPublishPO().getId())) continue;
                    SubjectCarryDataInfo subjectCarryDataInfo = (SubjectCarryDataInfo)publishObject.getCarryDataInfo();
                    ThemeVO themeVO = subjectCarryDataInfo.getThemeVO();
                    ThemeGroupVO themeGroupVO = subjectCarryDataInfo.getThemeGroupVO();
                    return this.transformSubjectDataSourceInfoVO(themeVO, themeGroupVO);
                }
                break block4;
            }
            List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
            if (subjectObjs != null && !subjectObjs.isEmpty()) {
                for (SubjectObject subjectObject : subjectObjs) {
                    if (subjectObject == null || !subjectObject.getThemeVO().getThemeID().equals(publishPO.getTagId())) continue;
                    return this.getDataSourceInfoBySubjectObject(subjectObject, importedModel);
                }
            }
        }
        throw new ImportNoInfoFoundException();
    }

    @Override
    public void cacheDataSourceByPublishPO(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        if (publishPO.isCarryData()) {
            List<AbstractPublishObject> publishObjects = importedModel.getPackageMeta().getPublishObjs();
            if (publishObjects != null && !publishObjects.isEmpty()) {
                for (AbstractPublishObject publishObject : publishObjects) {
                    if (publishObject == null || !publishPO.getId().equals(publishObject.getPublishPO().getId())) continue;
                    this.cachePublishedCarryDataDataSource(tag, publishObject, importedModel);
                    break;
                }
            }
        } else {
            String id = publishPO.getTagId();
            this.cacheNotCarryDataDataSourceById(tag, id, importedModel);
        }
    }

    @Override
    public List<TraceSpanVO> getTraceSpanInfo(String tag, PublishPO publishPO, ImportedModel importedModel) throws ImportException {
        List<AbstractPublishObject> publishObjects = importedModel.getPackageMeta().getPublishObjs();
        if (publishObjects != null && !publishObjects.isEmpty()) {
            for (AbstractPublishObject publishObject : publishObjects) {
                if (publishObject == null || !publishPO.getId().equals(publishObject.getPublishPO().getId())) continue;
                LongerSquarePublishObject longerSquarePublishObject = (LongerSquarePublishObject)publishObject;
                List<SchemaObject> schemaObjects = longerSquarePublishObject.getSchemaObjs();
                SubjectQsInfo subjectQsInfo = null;
                if (publishPO.isCarryData()) {
                    SubjectCarryDataInfo subjectCarryDataInfo = (SubjectCarryDataInfo)publishObject.getCarryDataInfo();
                    subjectQsInfo = subjectCarryDataInfo.getSubjectQsInfo();
                } else {
                    List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
                    if (subjectObjs != null && !subjectObjs.isEmpty()) {
                        for (SubjectObject subjectObject : subjectObjs) {
                            if (subjectObject == null || !subjectObject.getThemeVO().getThemeID().equals(publishPO.getTagId())) continue;
                            subjectQsInfo = subjectObject.getAnalysisObj().getSubjectQsInfo();
                            break;
                        }
                    }
                }
                return this.getTraceSpanInfo(subjectQsInfo, schemaObjects, importedModel);
            }
        }
        return null;
    }

    private void cacheNotCarryDataDataSourceById(String tag, String subjectId, ImportedModel importedModel) throws ImportException {
        block3: {
            try {
                List<SubjectObject> subjectObjs = importedModel.getPackageMeta().getSubjectObjs();
                if (subjectObjs == null || subjectObjs.isEmpty()) break block3;
                for (SubjectObject subjectObject : subjectObjs) {
                    if (!subjectId.equals(subjectObject.getThemeVO().getThemeID())) continue;
                    this.cacheDataSource(subjectObject.getAnalysisObj().getSubjectQsInfo(), subjectObject.getDataModelingObj(), tag, importedModel);
                    break;
                }
            }
            catch (Exception e) {
                throw new ImportException(e);
            }
        }
    }

    private void cachePublishedCarryDataDataSource(String tag, AbstractPublishObject publishObject, ImportedModel importedModel) throws ImportException {
        try {
            SubjectCarryDataInfo subjectCarryDataInfo = (SubjectCarryDataInfo)publishObject.getCarryDataInfo();
            this.cacheDataSource(subjectCarryDataInfo.getSubjectQsInfo(), subjectCarryDataInfo.getDataModelingObj(), tag, importedModel);
        }
        catch (Exception e) {
            throw new ImportException(e);
        }
    }

    private SubjectDataSourceInfoVO transformSubjectDataSourceInfoVO(ThemeVO themeVO, ThemeGroupVO themeGroupVO) {
        SubjectDataSourceInfoVO subjectDataSourceInfoVO = new SubjectDataSourceInfoVO();
        subjectDataSourceInfoVO.setSourceType(SourceTypeVO.SourceTypeEnum.subject.name());
        subjectDataSourceInfoVO.setGroupName(themeGroupVO.getThemeGroupName());
        subjectDataSourceInfoVO.setDescription(themeVO.getDescription());
        subjectDataSourceInfoVO.setName(themeVO.getThemeName());
        return subjectDataSourceInfoVO;
    }
}

