/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model;

import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class QsInfo {
    protected long extractTimestamp;
    protected String originalCreatorId;
    protected String originalCreatorName;
    protected List<TraceSpan> extractDataTraceSpans;
    private String extractDataTraceFile;

    public long getExtractTimestamp() {
        return this.extractTimestamp;
    }

    public void setExtractTimestamp(long extractTimestamp) {
        this.extractTimestamp = extractTimestamp;
    }

    public String getOriginalCreatorId() {
        return this.originalCreatorId;
    }

    public void setOriginalCreatorId(String originalCreatorId) {
        this.originalCreatorId = originalCreatorId;
    }

    public String getOriginalCreatorName() {
        return this.originalCreatorName;
    }

    public void setOriginalCreatorName(String originalCreatorName) {
        this.originalCreatorName = originalCreatorName;
    }

    public List<TraceSpan> getExtractDataTraceSpans() {
        return this.extractDataTraceSpans;
    }

    public void setExtractDataTraceSpans(List<TraceSpan> extractDataTraceSpans) {
        this.extractDataTraceSpans = extractDataTraceSpans;
    }

    public String getExtractDataTraceFile() {
        return this.extractDataTraceFile;
    }

    public void setExtractDataTraceFile(String extractDataTraceFile) {
        this.extractDataTraceFile = extractDataTraceFile;
    }

    public Element toXml() {
        Element qsInfoElement = new Element("QsInfo");
        qsInfoElement.setAttribute("extractTimestamp", "" + this.extractTimestamp);
        if (StringUtils.isNotBlank((CharSequence)this.originalCreatorId)) {
            qsInfoElement.setAttribute("originalCreatorId", this.originalCreatorId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.originalCreatorName)) {
            qsInfoElement.setAttribute("originalCreatorName", this.originalCreatorName);
        }
        if (this.extractDataTraceSpans != null && !this.extractDataTraceSpans.isEmpty()) {
            this.extractDataTraceFile = UUID.randomUUID().toString() + ".trace";
            qsInfoElement.setAttribute("extractDataTraceFile", this.extractDataTraceFile);
        }
        return qsInfoElement;
    }

    public void fromXml(Element qsInfoElement) {
        if (StringUtils.isNotBlank((CharSequence)qsInfoElement.getAttributeValue("extractTimestamp"))) {
            this.extractTimestamp = Long.parseLong(qsInfoElement.getAttributeValue("extractTimestamp"));
        }
        this.originalCreatorId = qsInfoElement.getAttributeValue("originalCreatorId");
        this.originalCreatorName = qsInfoElement.getAttributeValue("originalCreatorName");
        this.extractDataTraceFile = qsInfoElement.getAttributeValue("extractDataTraceFile");
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        if (this.extractDataTraceSpans != null && !this.extractDataTraceSpans.isEmpty()) {
            String traceFilePath = "trace" + File.separator + this.extractDataTraceFile;
            zos.putNextEntry(new ZipEntry(traceFilePath));
            XmlUtil.save((Element)ImExportUtil.traceSpansToXml(this.extractDataTraceSpans), (OutputStream)zos);
            zos.flush();
        }
    }

    public void endCleanFiles() {
    }
}

