/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.embeddeddata;

import com.kingdee.bos.qing.imexport.util.ImExportUtil;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class EmbeddedBillInfoObject {
    private String filterContent;
    private String ctrlKey;
    private byte[] filterInfo;

    public byte[] getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(byte[] filterInfo) {
        this.filterInfo = filterInfo;
    }

    public String getFilterContent() {
        return this.filterContent;
    }

    public void setFilterContent(String filterContent) {
        this.filterContent = filterContent;
    }

    public String getCtrlKey() {
        return this.ctrlKey;
    }

    public void setCtrlKey(String ctrlKey) {
        this.ctrlKey = ctrlKey;
    }

    public Element toXml() {
        Element billInfoElement = new Element("SourceInfo");
        if (this.getCtrlKey() != null) {
            Element ctrlKeyElement = new Element("CtrlKey");
            ctrlKeyElement.setAttribute("value", this.getCtrlKey());
            billInfoElement.addContent((Content)ctrlKeyElement);
        }
        Element filterElement = new Element("Filter");
        filterElement.setAttribute("file", this.getFilterContent());
        billInfoElement.addContent((Content)filterElement);
        return billInfoElement;
    }

    public void exportPublishFile(ZipOutputStream zos, String billFilterFilePath, String extension) throws IOException {
        String finalFilePath = billFilterFilePath + this.filterContent + extension;
        ImExportUtil.exportFile(zos, this.filterContent, finalFilePath);
    }

    public void fromXml(Element sourceInfoElement) {
        Element filterElement;
        Element ctrlKeyElement = sourceInfoElement.getChild("CtrlKey");
        if (ctrlKeyElement != null) {
            this.ctrlKey = ctrlKeyElement.getAttributeValue("value");
        }
        if ((filterElement = sourceInfoElement.getChild("Filter")) != null) {
            this.filterContent = filterElement.getAttributeValue("file");
        }
    }

    public void endCleanPublishFiles() {
        ImExportUtil.deleteExportFile(this.filterContent);
    }
}

