/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish;

import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.model.publish.AbstractCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.dashboard.DsbCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.embedded.EmbeddedCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.subject.SubjectCarryDataInfo;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToCard;
import com.kingdee.bos.qing.imexport.model.publish.target.PublishToLapp;
import com.kingdee.bos.qing.publish.model.PermissionObject;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsObject;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class AbstractPublishObject {
    protected PublishPO publishPO;
    protected String creatorName;
    protected List<PermissionObject> permissionObjs;
    protected PublishTarget publishTarget;
    protected AbstractCarryDataInfo carryDataInfo;
    protected List<PublishOperPermissionsObject> publishOperPermissionsObjects;

    public PublishPO getPublishPO() {
        return this.publishPO;
    }

    public void setPublishPO(PublishPO publishPO) {
        this.publishPO = publishPO;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public List<PermissionObject> getPermissionObjs() {
        return this.permissionObjs;
    }

    public void setPermissionObjs(List<PermissionObject> permissionObjs) {
        this.permissionObjs = permissionObjs;
    }

    public PublishTarget getPublishTarget() {
        return this.publishTarget;
    }

    public void setPublishTarget(PublishTarget publishTarget) {
        this.publishTarget = publishTarget;
    }

    public AbstractCarryDataInfo getCarryDataInfo() {
        return this.carryDataInfo;
    }

    public void setCarryDataInfo(AbstractCarryDataInfo carryDataInfo) {
        this.carryDataInfo = carryDataInfo;
    }

    public List<PublishOperPermissionsObject> getPublishOperPermissionsObjects() {
        return this.publishOperPermissionsObjects;
    }

    public void setPublishOperPermissionsObjects(List<PublishOperPermissionsObject> publishOperPermissionsObjects) {
        this.publishOperPermissionsObjects = publishOperPermissionsObjects;
    }

    public Element toXml() throws IntegratedRuntimeException {
        Element publishElement = new Element("Publish");
        publishElement.setAttribute("id", this.publishPO.getId());
        publishElement.setAttribute("name", this.publishPO.getName());
        publishElement.setAttribute("sourceId", this.publishPO.getTagId());
        publishElement.setAttribute("sourceType", this.publishPO.getPublishSourceType().name());
        publishElement.setAttribute("creatorId", this.publishPO.getCreatorId());
        publishElement.setAttribute("carryData", String.valueOf(this.publishPO.isCarryData()));
        publishElement.setAttribute("isPreset", String.valueOf(this.publishPO.isPreset()));
        publishElement.setAttribute("creatorName", IntegratedHelper.getUserName(null, null, (String)this.publishPO.getCreatorId()));
        if (this.publishPO.getLastBiztag() != null) {
            publishElement.setAttribute("lastBiztag", this.publishPO.getLastBiztag());
        }
        if (this.publishPO.getParentPublishIdFullPath() != null) {
            publishElement.setAttribute("parentPublishIdFullPath", this.publishPO.getParentPublishIdFullPath());
        }
        if (this.permissionObjs != null && !this.permissionObjs.isEmpty()) {
            Element permissionInfoElement = new Element("AuthorizedIds");
            for (PermissionObject permissionObj : this.permissionObjs) {
                permissionInfoElement.addContent((Content)permissionObj.toXml());
            }
            publishElement.addContent((Content)permissionInfoElement);
        }
        if (this.publishTarget != null) {
            publishElement.addContent((Content)this.publishTarget.toXml());
        }
        if (this.carryDataInfo != null) {
            publishElement.addContent((Content)this.carryDataInfo.toXml(this.publishPO));
        }
        if (this.publishOperPermissionsObjects != null && !this.publishOperPermissionsObjects.isEmpty()) {
            Element PublishOperPermissionElement = new Element("PublishOperAuths");
            for (PublishOperPermissionsObject publishOperPermissionsObject : this.publishOperPermissionsObjects) {
                PublishOperPermissionElement.addContent((Content)publishOperPermissionsObject.toXml());
            }
            publishElement.addContent((Content)PublishOperPermissionElement);
        }
        return publishElement;
    }

    public void fromXml(Element publishObjElement, String type, String version) throws ModelParseException, JDOMException, IOException {
        Element publishOperAuthElement;
        Element targetElm;
        Element carryDataInfoElm;
        this.publishPO = new PublishPO();
        this.publishPO.setId(publishObjElement.getAttributeValue("id"));
        this.publishPO.setName(publishObjElement.getAttributeValue("name"));
        this.publishPO.setTagId(publishObjElement.getAttributeValue("sourceId"));
        this.publishPO.setPublishSourceType(PublishSourceEnum.valueOf((String)publishObjElement.getAttributeValue("sourceType")));
        this.publishPO.setCreatorId(publishObjElement.getAttributeValue("creatorId"));
        this.publishPO.setCarryData("true".equals(publishObjElement.getAttributeValue("carryData")));
        this.publishPO.setPreset("true".equals(publishObjElement.getAttributeValue("isPreset")));
        if (publishObjElement.getAttributeValue("lastBiztag") != null) {
            this.publishPO.setLastBiztag(publishObjElement.getAttributeValue("lastBiztag"));
        }
        if (publishObjElement.getAttributeValue("parentPublishIdFullPath") != null) {
            this.publishPO.setParentPublishIdFullPath(publishObjElement.getAttributeValue("parentPublishIdFullPath"));
        }
        this.creatorName = publishObjElement.getAttributeValue("creatorName");
        Element authorizedIdsElement = publishObjElement.getChild("AuthorizedIds");
        if (authorizedIdsElement != null) {
            this.permissionObjs = new ArrayList<PermissionObject>(10);
            List authorizedIds = authorizedIdsElement.getChildren("AuthorizedId");
            for (Element authorizedIdElement : authorizedIds) {
                PermissionObject permissionObj = new PermissionObject();
                permissionObj.fromXml(authorizedIdElement, type, version);
                this.permissionObjs.add(permissionObj);
            }
        }
        if ((carryDataInfoElm = publishObjElement.getChild("CarryDataInfo")) != null) {
            AbstractCarryDataInfo carryDataInfo = null;
            carryDataInfo = carryDataInfoElm.getChildren("Subject") != null && carryDataInfoElm.getChildren("Subject").size() > 0 ? new SubjectCarryDataInfo() : (carryDataInfoElm.getChildren("EmbeddedData") != null && carryDataInfoElm.getChildren("EmbeddedData").size() > 0 ? new EmbeddedCarryDataInfo() : new DsbCarryDataInfo());
            if (carryDataInfo != null) {
                ((AbstractCarryDataInfo)carryDataInfo).fromXml(publishObjElement, type, version);
                this.carryDataInfo = carryDataInfo;
            }
        }
        if ((targetElm = publishObjElement.getChild("Target")) != null) {
            int publishType = Integer.parseInt(targetElm.getAttributeValue("type"));
            if (publishType == 5) {
                PublishToCard publishToCard = new PublishToCard();
                publishToCard.cardFrmoXml(publishObjElement);
                this.publishTarget = publishToCard;
            } else if (publishType == 2) {
                PublishToLapp publishToLapp = new PublishToLapp();
                publishToLapp.lappFrmoXml(publishObjElement);
                this.publishTarget = publishToLapp;
            } else {
                PublishTarget publishTarget = new PublishTarget();
                publishTarget.fromXml(publishObjElement);
                this.publishTarget = publishTarget;
            }
        }
        if ((publishOperAuthElement = publishObjElement.getChild("PublishOperAuths")) != null) {
            this.publishOperPermissionsObjects = new ArrayList<PublishOperPermissionsObject>(10);
            List publishOperAuths = publishOperAuthElement.getChildren("PublishOperAuth");
            for (Element publishOperElement : publishOperAuths) {
                PublishOperPermissionsObject publishOperPermissionsObject = new PublishOperPermissionsObject();
                publishOperPermissionsObject.fromXml(publishOperElement, type, version);
                this.publishOperPermissionsObjects.add(publishOperPermissionsObject);
            }
        }
    }

    public abstract void exportPublishFile(ZipOutputStream var1) throws IOException;

    public abstract void endCleanPublishFiles();

    public void exportFile(ZipOutputStream zos) throws IOException {
        if (this.carryDataInfo != null) {
            this.carryDataInfo.exportFile(this.publishPO.getId(), zos);
        }
        if (this.publishPO.getPublishTargetType() == 2 && this.publishTarget != null) {
            ((PublishToLapp)this.publishTarget).exportLappThumbnailFile(zos);
        }
        this.exportPublishFile(zos);
    }

    public void endCleanFiles() {
        if (this.carryDataInfo != null) {
            this.carryDataInfo.endCleanFiles();
        }
    }
}

