/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.publish;

import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.model.SchemaObject;
import com.kingdee.bos.qing.imexport.model.publish.AbstractPublishObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class LongerSquarePublishObject
extends AbstractPublishObject {
    protected List<SchemaObject> schemaObjs;

    public List<SchemaObject> getSchemaObjs() {
        return this.schemaObjs;
    }

    public void setSchemaObjs(List<SchemaObject> schemaObjs) {
        this.schemaObjs = schemaObjs;
    }

    @Override
    public Element toXml() throws IntegratedRuntimeException {
        Element publishElement = super.toXml();
        if (this.schemaObjs != null && !this.schemaObjs.isEmpty()) {
            Element schemasElement = new Element("Schemas");
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemasElement.addContent((Content)schemaObj.toXml());
            }
            publishElement.addContent((Content)schemasElement);
        }
        return publishElement;
    }

    @Override
    public void exportPublishFile(ZipOutputStream zos) throws IOException {
        if (this.schemaObjs != null) {
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemaObj.exportFile(zos);
            }
        }
    }

    @Override
    public void fromXml(Element publishObjElement, String type, String version) throws ModelParseException, JDOMException, IOException {
        super.fromXml(publishObjElement, type, version);
        Element schemaObjsElement = publishObjElement.getChild("Schemas");
        this.schemaObjs = new ArrayList<SchemaObject>(10);
        if (schemaObjsElement != null) {
            List schemaElements = schemaObjsElement.getChildren("Schema");
            for (Element schemaObjElement : schemaElements) {
                SchemaObject schemaObj = new SchemaObject();
                schemaObj.fromXml(schemaObjElement, type, version);
                this.schemaObjs.add(schemaObj);
            }
        }
    }

    @Override
    public void endCleanPublishFiles() {
        if (this.schemaObjs != null) {
            for (SchemaObject schemaObj : this.schemaObjs) {
                schemaObj.endCleanFiles();
            }
        }
    }
}

