/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.resource;

import com.kingdee.bos.qing.imexport.model.resource.DBConnInfo;
import com.kingdee.bos.qing.imexport.model.resource.Macro;
import com.kingdee.bos.qing.imexport.model.resource.Picture;
import com.kingdee.bos.qing.imexport.model.resource.QingMap;
import com.kingdee.bos.qing.imexport.model.resource.Thumbnail;
import com.kingdee.bos.qing.macro.export.ExportModelConvertor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class Resources {
    private transient Set<String> mapIds = new HashSet<String>(16);
    private transient Set<String> pictureFileNames = new HashSet<String>(16);
    private transient Set<String> thumbnailImagePaths = new HashSet<String>(16);
    private Set<String> lappImagePaths = new HashSet<String>(16);
    private transient Set<String> macroUids = new HashSet<String>(16);
    private List<QingMap> qingMaps = new ArrayList<QingMap>(10);
    private List<Picture> pictures = new ArrayList<Picture>(10);
    private List<Thumbnail> cardThumbnails = new ArrayList<Thumbnail>(10);
    private List<Thumbnail> lappThumbnails = new ArrayList<Thumbnail>(10);
    private List<Macro> macros = new ArrayList<Macro>(10);
    private List<DBConnInfo> dbConnInfos = new ArrayList<DBConnInfo>(10);

    public Set<String> getMapIds() {
        return this.mapIds;
    }

    public void setMapIds(Set<String> mapIds) {
        this.mapIds = mapIds;
    }

    public Set<String> getPictureFileNames() {
        return this.pictureFileNames;
    }

    public void setPictureFileNames(Set<String> pictureFileNames) {
        this.pictureFileNames = pictureFileNames;
    }

    public Set<String> getThumbnailImagePaths() {
        return this.thumbnailImagePaths;
    }

    public void setThumbnailImagePaths(Set<String> thumbnailImagePaths) {
        this.thumbnailImagePaths = thumbnailImagePaths;
    }

    public Set<String> getLappImagePaths() {
        return this.lappImagePaths;
    }

    public void setLappImagePaths(Set<String> lappImagePaths) {
        this.lappImagePaths = lappImagePaths;
    }

    public List<QingMap> getQingMaps() {
        return this.qingMaps;
    }

    public void setQingMaps(List<QingMap> qingMaps) {
        this.qingMaps = qingMaps;
    }

    public List<Picture> getPictures() {
        return this.pictures;
    }

    public void setPictures(List<Picture> pictures) {
        this.pictures = pictures;
    }

    public List<Thumbnail> getCardThumbnails() {
        return this.cardThumbnails;
    }

    public void setCardThumbnails(List<Thumbnail> cardThumbnails) {
        this.cardThumbnails = cardThumbnails;
    }

    public List<Thumbnail> getLappThumbnails() {
        return this.lappThumbnails;
    }

    public void setLappThumbnails(List<Thumbnail> lappThumbnails) {
        this.lappThumbnails = lappThumbnails;
    }

    public void addMacroUid(String macroUid) {
        this.macroUids.add(macroUid);
    }

    public Set<String> getMacroUids() {
        return this.macroUids;
    }

    public List<Macro> getMacros() {
        return this.macros;
    }

    public void setMacros(List<Macro> macros) {
        this.macros = macros;
    }

    public void setDBConnInfos(List<DBConnInfo> dbConnInfos) {
        this.dbConnInfos = dbConnInfos;
    }

    public List<DBConnInfo> getDBConnInfos() {
        return this.dbConnInfos;
    }

    public Element toXml() {
        if (this.hasContent()) {
            Element xml = new Element("Resources");
            if (this.qingMaps != null && !this.qingMaps.isEmpty()) {
                Element mapsElm = new Element("Maps");
                for (QingMap qingMap : this.qingMaps) {
                    mapsElm.addContent((Content)qingMap.toXml());
                }
                xml.addContent((Content)mapsElm);
            }
            if (this.pictures != null && !this.pictures.isEmpty()) {
                Element picturesElm = new Element("Pictures");
                for (Picture picture : this.pictures) {
                    picturesElm.addContent((Content)picture.toXml());
                }
                xml.addContent((Content)picturesElm);
            }
            if (this.cardThumbnails != null && !this.cardThumbnails.isEmpty() || this.lappThumbnails != null && !this.lappThumbnails.isEmpty()) {
                Element thumbnailsElm = new Element("Thumbnails");
                for (Thumbnail cardThumbnail : this.cardThumbnails) {
                    thumbnailsElm.addContent((Content)cardThumbnail.toXml());
                }
                for (Thumbnail lappThumbnail : this.lappThumbnails) {
                    thumbnailsElm.addContent((Content)lappThumbnail.toXml());
                }
                xml.addContent((Content)thumbnailsElm);
            }
            if (this.macros != null && !this.macros.isEmpty()) {
                Element macrosElement = new Element("Macros");
                for (Macro macro : this.macros) {
                    macrosElement.addContent((Content)macro.toXml());
                }
                xml.addContent((Content)macrosElement);
            }
            if (this.dbConnInfos != null && !this.dbConnInfos.isEmpty()) {
                Element dbConnsElement = new Element("DBConnInfos");
                for (DBConnInfo dbConnInfo : this.dbConnInfos) {
                    dbConnsElement.addContent((Content)dbConnInfo.toXml());
                }
                xml.addContent((Content)dbConnsElement);
            }
            return xml;
        }
        return null;
    }

    public void fromXml(Element xml, String type, String version) {
        Element resourcesXml = xml.getChild("Resources");
        if (resourcesXml == null) {
            return;
        }
        Element mapsElm = resourcesXml.getChild("Maps");
        Element picturesElm = resourcesXml.getChild("Pictures");
        Element thumbnailsElm = resourcesXml.getChild("Thumbnails");
        Element macrosElm = resourcesXml.getChild("Macros");
        Element dbConnElm = resourcesXml.getChild("DBConnInfos");
        if (mapsElm != null) {
            List mapListElm = mapsElm.getChildren();
            for (Element mapElm : mapListElm) {
                QingMap qingMap = new QingMap();
                qingMap.fromXml(mapElm, type, version);
                this.qingMaps.add(qingMap);
            }
        }
        if (picturesElm != null) {
            List pictureListElm = picturesElm.getChildren();
            for (Element pictureElm : pictureListElm) {
                Picture picture = new Picture();
                picture.fromXml(pictureElm, type, version);
                this.pictures.add(picture);
            }
        }
        if (thumbnailsElm != null) {
            List thumbnailListElm = thumbnailsElm.getChildren();
            for (Element thumbnailElm : thumbnailListElm) {
                Thumbnail thumbnail = new Thumbnail();
                thumbnail.fromXml(thumbnailElm, type, version);
                this.cardThumbnails.add(thumbnail);
            }
        }
        if (macrosElm != null) {
            List macrosListElm = macrosElm.getChildren();
            for (Element element : macrosListElm) {
                Macro macro = ExportModelConvertor.fromXml(element, version);
                this.macros.add(macro);
            }
        }
        if (dbConnElm != null) {
            List dbConnListElm = dbConnElm.getChildren();
            for (Element element : dbConnListElm) {
                DBConnInfo dbConn = new DBConnInfo();
                dbConn.fromXml(element, version);
                this.dbConnInfos.add(dbConn);
            }
        }
    }

    public boolean hasContent() {
        return !this.qingMaps.isEmpty() || !this.pictures.isEmpty() || !this.cardThumbnails.isEmpty() || !this.lappThumbnails.isEmpty() || !this.macros.isEmpty();
    }

    public void exportFile(ZipOutputStream zos) throws IOException {
        for (QingMap qingMap : this.qingMaps) {
            qingMap.exportFile(zos);
        }
        for (Picture picture : this.pictures) {
            picture.exportFile(zos);
        }
        for (Thumbnail cardThumbnail : this.cardThumbnails) {
            cardThumbnail.exportCardThumbnailFile(zos);
        }
        for (Thumbnail lappThumbnail : this.lappThumbnails) {
            lappThumbnail.exportLappThumbnailFile(zos);
        }
    }

    public void endCleanFiles() {
    }
}

