/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.dao.impl;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.exception.ThemeNameDuplicateException;
import com.kingdee.bos.qing.manage.model.DashboardVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ThemeDaoImpl
implements IThemeDao {
    public static final String T_QING_THEME = "T_QING_Theme";
    private IDBExcuter dbExcuter;

    public ThemeDaoImpl(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    @Override
    public void updateModifyDate(String themeID, String userID) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("UPDATE T_QING_Theme SET FModifyDate=? WHERE FID=? and FUserID=?", new Object[]{new Date(), themeID, userID});
    }

    @Override
    public String saveOrUpdateTheme(ThemePO themePO) throws ThemeNameDuplicateException, AbstractQingIntegratedException, SQLException {
        String themeType;
        String themeName;
        String themeID = themePO.getThemeID();
        String groupID = themePO.getGroupID();
        String userID = themePO.getUserID();
        if (this.checkThemeNameExist(userID, groupID, themeName = themePO.getThemeName(), themeID, themeType = themePO.getThemeType())) {
            throw new ThemeNameDuplicateException();
        }
        String sql = null;
        Object[] params = null;
        if (themeID == null) {
            sql = "INSERT INTO T_QING_Theme (FID, FThemeGroupID, FUserID, FName, FDescription,FCreateDate,FModifyDate,FIsDelete,FType,FOrderID) VALUES(?,?,?,?,?,?,?,?,?,?)";
            params = new Object[10];
            themeID = this.dbExcuter.genStringId(T_QING_THEME);
            int idx = 0;
            params[idx++] = themeID;
            params[idx++] = groupID;
            params[idx++] = userID;
            params[idx++] = themeName;
            params[idx++] = themePO.getDescription();
            params[idx++] = themePO.getCreateTime() != null ? themePO.getCreateTime() : new Date();
            params[idx++] = themePO.getUpdateTime() != null ? themePO.getUpdateTime() : new Date();
            params[idx++] = 0;
            params[idx++] = themePO.getThemeType();
            params[idx++] = 0;
        } else {
            sql = "UPDATE T_QING_Theme SET FName=?, FDescription=?  WHERE FID=? and FThemeGroupID=? and FUserID=?";
            params = new Object[5];
            int idx = 0;
            params[idx++] = themeName;
            params[idx++] = themePO.getDescription();
            params[idx++] = themePO.getThemeID();
            params[idx++] = groupID;
            params[idx++] = userID;
        }
        this.dbExcuter.execute(sql, params);
        return themeID;
    }

    @Override
    public void deleteTheme(String userID, String themeID) throws AbstractQingIntegratedException, SQLException {
        String sql = "delete from T_QING_Theme WHERE FID=? and FUserID=?";
        this.dbExcuter.execute(sql, new Object[]{themeID, userID});
    }

    @Override
    public boolean checkDirExist(String groupID) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fname from t_qing_theme_group where fid = ?";
        Object[] params = new Object[]{groupID};
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                ArrayList<String> groupName = new ArrayList<String>(10);
                while (rs.next()) {
                    groupName.add(rs.getString("fname"));
                }
                return !groupName.isEmpty();
            }
        });
    }

    @Override
    public List<ThemeVO> listThemes(String userID, String groupID) throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT FID, FThemeGroupID, FName, FDescription, FType, FUserID, FOrderID, FEncryptedStatus FROM T_QING_Theme  WHERE FUserID=? AND FThemeGroupID = ? AND FIsDelete = '0'  ORDER BY FOrderID ASC, FCreateDate DESC";
        Object[] params = new Object[]{userID, groupID};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ThemeVO>>(){

            public List<ThemeVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemeVO> voList = new ArrayList<ThemeVO>(10);
                while (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setThemeType(rs.getString("FType"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    vo.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    @Override
    public ThemeVO loadThemeIncludePreset(String userID, String themeID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FThemeGroupID, FName, FDescription, FType, FUserID, FEncryptedStatus FROM T_QING_Theme  WHERE (FUserID=? or FUserID=?) AND FID =? AND FIsDelete = '0'";
        return (ThemeVO)this.dbExcuter.query(sql, new Object[]{userID, IntegratedHelper.getPresetUserId(), themeID}, (ResultHandler)new ResultHandler<ThemeVO>(){

            public ThemeVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setThemeType(rs.getString("FType"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    vo.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    return vo;
                }
                return null;
            }
        });
    }

    @Override
    public ThemeVO loadThemeByName(String userID, String themeGroupID, String themeName, String themeType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FThemeGroupID, FName, FDescription, FUserID, FEncryptedStatus FROM T_QING_Theme WHERE FUserID = ? AND FThemeGroupID = ? AND FName =? AND FType = ? AND FIsDelete = '0'";
        return (ThemeVO)this.dbExcuter.query(sql, new Object[]{userID, themeGroupID, themeName, themeType}, (ResultHandler)new ResultHandler<ThemeVO>(){

            public ThemeVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    vo.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    return vo;
                }
                return null;
            }
        });
    }

    @Override
    public ThemeVO loadThemeByNameAndGroupNameAndType(String userID, String themeGroupName, String themeName, String themeType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT t.FID, t.FThemeGroupID, t.FName, t.FDescription, t.FUserID, FEncryptedStatus FROM T_QING_Theme t LEFT JOIN T_QING_THEME_GROUP g on t.FTHEMEGROUPID = g.FID  WHERE t.FUSERID= ? AND t.FNAME = ? AND t.FTYPE = ? AND t.FISDELETE = '0' AND g.FNAME = ?";
        return (ThemeVO)this.dbExcuter.query(sql, new Object[]{userID, themeName, themeType, themeGroupName}, (ResultHandler)new ResultHandler<ThemeVO>(){

            public ThemeVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    vo.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    return vo;
                }
                return null;
            }
        });
    }

    @Override
    public ThemePO getThemeByID(String themeId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT T.FID, TG.FNAME AS FThemeGroupName, T.FThemeGroupID, T.FUserID, T.FName, T.FDescription, T.FCreateDate, T.FModifyDate, T.FType, T.FEncryptedStatus FROM T_QING_THEME T LEFT JOIN T_QING_THEME_GROUP TG ON T.FTHEMEGROUPID = TG.FID WHERE T.FID=? AND T.FISDELETE='0'";
        return (ThemePO)this.dbExcuter.query(sql, new Object[]{themeId}, (ResultHandler)new ResultHandler<ThemePO>(){

            public ThemePO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ThemePO po = new ThemePO();
                    po.setThemeID(rs.getString("FID"));
                    po.setGroupID(rs.getString("FThemeGroupID"));
                    po.setThemeName(rs.getString("FName"));
                    po.setThemeGroupName(rs.getString("FThemeGroupName"));
                    po.setDescription(rs.getString("FDescription"));
                    po.setCreateTime(rs.getTimestamp("FCreateDate"));
                    po.setUpdateTime(rs.getTimestamp("FModifyDate"));
                    po.setUserID(rs.getString("FUserID"));
                    po.setThemeType(rs.getString("FType"));
                    po.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    po.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    return po;
                }
                return null;
            }
        });
    }

    @Override
    public List<ThemePO> getThemeList(Set<String> themeIds) throws AbstractQingIntegratedException, SQLException {
        if (themeIds.isEmpty()) {
            return new ArrayList<ThemePO>();
        }
        StringBuilder sqlInIdBuilder = new StringBuilder();
        sqlInIdBuilder.append("?");
        for (int i = 1; i < themeIds.size(); ++i) {
            sqlInIdBuilder.append(",?");
        }
        String sqlInId = sqlInIdBuilder.toString();
        String sql = "SELECT FID, FThemeGroupID, FUserID, FName, FDescription, FCreateDate, FModifyDate, FType, FEncryptedStatus FROM T_QING_THEME WHERE FID IN (" + sqlInId + ") and FISDELETE='0'";
        return (List)this.dbExcuter.query(sql, themeIds.toArray(), (ResultHandler)new ResultHandler<List<ThemePO>>(){

            public List<ThemePO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemePO> themePOs = new ArrayList<ThemePO>(10);
                while (rs.next()) {
                    ThemePO po = new ThemePO();
                    po.setThemeID(rs.getString("FID"));
                    po.setGroupID(rs.getString("FThemeGroupID"));
                    po.setThemeName(rs.getString("FName"));
                    po.setDescription(rs.getString("FDescription"));
                    po.setCreateTime(rs.getTimestamp("FCreateDate"));
                    po.setUpdateTime(rs.getTimestamp("FModifyDate"));
                    po.setUserID(rs.getString("FUserID"));
                    po.setThemeType(rs.getString("FType"));
                    po.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    po.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    themePOs.add(po);
                }
                return themePOs;
            }
        });
    }

    @Override
    public void moveTheme(String userID, String groupID, String themeID) throws AbstractQingIntegratedException, ThemeNameDuplicateException, SQLException {
        ThemeVO themeVO = this.loadThemeIncludePreset(userID, themeID);
        if (this.checkThemeNameExist(userID, groupID, themeVO.getThemeName(), themeID, themeVO.getThemeType())) {
            throw new ThemeNameDuplicateException();
        }
        String sql = "UPDATE T_QING_Theme SET FThemeGroupID = ? WHERE FID=? AND FUserID=?";
        Object[] params = new Object[]{groupID, themeID, userID};
        this.dbExcuter.execute(sql, params);
    }

    @Override
    public List<ThemeVO> listThemesUnionPreset(String userID, String groupID) throws AbstractQingIntegratedException, SQLException {
        return this.listThemesUnionPreset(userID, groupID, null);
    }

    @Override
    public List<ThemeVO> listThemesUnionPreset(String userID, String groupID, String themeType) throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT FID, FThemeGroupID, FName, FDescription, FType, FUserID, FEncryptedStatus FROM T_QING_Theme  WHERE (FUserID=? or FUserID=?) AND FThemeGroupID = ? AND FIsDelete = '0'  ORDER BY FOrderID ASC, FCreateDate DESC";
        Object[] params = new Object[]{userID, IntegratedHelper.getPresetUserId(), groupID};
        if (themeType != null) {
            sql = "SELECT FID, FThemeGroupID, FName, FDescription, FType, FUserID, FEncryptedStatus FROM T_QING_Theme  WHERE (FUserID=? or FUserID=?) AND FThemeGroupID = ? AND FIsDelete = '0' AND FType = ? ORDER BY FOrderID ASC, FCreateDate DESC";
            params = new Object[]{userID, IntegratedHelper.getPresetUserId(), groupID, themeType};
        }
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ThemeVO>>(){

            public List<ThemeVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemeVO> voList = new ArrayList<ThemeVO>(10);
                while (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setThemeType(rs.getString("FType"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    vo.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    @Override
    public boolean checkThemeNameExist(String userID, String groupID, String themeName, final String themeId, String themeType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FName, FID FROM T_QING_Theme WHERE FUserID = ? AND FThemeGroupID = ? AND FName = ? AND FIsDelete = '0' AND FType = ?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{userID, groupID, themeName, themeType}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    if (themeId == null) {
                        return Boolean.TRUE;
                    }
                    if (!rs.getString("FID").equals(themeId)) {
                        return Boolean.TRUE;
                    }
                }
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public List<ThemeVO> listAllThemes(String userID, List<String> groupIDList) throws AbstractQingIntegratedException, SQLException {
        String sqlInGroupID = this.getListParamStrInSQL(groupIDList);
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userID);
        queryValue.addAll(groupIDList);
        String sql = " SELECT FID, FThemeGroupID, FName, FDescription, FType, FUserID, FEncryptedStatus FROM T_QING_Theme  WHERE FUserID=? AND FThemeGroupID IN (" + sqlInGroupID + ")  AND FIsDelete = '0'  ORDER BY FOrderID ASC, FCreateDate DESC";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<ThemeVO>>(){

            public List<ThemeVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemeVO> voList = new ArrayList<ThemeVO>(10);
                while (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setThemeType(rs.getString("FType"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    vo.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    @Override
    public List<ThemeVO> listAllThemesUnionPreset(String userID, List<String> groupIDList) throws AbstractQingIntegratedException, SQLException {
        String sqlInGroupID = this.getListParamStrInSQL(groupIDList);
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userID);
        queryValue.add(IntegratedHelper.getPresetUserId());
        queryValue.addAll(groupIDList);
        String sql = " SELECT FID, FThemeGroupID, FName, FDescription, FType, FUserID, FEncryptedStatus FROM T_QING_Theme  WHERE (FUserID=? or FUserID=?) AND FThemeGroupID IN (" + sqlInGroupID + ") AND FIsDelete = '0'  ORDER BY FOrderID ASC, FCreateDate DESC";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<ThemeVO>>(){

            public List<ThemeVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemeVO> voList = new ArrayList<ThemeVO>(10);
                while (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setThemeType(rs.getString("FType"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    vo.setEncrypted(rs.getBoolean("FEncryptedStatus"));
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    @Override
    public void updateThemeForOrder(ThemePO themePO) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> params = new ArrayList<Object>(3);
        String sql = "UPDATE T_QING_Theme SET FOrderID = ?  WHERE FID= ? AND FUserID=?";
        params.add(themePO.getOrderID());
        params.add(themePO.getThemeID());
        params.add(themePO.getUserID());
        this.dbExcuter.execute(sql, params.toArray());
    }

    private String getListParamStrInSQL(List<String> paramList) {
        String sqlInParam = "null";
        if (paramList == null) {
            return sqlInParam;
        }
        StringBuilder sqlInParamBuilder = new StringBuilder();
        sqlInParamBuilder.append("?");
        for (int i = 1; i < paramList.size(); ++i) {
            sqlInParamBuilder.append(",?");
        }
        sqlInParam = sqlInParamBuilder.toString();
        return sqlInParam;
    }

    @Override
    public int queryCount(String userId, String themeId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS COUNT FROM T_QING_THEME T WHERE (T.FUSERID = ? OR T.FUSERID = ?) AND T.FID = ? AND T.FISDELETE = '0'";
        return (Integer)this.dbExcuter.query(sql, new Object[]{userId, IntegratedHelper.getPresetUserId(), themeId}, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("COUNT");
                }
                return 0;
            }
        });
    }

    @Override
    public List<ThemeVO> listThemesLikeName(String userID, String groupID, String themeName, String themeType) throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT FID, FThemeGroupID, FName, FDescription, FType, FUserID, FOrderID FROM T_QING_Theme  WHERE FUserID=? AND FThemeGroupID = ? AND FIsDelete = '0' AND FType=? AND FName LIKE ? ORDER BY FOrderID ASC, FCreateDate DESC";
        Object[] params = new Object[]{userID, groupID, themeType, themeName + "%"};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ThemeVO>>(){

            public List<ThemeVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemeVO> voList = new ArrayList<ThemeVO>(10);
                while (rs.next()) {
                    ThemeVO vo = new ThemeVO();
                    vo.setThemeID(rs.getString("FID"));
                    vo.setThemeGroupID(rs.getString("FThemeGroupID"));
                    vo.setThemeName(rs.getString("FName"));
                    vo.setDescription(rs.getString("FDescription"));
                    vo.setThemeType(rs.getString("FType"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FUserID")));
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    @Override
    public void updateThemeEncryptedStatus(String themeID, int encryptedStatus) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        String sql = "UPDATE T_QING_THEME SET FEncryptedStatus = ? WHERE FID= ?";
        params.add(encryptedStatus);
        params.add(themeID);
        this.dbExcuter.execute(sql, params.toArray());
    }

    @Override
    public List<FileResourceVO> findResourceFileListByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE, T.FID AS THEMEID, T.FNAME AS THEMENAME, TG.FNAME AS THEMEGROUPNAME  FROM (SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE FROM T_QING_FILE_RESOURCE FR WHERE FR.FUSERID = ? AND (FR.FFROMTYPE='THEME' OR FR.FFROMTYPE='THEMESCHEDULE' OR FR.FFROMTYPE='THEMESOURCECONVERT')) FR  LEFT JOIN T_QING_THEME T ON FR.FFROMID=T.FID  LEFT JOIN T_QING_THEME_GROUP TG ON T.FTHEMEGROUPID=TG.FID ";
        Object[] params = new Object[]{userId};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<FileResourceVO>>(){

            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                ArrayList<FileResourceVO> voList = new ArrayList<FileResourceVO>(10);
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    resourceFile.setFromId(rs.getString("FFROMID"));
                    resourceFile.setDisplayName(rs.getString("FDISPLAYNAME"));
                    resourceFile.setFileSizeNoFormat(rs.getString("FFILESIZE"));
                    resourceFile.setCreateDate(Long.valueOf(rs.getTimestamp("FCREATEDATE").getTime()));
                    String fromType = rs.getString("FFROMTYPE");
                    resourceFile.setFromType(fromType);
                    String themeName = rs.getString("THEMENAME");
                    String themeGroupName = rs.getString("THEMEGROUPNAME");
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("THEMEID"))) {
                        resourceFile.setSourceExist(true);
                        resourceFile.setFromPathName(themeGroupName + "/" + themeName);
                    }
                    resourceFile.setFromName(themeName);
                    voList.add(resourceFile);
                }
                return voList;
            }
        });
    }

    @Override
    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(String userId, Date dateMin, Date dateMax) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME, T.FID AS THEMEID, T.FNAME AS THEMENAME, TG.FNAME AS THEMEGROUPNAME  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FUSERID=? AND SE.FMETHODNAME='extractThemeData' AND SE.FEXECUTETIME>=? AND SE.FEXECUTETIME<=?) SE  LEFT JOIN T_QING_THEME T ON SE.FSOURCEID=T.FID LEFT JOIN T_QING_THEME_GROUP TG ON T.FTHEMEGROUPID=TG.FID";
        Object[] params = new Object[]{userId, dateMin, dateMax};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ScheduleExecuteVO>>(){

            public List<ScheduleExecuteVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ScheduleExecuteVO> voList = new ArrayList<ScheduleExecuteVO>(10);
                while (rs.next()) {
                    ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    scheduleExecute.setSourceName(rs.getString("FSOURCENAME"));
                    String themeName = rs.getString("THEMENAME");
                    String themeGroupName = rs.getString("THEMEGROUPNAME");
                    String methodName = rs.getString("FMETHODNAME");
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("THEMEID"))) {
                        scheduleExecute.setSourceExist(true);
                        scheduleExecute.setSourcePathName(themeGroupName + "/" + themeName);
                    }
                    scheduleExecute.setSourceName(themeName);
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                    voList.add(scheduleExecute);
                }
                return voList;
            }
        });
    }

    @Override
    public ScheduleExecuteVO findById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME, T.FNAME AS THEMENAME, TG.FNAME AS THEMEGROUPNAME  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FID=? AND SE.FMETHODNAME='extractThemeData') SE  LEFT JOIN T_QING_THEME T ON SE.FSOURCEID=T.FID LEFT JOIN T_QING_THEME_GROUP TG ON T.FTHEMEGROUPID=TG.FID";
        Object[] params = new Object[]{id};
        return (ScheduleExecuteVO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ScheduleExecuteVO>(){

            public ScheduleExecuteVO handle(ResultSet rs) throws SQLException {
                ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                if (rs.next()) {
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    String themeName = rs.getString("THEMENAME");
                    String themeGroupName = rs.getString("THEMEGROUPNAME");
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourcePathName((themeGroupName == null ? "-" : themeGroupName) + "/" + (themeName == null ? "-" : themeName));
                    scheduleExecute.setSourceName(themeName);
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                }
                return scheduleExecute;
            }
        });
    }

    @Override
    public ThemeVO getSourceThemeByPublishID(String publishID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT THEME.FID AS FDSBID, THEME.FNAME AS THEMENAME, G.FNAME AS GROUPNAME FROM T_QING_THEME THEME  LEFT JOIN T_QING_PUBLISH P ON P.FTAGID = THEME.FID  LEFT JOIN T_QING_THEME_GROUP G ON THEME.FTHEMEGROUPID = G.FID WHERE P.FID = ?";
        Object[] params = new Object[]{publishID};
        return this.resultHandler(sql, params);
    }

    @Override
    public ThemeVO getSourceThemeByLappConfigID(String configID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT THEME.FID AS FDSBID, THEME.FNAME AS THEMENAME, G.FNAME AS GROUPNAME FROM T_QING_THEME THEME  LEFT JOIN T_QING_THEME_GROUP G ON THEME.FTHEMEGROUPID = G.FID    LEFT JOIN T_QING_PUSH_CONFIG_INFO P ON P.FTAGID = THEME.FID  WHERE P.FID = ?";
        Object[] params = new Object[]{configID};
        return this.resultHandler(sql, params);
    }

    @Override
    public ThemeVO getSourceThemeByEmailConfigID(String configID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT THEME.FID AS FDSBID, THEME.FNAME AS THEMENAME, G.FNAME AS GROUPNAME FROM T_QING_THEME THEME LEFT JOIN T_QING_THEME_GROUP G ON THEME.FTHEMEGROUPID = G.FID LEFT JOIN T_QING_PUB_EMAIL_CONF P ON P.FTAGID = THEME.FID WHERE P.FID = ?";
        Object[] params = new Object[]{configID};
        return this.resultHandler(sql, params);
    }

    private ThemeVO resultHandler(String sql, Object[] params) throws AbstractQingIntegratedException, SQLException {
        return (ThemeVO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ThemeVO>(){

            public ThemeVO handle(ResultSet rs) throws SQLException {
                ThemeVO themeVO = new ThemeVO();
                while (rs.next()) {
                    themeVO.setThemeName(rs.getString("THEMENAME"));
                    themeVO.setThemeGroupName(rs.getString("GROUPNAME"));
                    themeVO.setThemeID(rs.getString("FDSBID"));
                }
                return themeVO;
            }
        });
    }

    @Override
    public List<DashboardVO> getVerifyInfo(String groupID, String themeName, String themeID, String themeType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FUserID, FThemeGroupID, FName, FID, FType FROM T_QING_Theme WHERE FThemeGroupID = ? AND FName = ? AND FIsDelete = '0' AND FType = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{groupID, themeName, themeType}, (ResultHandler)new ResultHandler<List<DashboardVO>>(){

            public List<DashboardVO> handle(ResultSet rs) throws SQLException {
                ArrayList<DashboardVO> voList = new ArrayList<DashboardVO>(10);
                while (rs.next()) {
                    DashboardVO vo = new DashboardVO();
                    vo.setUserID(rs.getString("UserID"));
                    vo.setGroupID(rs.getString("GroupID"));
                    vo.setThemeName(rs.getString("ThemeName"));
                    vo.setThemeID(rs.getString("ThemeID"));
                    vo.setThemeType("ThemeType");
                    voList.add(vo);
                }
                return voList;
            }
        });
    }
}

