/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.dao.impl;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.exception.ThemeGroupDuplicateNameException;
import com.kingdee.bos.qing.manage.model.ThemeGroupPO;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ThemeGroupDaoImpl
implements IThemeGroupDao {
    public static final String T_QING_THEME_GROUP = "T_QING_Theme_Group";
    private IDBExcuter dbExcuter;

    public ThemeGroupDaoImpl(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    @Override
    public String saveThemeGroup(ThemeGroupPO themeGroupPO) throws ThemeGroupDuplicateNameException, AbstractQingIntegratedException, SQLException {
        String id = themeGroupPO.getThemeGroupID();
        if (this.checkGoupNameExistForSave(themeGroupPO.getUserID(), themeGroupPO.getThemeGroupName())) {
            throw new ThemeGroupDuplicateNameException();
        }
        String sql = "INSERT INTO T_QING_Theme_Group (FID, FName, FUserID, FCreateDate, FModifyDate) VALUES(?,?,?,?,?)";
        ArrayList<Object> params = new ArrayList<Object>();
        id = this.dbExcuter.genStringId(T_QING_THEME_GROUP);
        params.add(id);
        params.add(themeGroupPO.getThemeGroupName());
        params.add(themeGroupPO.getUserID());
        params.add(themeGroupPO.getUpdateTime() != null ? themeGroupPO.getUpdateTime() : new Date());
        params.add(themeGroupPO.getCreateTime() != null ? themeGroupPO.getCreateTime() : new Date());
        this.dbExcuter.execute(sql, params.toArray());
        return id;
    }

    @Override
    public void updateThemeGroup(ThemeGroupPO themeGroupPO) throws ThemeGroupDuplicateNameException, AbstractQingIntegratedException, SQLException {
        String id = themeGroupPO.getThemeGroupID();
        if (this.checkGroupNameExistForUpdate(themeGroupPO.getUserID(), themeGroupPO.getThemeGroupName(), id)) {
            throw new ThemeGroupDuplicateNameException();
        }
        String sql = "UPDATE T_QING_Theme_Group SET FName= ?, FModifyDate =?  WHERE FID= ? AND FUserID=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(themeGroupPO.getThemeGroupName());
        params.add(new Date());
        params.add(themeGroupPO.getThemeGroupID());
        params.add(themeGroupPO.getUserID());
        this.dbExcuter.execute(sql, params.toArray());
    }

    @Override
    public void updateThemeGroupForOrder(ThemeGroupPO themeGroupPO) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        String sql = "UPDATE T_QING_Theme_Group SET FOrderID = ?, FModifyDate =?  WHERE FID= ? AND FUserID=?";
        params.add(themeGroupPO.getOrderID());
        params.add(new Date());
        params.add(themeGroupPO.getThemeGroupID());
        params.add(themeGroupPO.getUserID());
        this.dbExcuter.execute(sql, params.toArray());
    }

    @Override
    public void deleteThemeGroup(String userID, String groupID) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_Theme_Group WHERE FUserID = ? AND FID= ?";
        this.dbExcuter.execute(sql, new Object[]{userID, groupID});
    }

    @Override
    public List<ThemeGroupVO> listThemeGroup(final String userID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FName, FOrderID, FCreateDate, FModifyDate FROM T_QING_Theme_Group WHERE FUserID = ? ORDER BY FOrderID DESC, FCreateDate";
        return (List)this.dbExcuter.query(sql, new Object[]{userID}, (ResultHandler)new ResultHandler<List<ThemeGroupVO>>(){

            public List<ThemeGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemeGroupVO> voList = new ArrayList<ThemeGroupVO>(10);
                while (rs.next()) {
                    ThemeGroupVO vo = new ThemeGroupVO();
                    vo.setThemeGroupID(rs.getString("FID"));
                    vo.setThemeGroupName(rs.getString("FName"));
                    vo.setOrderID(rs.getInt("FOrderID"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userID));
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    @Override
    public List<ThemeGroupVO> listPresetThemeGroup() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FName, FOrderID, FCreateDate, FModifyDate FROM T_QING_Theme_Group WHERE FUserID = ? ORDER BY FName";
        return (List)this.dbExcuter.query(sql, new Object[]{IntegratedHelper.getPresetUserId()}, (ResultHandler)new ResultHandler<List<ThemeGroupVO>>(){

            public List<ThemeGroupVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ThemeGroupVO> voList = new ArrayList<ThemeGroupVO>(10);
                while (rs.next()) {
                    ThemeGroupVO vo = new ThemeGroupVO();
                    vo.setThemeGroupID(rs.getString("FID"));
                    vo.setThemeGroupName(rs.getString("FName"));
                    vo.setOrderID(rs.getInt("FOrderID"));
                    vo.setPreset(true);
                    voList.add(vo);
                }
                return voList;
            }
        });
    }

    @Override
    public ThemeGroupVO loadThemeGroupByGroupId(final String userID, String groupID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FName, FCreateDate, FModifyDate FROM T_QING_Theme_Group WHERE FUserID = ? AND FID = ?";
        return (ThemeGroupVO)this.dbExcuter.query(sql, new Object[]{userID, groupID}, (ResultHandler)new ResultHandler<ThemeGroupVO>(){

            public ThemeGroupVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ThemeGroupVO vo = new ThemeGroupVO();
                    vo.setThemeGroupID(rs.getString("FID"));
                    vo.setThemeGroupName(rs.getString("FName"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userID));
                    return vo;
                }
                return null;
            }
        });
    }

    @Override
    public ThemeGroupVO loadThemeGroupByGroupName(final String userID, String themeGroupName) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FName, FID FROM T_QING_Theme_Group WHERE FUserID = ? AND FName = ?";
        return (ThemeGroupVO)this.dbExcuter.query(sql, new Object[]{userID, themeGroupName}, (ResultHandler)new ResultHandler<ThemeGroupVO>(){

            public ThemeGroupVO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ThemeGroupVO vo = new ThemeGroupVO();
                    vo.setThemeGroupID(rs.getString("FID"));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userID));
                    return vo;
                }
                return null;
            }
        });
    }

    @Override
    public boolean checkGoupNameExistForSave(String userID, String name) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FName, FID FROM T_QING_Theme_Group WHERE FUserID = ? AND FName = ?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{userID, name}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    private boolean checkGroupNameExistForUpdate(String userID, String name, String groupId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FName, FID FROM T_QING_Theme_Group WHERE FUserID = ? AND FName = ? and FID != ?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{userID, name, groupId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }
}

