/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.ThemeNotFoundException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.subject.exception.SubjectNotFoundException;
import com.kingdee.bos.qing.subject.exception.SubjectNotOwnException;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.SQLException;
import java.util.List;

public class ThemeDomain {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private IThemeDao iThemeDao;

    public ThemeDomain(QingContext qingContext, IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
        this.qingContext = qingContext;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    public ThemeVO loadThemeIncludePreset(String userID, String themeID) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().loadThemeIncludePreset(userID, themeID);
    }

    public ThemePO getThemeByID(String themeId) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().getThemeByID(themeId);
    }

    public ThemeVO loadThemeByNameAndGroupNameAndType(String userID, String themeGroupName, String themeName, String themeType) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().loadThemeByNameAndGroupNameAndType(userID, themeGroupName, themeName, themeType);
    }

    public ThemePO checkAndReturnOwnTheme(String themeId) throws SubjectNotFoundException, SubjectNotOwnException, AbstractQingIntegratedException, SQLException {
        String userID = this.qingContext.getUserId();
        ThemePO themePO = this.getThemeDao().getThemeByID(themeId);
        if (themePO == null) {
            throw new SubjectNotFoundException(Messages.getMLS((II18nContext)this.qingContext.getIi18nContext(), (String)"SubjectNotFound", (String)"\u5bf9\u5e94\u4e3b\u9898\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
        }
        if (!userID.equals(themePO.getUserID())) {
            throw new SubjectNotOwnException();
        }
        return themePO;
    }

    public List<ThemeVO> listThemesUnionPreset(String userID, String groupID) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().listThemesUnionPreset(userID, groupID);
    }

    public List<ThemeVO> listThemesUnionPreset(String userID, String groupID, String themeType) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().listThemesUnionPreset(userID, groupID, themeType);
    }

    public List<ThemeVO> listUserVisibleThemes(String userID, String groupID) throws AbstractQingIntegratedException, SQLException {
        if (IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter)) {
            return this.getThemeDao().listThemesUnionPreset(userID, groupID);
        }
        return this.getThemeDao().listThemes(userID, groupID);
    }

    public List<ThemeVO> listUserVisibleAllThemes(String userID, List<String> arrGroupID) throws AbstractQingIntegratedException, SQLException {
        if (IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter)) {
            return this.getThemeDao().listAllThemesUnionPreset(userID, arrGroupID);
        }
        return this.getThemeDao().listAllThemes(userID, arrGroupID);
    }

    public List<ThemeVO> listThemes(String userID, String groupID) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().listThemes(userID, groupID);
    }

    public void checkThemePermission(String themeId) throws AbstractQingIntegratedException, SQLException, ThemeNotFoundException {
        String userId = this.qingContext.getUserId();
        int count = this.getThemeDao().queryCount(userId, themeId);
        if (count == 0) {
            throw new ThemeNotFoundException();
        }
    }
}

